/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.utils;

import java.util.Properties;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.sink.utils.HiveSyncContext;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveSyncContext {
    @Test
    void testSyncedPartitions() {
        Configuration configuration1 = new Configuration();
        Configuration configuration2 = new Configuration();
        String hiveSyncPartitionField = "hiveSyncPartitionField";
        String partitionPathField = "partitionPathField";
        configuration1.setString(FlinkOptions.HIVE_SYNC_PARTITION_FIELDS, hiveSyncPartitionField);
        configuration1.setString(FlinkOptions.PARTITION_PATH_FIELD, partitionPathField);
        configuration2.setString(FlinkOptions.PARTITION_PATH_FIELD, partitionPathField);
        Properties props1 = HiveSyncContext.buildSyncConfig((Configuration)configuration1);
        Properties props2 = HiveSyncContext.buildSyncConfig((Configuration)configuration2);
        Assertions.assertEquals((Object)hiveSyncPartitionField, (Object)props1.getProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key()));
        Assertions.assertEquals((Object)partitionPathField, (Object)props2.getProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key()));
    }

    @Test
    void testOptionWithoutShortcutKey() {
        Configuration configuration3 = new Configuration();
        configuration3.setBoolean(HiveSyncConfig.HIVE_CREATE_MANAGED_TABLE.key(), true);
        Properties props3 = HiveSyncContext.buildSyncConfig((Configuration)configuration3);
        Assertions.assertTrue((boolean)Boolean.parseBoolean(props3.getProperty(HiveSyncConfig.HIVE_CREATE_MANAGED_TABLE.key(), "false")));
    }
}

