/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.partitioner;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.client.FlinkTaskContextSupplier;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.sink.partitioner.BucketAssigner;
import org.apache.hudi.sink.partitioner.profile.WriteProfile;
import org.apache.hudi.table.action.commit.BucketInfo;
import org.apache.hudi.table.action.commit.BucketType;
import org.apache.hudi.table.action.commit.SmallFile;
import org.apache.hudi.util.FlinkWriteClients;
import org.apache.hudi.util.StreamerUtil;
import org.apache.hudi.utils.TestConfigurations;
import org.apache.hudi.utils.TestData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestBucketAssigner {
    private HoodieWriteConfig writeConfig;
    private HoodieFlinkEngineContext context;
    private Configuration conf;
    @TempDir
    File tempFile;

    @BeforeEach
    public void before() throws IOException {
        String basePath = this.tempFile.getAbsolutePath();
        this.conf = TestConfigurations.getDefaultConf(basePath);
        this.writeConfig = FlinkWriteClients.getHoodieClientConfig((Configuration)this.conf);
        this.context = new HoodieFlinkEngineContext(new SerializableConfiguration(HadoopConfigurations.getHadoopConf((Configuration)this.conf)), (TaskContextSupplier)new FlinkTaskContextSupplier(null));
        StreamerUtil.initTableIfNotExists((Configuration)this.conf);
    }

    @Test
    void testSmallFilesOfThisTask() {
        MockBucketAssigner mockBucketAssigner1 = new MockBucketAssigner(this.context, this.writeConfig);
        String fileId1 = mockBucketAssigner1.createFileIdOfThisTask();
        SmallFile smallFile1 = new SmallFile();
        smallFile1.location = new HoodieRecordLocation("t0", fileId1);
        smallFile1.sizeBytes = 123L;
        List smallFiles1 = mockBucketAssigner1.smallFilesOfThisTask(Collections.singletonList(smallFile1));
        MatcherAssert.assertThat((Object)smallFiles1.size(), (Matcher)CoreMatchers.is((Object)1));
        MockBucketAssigner mockBucketAssigner2 = new MockBucketAssigner(123, 200, this.context, this.writeConfig, Collections.emptyMap());
        String fileId2 = mockBucketAssigner2.createFileIdOfThisTask();
        SmallFile smallFile2 = new SmallFile();
        smallFile2.location = new HoodieRecordLocation("t0", fileId2);
        smallFile2.sizeBytes = 123L;
        String fileId3 = mockBucketAssigner2.createFileIdOfThisTask();
        SmallFile smallFile3 = new SmallFile();
        smallFile3.location = new HoodieRecordLocation("t0", fileId3);
        smallFile3.sizeBytes = 456L;
        List smallFiles2 = mockBucketAssigner1.smallFilesOfThisTask(Arrays.asList(smallFile2, smallFile3));
        MatcherAssert.assertThat((Object)smallFiles2.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testAddUpdate() {
        MockBucketAssigner mockBucketAssigner = new MockBucketAssigner(this.context, this.writeConfig);
        BucketInfo bucketInfo = mockBucketAssigner.addUpdate("par1", "file_id_0");
        this.assertBucketEquals(bucketInfo, "par1", BucketType.UPDATE, "file_id_0");
        mockBucketAssigner.addUpdate("par1", "file_id_0");
        bucketInfo = mockBucketAssigner.addUpdate("par1", "file_id_0");
        this.assertBucketEquals(bucketInfo, "par1", BucketType.UPDATE, "file_id_0");
        mockBucketAssigner.addUpdate("par1", "file_id_1");
        bucketInfo = mockBucketAssigner.addUpdate("par1", "file_id_1");
        this.assertBucketEquals(bucketInfo, "par1", BucketType.UPDATE, "file_id_1");
        bucketInfo = mockBucketAssigner.addUpdate("par2", "file_id_0");
        this.assertBucketEquals(bucketInfo, "par2", BucketType.UPDATE, "file_id_0");
        bucketInfo = mockBucketAssigner.addUpdate("par3", "file_id_2");
        this.assertBucketEquals(bucketInfo, "par3", BucketType.UPDATE, "file_id_2");
    }

    @Test
    public void testAddInsert() {
        MockBucketAssigner mockBucketAssigner = new MockBucketAssigner(this.context, this.writeConfig);
        BucketInfo bucketInfo = mockBucketAssigner.addInsert("par1");
        this.assertBucketEquals(bucketInfo, "par1", BucketType.INSERT);
        mockBucketAssigner.addInsert("par1");
        bucketInfo = mockBucketAssigner.addInsert("par1");
        this.assertBucketEquals(bucketInfo, "par1", BucketType.INSERT);
        mockBucketAssigner.addInsert("par2");
        bucketInfo = mockBucketAssigner.addInsert("par2");
        this.assertBucketEquals(bucketInfo, "par2", BucketType.INSERT);
        bucketInfo = mockBucketAssigner.addInsert("par3");
        this.assertBucketEquals(bucketInfo, "par3", BucketType.INSERT);
        bucketInfo = mockBucketAssigner.addInsert("par3");
        this.assertBucketEquals(bucketInfo, "par3", BucketType.INSERT);
    }

    @Test
    public void testInsertOverBucketAssigned() {
        this.conf.setInteger(HoodieCompactionConfig.COPY_ON_WRITE_INSERT_SPLIT_SIZE.key(), 2);
        this.writeConfig = FlinkWriteClients.getHoodieClientConfig((Configuration)this.conf);
        MockBucketAssigner mockBucketAssigner = new MockBucketAssigner(this.context, this.writeConfig);
        BucketInfo bucketInfo1 = mockBucketAssigner.addInsert("par1");
        this.assertBucketEquals(bucketInfo1, "par1", BucketType.INSERT);
        BucketInfo bucketInfo2 = mockBucketAssigner.addInsert("par1");
        this.assertBucketEquals(bucketInfo2, "par1", BucketType.INSERT);
        Assertions.assertEquals((Object)bucketInfo1, (Object)bucketInfo2);
        BucketInfo bucketInfo3 = mockBucketAssigner.addInsert("par1");
        this.assertBucketEquals(bucketInfo3, "par1", BucketType.INSERT);
        Assertions.assertNotEquals((Object)bucketInfo1, (Object)bucketInfo3);
    }

    @Test
    public void testInsertWithSmallFiles() {
        SmallFile f0 = new SmallFile();
        f0.location = new HoodieRecordLocation("t0", "f0");
        f0.sizeBytes = 12L;
        SmallFile f1 = new SmallFile();
        f1.location = new HoodieRecordLocation("t0", "f1");
        f1.sizeBytes = 122879L;
        SmallFile f2 = new SmallFile();
        f2.location = new HoodieRecordLocation("t0", "f2");
        f2.sizeBytes = 56L;
        HashMap<String, List<SmallFile>> smallFilesMap = new HashMap<String, List<SmallFile>>();
        smallFilesMap.put("par1", Arrays.asList(f0, f1));
        smallFilesMap.put("par2", Collections.singletonList(f2));
        MockBucketAssigner mockBucketAssigner = new MockBucketAssigner(this.context, this.writeConfig, smallFilesMap);
        BucketInfo bucketInfo = mockBucketAssigner.addInsert("par1");
        this.assertBucketEquals(bucketInfo, "par1", BucketType.UPDATE, "f0");
        mockBucketAssigner.addInsert("par1");
        bucketInfo = mockBucketAssigner.addInsert("par1");
        this.assertBucketEquals(bucketInfo, "par1", BucketType.UPDATE, "f0");
        mockBucketAssigner.addInsert("par2");
        bucketInfo = mockBucketAssigner.addInsert("par2");
        this.assertBucketEquals(bucketInfo, "par2", BucketType.UPDATE, "f2");
        bucketInfo = mockBucketAssigner.addInsert("par3");
        this.assertBucketEquals(bucketInfo, "par3", BucketType.INSERT);
        bucketInfo = mockBucketAssigner.addInsert("par3");
        this.assertBucketEquals(bucketInfo, "par3", BucketType.INSERT);
    }

    @Test
    public void testInsertWithPartialSmallFiles() {
        SmallFile f0 = new SmallFile();
        f0.location = new HoodieRecordLocation("t0", "f0");
        f0.sizeBytes = 12L;
        SmallFile f1 = new SmallFile();
        f1.location = new HoodieRecordLocation("t0", "f1");
        f1.sizeBytes = 122879L;
        SmallFile f2 = new SmallFile();
        f2.location = new HoodieRecordLocation("t0", "f2");
        f2.sizeBytes = 56L;
        HashMap<String, List<SmallFile>> smallFilesMap = new HashMap<String, List<SmallFile>>();
        smallFilesMap.put("par1", Arrays.asList(f0, f1, f2));
        MockBucketAssigner mockBucketAssigner = new MockBucketAssigner(0, 2, this.context, this.writeConfig, smallFilesMap);
        BucketInfo bucketInfo = mockBucketAssigner.addInsert("par1");
        this.assertBucketEquals(bucketInfo, "par1", BucketType.UPDATE, "f2");
        mockBucketAssigner.addInsert("par1");
        bucketInfo = mockBucketAssigner.addInsert("par1");
        this.assertBucketEquals(bucketInfo, "par1", BucketType.UPDATE, "f2");
        bucketInfo = mockBucketAssigner.addInsert("par3");
        this.assertBucketEquals(bucketInfo, "par3", BucketType.INSERT);
        bucketInfo = mockBucketAssigner.addInsert("par3");
        this.assertBucketEquals(bucketInfo, "par3", BucketType.INSERT);
        MockBucketAssigner mockBucketAssigner2 = new MockBucketAssigner(1, 2, this.context, this.writeConfig, smallFilesMap);
        BucketInfo bucketInfo2 = mockBucketAssigner2.addInsert("par1");
        this.assertBucketEquals(bucketInfo2, "par1", BucketType.UPDATE, "f0");
        mockBucketAssigner2.addInsert("par1");
        bucketInfo2 = mockBucketAssigner2.addInsert("par1");
        this.assertBucketEquals(bucketInfo2, "par1", BucketType.UPDATE, "f0");
        bucketInfo2 = mockBucketAssigner2.addInsert("par3");
        this.assertBucketEquals(bucketInfo2, "par3", BucketType.INSERT);
        bucketInfo2 = mockBucketAssigner2.addInsert("par3");
        this.assertBucketEquals(bucketInfo2, "par3", BucketType.INSERT);
    }

    @Test
    public void testUpdateAndInsertWithSmallFiles() {
        SmallFile f0 = new SmallFile();
        f0.location = new HoodieRecordLocation("t0", "f0");
        f0.sizeBytes = 12L;
        SmallFile f1 = new SmallFile();
        f1.location = new HoodieRecordLocation("t0", "f1");
        f1.sizeBytes = 122879L;
        SmallFile f2 = new SmallFile();
        f2.location = new HoodieRecordLocation("t0", "f2");
        f2.sizeBytes = 56L;
        HashMap<String, List<SmallFile>> smallFilesMap = new HashMap<String, List<SmallFile>>();
        smallFilesMap.put("par1", Arrays.asList(f0, f1));
        smallFilesMap.put("par2", Collections.singletonList(f2));
        MockBucketAssigner mockBucketAssigner = new MockBucketAssigner(this.context, this.writeConfig, smallFilesMap);
        mockBucketAssigner.addUpdate("par1", "f0");
        BucketInfo bucketInfo = mockBucketAssigner.addInsert("par1");
        this.assertBucketEquals(bucketInfo, "par1", BucketType.UPDATE, "f0");
        mockBucketAssigner.addInsert("par1");
        bucketInfo = mockBucketAssigner.addInsert("par1");
        this.assertBucketEquals(bucketInfo, "par1", BucketType.UPDATE, "f0");
        mockBucketAssigner.addUpdate("par1", "f2");
        mockBucketAssigner.addInsert("par1");
        bucketInfo = mockBucketAssigner.addInsert("par1");
        this.assertBucketEquals(bucketInfo, "par1", BucketType.UPDATE, "f0");
        mockBucketAssigner.addUpdate("par2", "f0");
        mockBucketAssigner.addInsert("par2");
        bucketInfo = mockBucketAssigner.addInsert("par2");
        this.assertBucketEquals(bucketInfo, "par2", BucketType.UPDATE, "f2");
    }

    @Test
    public void testUpdateAndInsertWithPartialSmallFiles() {
        SmallFile f0 = new SmallFile();
        f0.location = new HoodieRecordLocation("t0", "f0");
        f0.sizeBytes = 12L;
        SmallFile f1 = new SmallFile();
        f1.location = new HoodieRecordLocation("t0", "f1");
        f1.sizeBytes = 122879L;
        SmallFile f2 = new SmallFile();
        f2.location = new HoodieRecordLocation("t0", "f2");
        f2.sizeBytes = 56L;
        HashMap<String, List<SmallFile>> smallFilesMap = new HashMap<String, List<SmallFile>>();
        smallFilesMap.put("par1", Arrays.asList(f0, f1, f2));
        MockBucketAssigner mockBucketAssigner = new MockBucketAssigner(0, 2, this.context, this.writeConfig, smallFilesMap);
        mockBucketAssigner.addUpdate("par1", "f0");
        BucketInfo bucketInfo = mockBucketAssigner.addInsert("par1");
        this.assertBucketEquals(bucketInfo, "par1", BucketType.UPDATE, "f2");
        mockBucketAssigner.addInsert("par1");
        bucketInfo = mockBucketAssigner.addInsert("par1");
        this.assertBucketEquals(bucketInfo, "par1", BucketType.UPDATE, "f2");
        mockBucketAssigner.addUpdate("par1", "f2");
        mockBucketAssigner.addInsert("par1");
        bucketInfo = mockBucketAssigner.addInsert("par1");
        this.assertBucketEquals(bucketInfo, "par1", BucketType.UPDATE, "f2");
        MockBucketAssigner mockBucketAssigner2 = new MockBucketAssigner(1, 2, this.context, this.writeConfig, smallFilesMap);
        mockBucketAssigner2.addUpdate("par1", "f0");
        BucketInfo bucketInfo2 = mockBucketAssigner2.addInsert("par1");
        this.assertBucketEquals(bucketInfo2, "par1", BucketType.UPDATE, "f0");
        mockBucketAssigner2.addInsert("par1");
        bucketInfo2 = mockBucketAssigner2.addInsert("par1");
        this.assertBucketEquals(bucketInfo2, "par1", BucketType.UPDATE, "f0");
        mockBucketAssigner2.addUpdate("par1", "f2");
        mockBucketAssigner2.addInsert("par1");
        bucketInfo2 = mockBucketAssigner2.addInsert("par1");
        this.assertBucketEquals(bucketInfo2, "par1", BucketType.UPDATE, "f0");
    }

    @Test
    public void testWriteProfileReload() throws Exception {
        WriteProfile writeProfile = new WriteProfile(this.writeConfig, this.context);
        List smallFiles1 = writeProfile.getSmallFiles("par1");
        Assertions.assertTrue((boolean)smallFiles1.isEmpty(), (String)"Should have no small files");
        TestData.writeData(TestData.DATA_SET_INSERT, this.conf);
        String instantOption = TestBucketAssigner.getLastCompleteInstant(writeProfile);
        Assertions.assertNull((Object)instantOption);
        writeProfile.reload(1L);
        String instant1 = TestBucketAssigner.getLastCompleteInstant(writeProfile);
        Assertions.assertNotNull((Object)instant1);
        List smallFiles2 = writeProfile.getSmallFiles("par1");
        MatcherAssert.assertThat((String)"Should have 1 small file", (Object)smallFiles2.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((String)"Small file should have same timestamp as last complete instant", (Object)((SmallFile)smallFiles2.get((int)0)).location.getInstantTime(), (Matcher)CoreMatchers.is((Object)instant1));
        TestData.writeData(TestData.DATA_SET_INSERT, this.conf);
        List smallFiles3 = writeProfile.getSmallFiles("par1");
        MatcherAssert.assertThat((String)"Should have 1 small file", (Object)smallFiles3.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((String)"Non-reloaded write profile has the same base file view as before", (Object)((SmallFile)smallFiles3.get((int)0)).location.getInstantTime(), (Matcher)CoreMatchers.is((Object)instant1));
        writeProfile.reload(2L);
        String instant2 = TestBucketAssigner.getLastCompleteInstant(writeProfile);
        Assertions.assertNotEquals((Object)instant2, (Object)instant1, (String)"Should have new complete instant");
        List smallFiles4 = writeProfile.getSmallFiles("par1");
        MatcherAssert.assertThat((String)"Should have 1 small file", (Object)smallFiles4.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((String)"Small file should have same timestamp as last complete instant", (Object)((SmallFile)smallFiles4.get((int)0)).location.getInstantTime(), (Matcher)CoreMatchers.is((Object)instant2));
    }

    @Test
    public void testWriteProfileMetadataCache() throws Exception {
        WriteProfile writeProfile = new WriteProfile(this.writeConfig, this.context);
        Assertions.assertTrue((boolean)writeProfile.getMetadataCache().isEmpty(), (String)"Empty table should no have any instant metadata");
        for (int i = 0; i < 3; ++i) {
            TestData.writeData(TestData.DATA_SET_INSERT, this.conf);
        }
        writeProfile.reload(1L);
        MatcherAssert.assertThat((String)"Metadata cache should have same number entries as timeline instants", (Object)writeProfile.getMetadataCache().size(), (Matcher)CoreMatchers.is((Object)3));
        writeProfile.getSmallFiles("par1");
        MatcherAssert.assertThat((String)"The metadata should be reused", (Object)writeProfile.getMetadataCache().size(), (Matcher)CoreMatchers.is((Object)3));
    }

    private static String getLastCompleteInstant(WriteProfile profile) {
        return StreamerUtil.getLastCompletedInstant((HoodieTableMetaClient)profile.getMetaClient());
    }

    private void assertBucketEquals(BucketInfo bucketInfo, String partition, BucketType bucketType, String fileId) {
        BucketInfo actual = new BucketInfo(bucketType, fileId, partition);
        MatcherAssert.assertThat((Object)bucketInfo, (Matcher)CoreMatchers.is((Object)actual));
    }

    private void assertBucketEquals(BucketInfo bucketInfo, String partition, BucketType bucketType) {
        MatcherAssert.assertThat((Object)bucketInfo.getPartitionPath(), (Matcher)CoreMatchers.is((Object)partition));
        MatcherAssert.assertThat((Object)bucketInfo.getBucketType(), (Matcher)CoreMatchers.is((Object)bucketType));
    }

    static class MockWriteProfile
    extends WriteProfile {
        private final Map<String, List<SmallFile>> smallFilesMap;

        public MockWriteProfile(HoodieWriteConfig config, HoodieFlinkEngineContext context, Map<String, List<SmallFile>> smallFilesMap) {
            super(config, context);
            this.smallFilesMap = smallFilesMap;
        }

        protected List<SmallFile> smallFilesProfile(String partitionPath) {
            if (this.smallFilesMap.containsKey(partitionPath)) {
                return this.smallFilesMap.get(partitionPath);
            }
            return Collections.emptyList();
        }
    }

    static class MockBucketAssigner
    extends BucketAssigner {
        MockBucketAssigner(HoodieFlinkEngineContext context, HoodieWriteConfig config) {
            this(context, config, Collections.emptyMap());
        }

        MockBucketAssigner(HoodieFlinkEngineContext context, HoodieWriteConfig config, Map<String, List<SmallFile>> smallFilesMap) {
            this(0, 1, context, config, smallFilesMap);
        }

        MockBucketAssigner(int taskID, int numTasks, HoodieFlinkEngineContext context, HoodieWriteConfig config, Map<String, List<SmallFile>> smallFilesMap) {
            super(taskID, 1024, numTasks, (WriteProfile)new MockWriteProfile(config, context, smallFilesMap), config);
        }
    }
}

