/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.meta;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.IntStream;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.sink.meta.CkpMetadata;
import org.apache.hudi.util.StreamerUtil;
import org.apache.hudi.utils.TestConfigurations;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestCkpMetadata {
    private CkpMetadata metadata;
    @TempDir
    File tempFile;

    @BeforeEach
    public void beforeEach() throws Exception {
        String basePath = this.tempFile.getAbsolutePath();
        FileSystem fs = FSUtils.getFs((String)this.tempFile.getAbsolutePath(), (org.apache.hadoop.conf.Configuration)HadoopConfigurations.getHadoopConf((Configuration)new Configuration()));
        Configuration conf = TestConfigurations.getDefaultConf(basePath);
        StreamerUtil.initTableIfNotExists((Configuration)conf);
        this.metadata = CkpMetadata.getInstance((FileSystem)fs, (String)basePath);
    }

    @Test
    void testWriteAndReadMessage() {
        IntStream.range(0, 3).forEach(i -> this.metadata.startInstant(i + ""));
        MatcherAssert.assertThat((Object)this.metadata.lastPendingInstant(), (Matcher)CoreMatchers.is((Object)"2"));
        this.metadata.commitInstant("2");
        MatcherAssert.assertThat((Object)this.metadata.lastPendingInstant(), (Matcher)CoreMatchers.equalTo(null));
        IntStream.range(3, 6).forEach(i -> this.metadata.startInstant(i + ""));
        MatcherAssert.assertThat((Object)this.metadata.getMessages().size(), (Matcher)CoreMatchers.is((Object)3));
        this.metadata.commitInstant("6");
        this.metadata.abortInstant("7");
        MatcherAssert.assertThat((Object)this.metadata.getMessages().size(), (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    void testBootstrap() throws Exception {
        CkpMetadata metadata = this.getCkpMetadata("");
        IntStream.range(0, 4).forEach(i -> metadata.startInstant(i + ""));
        MatcherAssert.assertThat((String)"The first instant should be removed from the instant cache", (Object)metadata.getInstantCache(), (Matcher)CoreMatchers.is(Arrays.asList("1", "2", "3")));
        CkpMetadata metadata1 = this.getCkpMetadata("");
        metadata1.bootstrap();
        Assertions.assertNull((Object)metadata1.getInstantCache(), (String)"The instant cache should be recovered from bootstrap");
        metadata1.startInstant("4");
        MatcherAssert.assertThat((String)"The first instant should be removed from the instant cache", (Object)metadata1.getInstantCache(), (Matcher)CoreMatchers.is(Collections.singletonList("4")));
    }

    private CkpMetadata getCkpMetadata(String uniqueId) {
        String basePath = this.tempFile.getAbsolutePath();
        FileSystem fs = FSUtils.getFs((String)basePath, (org.apache.hadoop.conf.Configuration)HadoopConfigurations.getHadoopConf((Configuration)new Configuration()));
        return CkpMetadata.getInstance((FileSystem)fs, (String)basePath);
    }
}

