/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.utils;

import java.util.Properties;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.aws.sync.AwsGlueCatalogSyncTool;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.hive.ddl.HiveSyncMode;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.table.format.FilePathUtils;
import org.apache.hudi.util.StreamerUtil;

public class HiveSyncContext {
    private final Properties props;
    private final HiveConf hiveConf;

    private HiveSyncContext(Properties props, HiveConf hiveConf) {
        this.props = props;
        this.hiveConf = hiveConf;
    }

    public HiveSyncTool hiveSyncTool() {
        HiveSyncMode syncMode = HiveSyncMode.of((String)this.props.getProperty(HiveSyncConfigHolder.HIVE_SYNC_MODE.key()));
        if (syncMode == HiveSyncMode.GLUE) {
            return new AwsGlueCatalogSyncTool(this.props, (org.apache.hadoop.conf.Configuration)this.hiveConf);
        }
        return new HiveSyncTool(this.props, (org.apache.hadoop.conf.Configuration)this.hiveConf);
    }

    public static HiveSyncContext create(Configuration conf, SerializableConfiguration serConf) {
        Properties props = HiveSyncContext.buildSyncConfig(conf);
        org.apache.hadoop.conf.Configuration hadoopConf = HadoopConfigurations.getHadoopConf(conf);
        HiveConf hiveConf = new HiveConf();
        hiveConf.addResource(serConf.get());
        if (!FlinkOptions.isDefaultValueDefined(conf, FlinkOptions.HIVE_SYNC_METASTORE_URIS)) {
            hadoopConf.set(HiveConf.ConfVars.METASTOREURIS.varname, conf.getString(FlinkOptions.HIVE_SYNC_METASTORE_URIS));
        }
        hiveConf.addResource(hadoopConf);
        return new HiveSyncContext(props, hiveConf);
    }

    @VisibleForTesting
    public static Properties buildSyncConfig(Configuration conf) {
        TypedProperties props = StreamerUtil.flinkConf2TypedProperties(conf);
        props.setPropertyIfNonNull(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), (Object)conf.getString(FlinkOptions.PATH));
        props.setPropertyIfNonNull(HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT.key(), (Object)conf.getString(FlinkOptions.HIVE_SYNC_FILE_FORMAT));
        props.setPropertyIfNonNull(HiveSyncConfigHolder.HIVE_USE_PRE_APACHE_INPUT_FORMAT.key(), (Object)"false");
        props.setPropertyIfNonNull(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), (Object)conf.getString(FlinkOptions.HIVE_SYNC_DB));
        props.setPropertyIfNonNull(HoodieSyncConfig.META_SYNC_TABLE_NAME.key(), (Object)conf.getString(FlinkOptions.HIVE_SYNC_TABLE));
        props.setPropertyIfNonNull(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), (Object)conf.getString(FlinkOptions.HIVE_SYNC_MODE));
        props.setPropertyIfNonNull(HiveSyncConfigHolder.HIVE_USER.key(), (Object)conf.getString(FlinkOptions.HIVE_SYNC_USERNAME));
        props.setPropertyIfNonNull(HiveSyncConfigHolder.HIVE_PASS.key(), (Object)conf.getString(FlinkOptions.HIVE_SYNC_PASSWORD));
        props.setPropertyIfNonNull(HiveSyncConfigHolder.HIVE_URL.key(), (Object)conf.getString(FlinkOptions.HIVE_SYNC_JDBC_URL));
        props.setPropertyIfNonNull(HiveSyncConfigHolder.METASTORE_URIS.key(), (Object)conf.getString(FlinkOptions.HIVE_SYNC_METASTORE_URIS));
        props.setPropertyIfNonNull(HiveSyncConfigHolder.HIVE_TABLE_PROPERTIES.key(), (Object)conf.getString(FlinkOptions.HIVE_SYNC_TABLE_PROPERTIES));
        props.setPropertyIfNonNull(HiveSyncConfigHolder.HIVE_TABLE_SERDE_PROPERTIES.key(), (Object)conf.getString(FlinkOptions.HIVE_SYNC_TABLE_SERDE_PROPERTIES));
        props.setPropertyIfNonNull(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), (Object)String.join((CharSequence)",", FilePathUtils.extractHivePartitionFields(conf)));
        props.setPropertyIfNonNull(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), (Object)conf.getString(FlinkOptions.HIVE_SYNC_PARTITION_EXTRACTOR_CLASS_NAME));
        props.setPropertyIfNonNull(HiveSyncConfigHolder.HIVE_USE_JDBC.key(), (Object)String.valueOf(conf.getBoolean(FlinkOptions.HIVE_SYNC_USE_JDBC)));
        props.setPropertyIfNonNull(HoodieSyncConfig.META_SYNC_USE_FILE_LISTING_FROM_METADATA.key(), (Object)String.valueOf(conf.getBoolean(FlinkOptions.METADATA_ENABLED)));
        props.setPropertyIfNonNull(HiveSyncConfigHolder.HIVE_IGNORE_EXCEPTIONS.key(), (Object)String.valueOf(conf.getBoolean(FlinkOptions.HIVE_SYNC_IGNORE_EXCEPTIONS)));
        props.setPropertyIfNonNull(HiveSyncConfigHolder.HIVE_SUPPORT_TIMESTAMP_TYPE.key(), (Object)String.valueOf(conf.getBoolean(FlinkOptions.HIVE_SYNC_SUPPORT_TIMESTAMP)));
        props.setPropertyIfNonNull(HiveSyncConfigHolder.HIVE_AUTO_CREATE_DATABASE.key(), (Object)String.valueOf(conf.getBoolean(FlinkOptions.HIVE_SYNC_AUTO_CREATE_DB)));
        props.setPropertyIfNonNull(HoodieSyncConfig.META_SYNC_DECODE_PARTITION.key(), (Object)String.valueOf(conf.getBoolean(FlinkOptions.URL_ENCODE_PARTITIONING)));
        props.setPropertyIfNonNull(HiveSyncConfigHolder.HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE.key(), (Object)String.valueOf(conf.getBoolean(FlinkOptions.HIVE_SYNC_SKIP_RO_SUFFIX)));
        props.setPropertyIfNonNull(HoodieSyncConfig.META_SYNC_ASSUME_DATE_PARTITION.key(), (Object)String.valueOf(conf.getBoolean(FlinkOptions.HIVE_SYNC_ASSUME_DATE_PARTITION)));
        return props;
    }
}

