/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiPredicate;
import org.apache.avro.Schema;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.FlinkTaskContextSupplier;
import org.apache.hudi.client.HoodieFlinkWriteClient;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.client.transaction.lock.FileSystemBasedLockProvider;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieMemoryConfig;
import org.apache.hudi.config.HoodiePayloadConfig;
import org.apache.hudi.config.HoodieStorageConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.configuration.OptionsResolver;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.schema.FilebasedSchemaProvider;
import org.apache.hudi.sink.transform.ChainedTransformer;
import org.apache.hudi.sink.transform.Transformer;
import org.apache.hudi.streamer.FlinkStreamerConfig;
import org.apache.hudi.table.action.cluster.ClusteringPlanPartitionFilterMode;
import org.apache.hudi.table.action.compact.CompactionTriggerStrategy;
import org.apache.hudi.util.ViewStorageProperties;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StreamerUtil.class);

    public static TypedProperties appendKafkaProps(FlinkStreamerConfig config) {
        TypedProperties properties = StreamerUtil.getProps(config);
        properties.put((Object)"bootstrap.servers", (Object)config.kafkaBootstrapServers);
        properties.put((Object)"group.id", (Object)config.kafkaGroupId);
        return properties;
    }

    public static TypedProperties getProps(FlinkStreamerConfig cfg) {
        if (cfg.propsFilePath.isEmpty()) {
            return new TypedProperties();
        }
        return StreamerUtil.readConfig(HadoopConfigurations.getHadoopConf(cfg), new Path(cfg.propsFilePath), cfg.configs).getProps();
    }

    public static Schema getSourceSchema(Configuration conf) {
        if (conf.getOptional(FlinkOptions.SOURCE_AVRO_SCHEMA_PATH).isPresent()) {
            return new FilebasedSchemaProvider(conf).getSourceSchema();
        }
        if (conf.getOptional(FlinkOptions.SOURCE_AVRO_SCHEMA).isPresent()) {
            String schemaStr = (String)conf.get(FlinkOptions.SOURCE_AVRO_SCHEMA);
            return new Schema.Parser().parse(schemaStr);
        }
        String errorMsg = String.format("Either option '%s' or '%s' should be specified for avro schema deserialization", FlinkOptions.SOURCE_AVRO_SCHEMA_PATH.key(), FlinkOptions.SOURCE_AVRO_SCHEMA.key());
        throw new HoodieException(errorMsg);
    }

    public static DFSPropertiesConfiguration readConfig(org.apache.hadoop.conf.Configuration hadoopConfig, Path cfgPath, List<String> overriddenProps) {
        DFSPropertiesConfiguration conf = new DFSPropertiesConfiguration(hadoopConfig, cfgPath);
        try {
            if (!overriddenProps.isEmpty()) {
                LOG.info("Adding overridden properties to file properties.");
                conf.addPropsFromStream(new BufferedReader(new StringReader(String.join((CharSequence)"\n", overriddenProps))));
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Unexpected error adding config overrides", ioe);
        }
        return conf;
    }

    public static HoodieWriteConfig getHoodieClientConfig(Configuration conf) {
        return StreamerUtil.getHoodieClientConfig(conf, false, false);
    }

    public static HoodieWriteConfig getHoodieClientConfig(Configuration conf, boolean loadFsViewStorageConfig) {
        return StreamerUtil.getHoodieClientConfig(conf, false, loadFsViewStorageConfig);
    }

    public static HoodieWriteConfig getHoodieClientConfig(Configuration conf, boolean enableEmbeddedTimelineService, boolean loadFsViewStorageConfig) {
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withEngineType(EngineType.FLINK).withPath(conf.getString(FlinkOptions.PATH)).combineInput(conf.getBoolean(FlinkOptions.PRE_COMBINE), true).withMergeAllowDuplicateOnInserts(OptionsResolver.insertClustering(conf)).withClusteringConfig(HoodieClusteringConfig.newBuilder().withAsyncClustering(Boolean.valueOf(conf.getBoolean(FlinkOptions.CLUSTERING_ASYNC_ENABLED))).withClusteringPlanStrategyClass(conf.getString(FlinkOptions.CLUSTERING_PLAN_STRATEGY_CLASS)).withClusteringPlanPartitionFilterMode(ClusteringPlanPartitionFilterMode.valueOf((String)conf.getString(FlinkOptions.CLUSTERING_PLAN_PARTITION_FILTER_MODE_NAME))).withClusteringTargetPartitions(conf.getInteger(FlinkOptions.CLUSTERING_TARGET_PARTITIONS)).withClusteringMaxNumGroups(conf.getInteger(FlinkOptions.CLUSTERING_MAX_NUM_GROUPS)).withClusteringTargetFileMaxBytes(conf.getLong(FlinkOptions.CLUSTERING_PLAN_STRATEGY_TARGET_FILE_MAX_BYTES)).withClusteringPlanSmallFileLimit(conf.getLong(FlinkOptions.CLUSTERING_PLAN_STRATEGY_SMALL_FILE_LIMIT) * 1024L * 1024L).withClusteringSkipPartitionsFromLatest(conf.getInteger(FlinkOptions.CLUSTERING_PLAN_STRATEGY_SKIP_PARTITIONS_FROM_LATEST)).withAsyncClusteringMaxCommits(conf.getInteger(FlinkOptions.CLUSTERING_DELTA_COMMITS)).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withAsyncClean(Boolean.valueOf(conf.getBoolean(FlinkOptions.CLEAN_ASYNC_ENABLED))).retainCommits(conf.getInteger(FlinkOptions.CLEAN_RETAIN_COMMITS)).retainFileVersions(conf.getInteger(FlinkOptions.CLEAN_RETAIN_FILE_VERSIONS)).withCleanerParallelism(20).withCleanerPolicy(HoodieCleaningPolicy.valueOf((String)conf.getString(FlinkOptions.CLEAN_POLICY))).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(conf.getInteger(FlinkOptions.ARCHIVE_MIN_COMMITS), conf.getInteger(FlinkOptions.ARCHIVE_MAX_COMMITS)).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().withTargetIOPerCompactionInMB(conf.getLong(FlinkOptions.COMPACTION_TARGET_IO)).withInlineCompactionTriggerStrategy(CompactionTriggerStrategy.valueOf((String)conf.getString(FlinkOptions.COMPACTION_TRIGGER_STRATEGY).toUpperCase(Locale.ROOT))).withMaxNumDeltaCommitsBeforeCompaction(conf.getInteger(FlinkOptions.COMPACTION_DELTA_COMMITS)).withMaxDeltaSecondsBeforeCompaction(conf.getInteger(FlinkOptions.COMPACTION_DELTA_SECONDS)).build()).withMemoryConfig(HoodieMemoryConfig.newBuilder().withMaxMemoryMaxSize((long)(conf.getInteger(FlinkOptions.WRITE_MERGE_MAX_MEMORY) * 1024) * 1024L, (long)(conf.getInteger(FlinkOptions.COMPACTION_MAX_MEMORY) * 1024) * 1024L).build()).forTable(conf.getString(FlinkOptions.TABLE_NAME)).withStorageConfig(HoodieStorageConfig.newBuilder().logFileDataBlockMaxSize(conf.getInteger(FlinkOptions.WRITE_LOG_BLOCK_SIZE) * 1024 * 1024).logFileMaxSize(conf.getLong(FlinkOptions.WRITE_LOG_MAX_SIZE) * 1024L * 1024L).parquetBlockSize(conf.getInteger(FlinkOptions.WRITE_PARQUET_BLOCK_SIZE) * 1024 * 1024).parquetPageSize(conf.getInteger(FlinkOptions.WRITE_PARQUET_PAGE_SIZE) * 1024 * 1024).parquetMaxFileSize((long)(conf.getInteger(FlinkOptions.WRITE_PARQUET_MAX_FILE_SIZE) * 1024) * 1024L).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(conf.getBoolean(FlinkOptions.METADATA_ENABLED)).withMaxNumDeltaCommitsBeforeCompaction(conf.getInteger(FlinkOptions.METADATA_COMPACTION_DELTA_COMMITS)).build()).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(FileSystemBasedLockProvider.class).withLockWaitTimeInMillis(Long.valueOf(2000L)).withFileSystemLockExpire(Integer.valueOf(1)).withClientNumRetries(30).withFileSystemLockPath(StreamerUtil.getAuxiliaryPath(conf)).build()).withPayloadConfig(StreamerUtil.getPayloadConfig(conf)).withEmbeddedTimelineServerEnabled(enableEmbeddedTimelineService).withEmbeddedTimelineServerReuseEnabled(true).withAutoCommit(false).withAllowOperationMetadataField(conf.getBoolean(FlinkOptions.CHANGELOG_ENABLED)).withProps((Map)StreamerUtil.flinkConf2TypedProperties(conf)).withSchema(StreamerUtil.getSourceSchema(conf).toString());
        HoodieWriteConfig writeConfig = builder.build();
        if (loadFsViewStorageConfig) {
            FileSystemViewStorageConfig viewStorageConfig = ViewStorageProperties.loadFromProperties(conf.getString(FlinkOptions.PATH), conf);
            writeConfig.setViewStorageConfig(viewStorageConfig);
        }
        return writeConfig;
    }

    public static HoodiePayloadConfig getPayloadConfig(Configuration conf) {
        return HoodiePayloadConfig.newBuilder().withPayloadClass(conf.getString(FlinkOptions.PAYLOAD_CLASS_NAME)).withPayloadOrderingField(conf.getString(FlinkOptions.PRECOMBINE_FIELD)).withPayloadEventTimeField(conf.getString(FlinkOptions.PRECOMBINE_FIELD)).withPayloadClass(conf.getString(FlinkOptions.PAYLOAD_CLASS_NAME)).build();
    }

    public static TypedProperties flinkConf2TypedProperties(Configuration conf) {
        Configuration flatConf = FlinkOptions.flatOptions(conf);
        Properties properties = new Properties();
        flatConf.addAllToProperties(properties);
        for (ConfigOption<?> option : FlinkOptions.optionalOptions()) {
            if (flatConf.contains(option) || !option.hasDefaultValue()) continue;
            properties.put(option.key(), option.defaultValue());
        }
        return new TypedProperties(properties);
    }

    public static void checkRequiredProperties(TypedProperties props, List<String> checkPropNames) {
        checkPropNames.forEach(prop -> Preconditions.checkState((boolean)props.containsKey(prop), (Object)("Required property " + prop + " is missing")));
    }

    public static HoodieTableMetaClient initTableIfNotExists(Configuration conf) throws IOException {
        return StreamerUtil.initTableIfNotExists(conf, HadoopConfigurations.getHadoopConf(conf));
    }

    public static HoodieTableMetaClient initTableIfNotExists(Configuration conf, org.apache.hadoop.conf.Configuration hadoopConf) throws IOException {
        String basePath = conf.getString(FlinkOptions.PATH);
        if (!StreamerUtil.tableExists(basePath, hadoopConf)) {
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.withPropertyBuilder().setTableCreateSchema(conf.getString(FlinkOptions.SOURCE_AVRO_SCHEMA)).setTableType(conf.getString(FlinkOptions.TABLE_TYPE)).setTableName(conf.getString(FlinkOptions.TABLE_NAME)).setRecordKeyFields(conf.getString(FlinkOptions.RECORD_KEY_FIELD, null)).setPayloadClassName(conf.getString(FlinkOptions.PAYLOAD_CLASS_NAME)).setPreCombineField(OptionsResolver.getPreCombineField(conf)).setArchiveLogFolder((String)HoodieTableConfig.ARCHIVELOG_FOLDER.defaultValue()).setPartitionFields(conf.getString(FlinkOptions.PARTITION_PATH_FIELD, null)).setKeyGeneratorClassProp(conf.getOptional(FlinkOptions.KEYGEN_CLASS_NAME).orElse(SimpleAvroKeyGenerator.class.getName())).setHiveStylePartitioningEnable(Boolean.valueOf(conf.getBoolean(FlinkOptions.HIVE_STYLE_PARTITIONING))).setUrlEncodePartitioning(Boolean.valueOf(conf.getBoolean(FlinkOptions.URL_ENCODE_PARTITIONING))).setTimelineLayoutVersion(Integer.valueOf(1)).initTable(hadoopConf, basePath);
            LOG.info("Table initialized under base path {}", (Object)basePath);
            return metaClient;
        }
        LOG.info("Table [{}/{}] already exists, no need to initialize the table", (Object)basePath, (Object)conf.getString(FlinkOptions.TABLE_NAME));
        return StreamerUtil.createMetaClient(basePath, hadoopConf);
    }

    public static boolean tableExists(String basePath, org.apache.hadoop.conf.Configuration hadoopConf) {
        FileSystem fs = FSUtils.getFs((String)basePath, (org.apache.hadoop.conf.Configuration)hadoopConf);
        try {
            return fs.exists(new Path(basePath, ".hoodie"));
        }
        catch (IOException e) {
            throw new HoodieException("Error while checking whether table exists under path:" + basePath, (Throwable)e);
        }
    }

    public static String generateBucketKey(String partitionPath, String fileId) {
        return String.format("%s_%s", partitionPath, fileId);
    }

    public static HoodieTableMetaClient metaClientForReader(Configuration conf, org.apache.hadoop.conf.Configuration hadoopConf) {
        String basePath = conf.getString(FlinkOptions.PATH);
        if (conf.getBoolean(FlinkOptions.READ_AS_STREAMING) && !StreamerUtil.tableExists(basePath, hadoopConf)) {
            return null;
        }
        return StreamerUtil.createMetaClient(basePath, hadoopConf);
    }

    public static HoodieTableMetaClient createMetaClient(String basePath, org.apache.hadoop.conf.Configuration hadoopConf) {
        return HoodieTableMetaClient.builder().setBasePath(basePath).setConf(hadoopConf).build();
    }

    public static HoodieTableMetaClient createMetaClient(Configuration conf) {
        return StreamerUtil.createMetaClient(conf.getString(FlinkOptions.PATH), HadoopConfigurations.getHadoopConf(conf));
    }

    public static HoodieFlinkWriteClient createWriteClient(Configuration conf, RuntimeContext runtimeContext) {
        return StreamerUtil.createWriteClient(conf, runtimeContext, true);
    }

    public static HoodieFlinkWriteClient createWriteClient(Configuration conf, RuntimeContext runtimeContext, boolean loadFsViewStorageConfig) {
        HoodieFlinkEngineContext context = new HoodieFlinkEngineContext(new SerializableConfiguration(HadoopConfigurations.getHadoopConf(conf)), (TaskContextSupplier)new FlinkTaskContextSupplier(runtimeContext));
        HoodieWriteConfig writeConfig = StreamerUtil.getHoodieClientConfig(conf, loadFsViewStorageConfig);
        return new HoodieFlinkWriteClient((HoodieEngineContext)context, writeConfig);
    }

    public static HoodieFlinkWriteClient createWriteClient(Configuration conf) throws IOException {
        HoodieWriteConfig writeConfig = StreamerUtil.getHoodieClientConfig(conf, true, false);
        HoodieFlinkWriteClient writeClient = new HoodieFlinkWriteClient((HoodieEngineContext)HoodieFlinkEngineContext.DEFAULT, writeConfig);
        FileSystemViewStorageConfig viewStorageConfig = writeConfig.getViewStorageConfig();
        FileSystemViewStorageConfig rebuilt = FileSystemViewStorageConfig.newBuilder().withStorageType(viewStorageConfig.getStorageType()).withRemoteServerHost(viewStorageConfig.getRemoteViewServerHost()).withRemoteServerPort(viewStorageConfig.getRemoteViewServerPort()).withRemoteTimelineClientTimeoutSecs(viewStorageConfig.getRemoteTimelineClientTimeoutSecs()).withRemoteTimelineClientRetry(viewStorageConfig.isRemoteTimelineClientRetryEnabled()).withRemoteTimelineClientMaxRetryNumbers(viewStorageConfig.getRemoteTimelineClientMaxRetryNumbers()).withRemoteTimelineInitialRetryIntervalMs(viewStorageConfig.getRemoteTimelineInitialRetryIntervalMs()).withRemoteTimelineClientMaxRetryIntervalMs(viewStorageConfig.getRemoteTimelineClientMaxRetryIntervalMs()).withRemoteTimelineClientRetryExceptions(viewStorageConfig.getRemoteTimelineClientRetryExceptions()).build();
        ViewStorageProperties.createProperties(conf.getString(FlinkOptions.PATH), rebuilt, conf);
        return writeClient;
    }

    public static Option<String> medianInstantTime(String highVal, String lowVal) {
        try {
            long high = HoodieActiveTimeline.parseDateFromInstantTime((String)highVal).getTime();
            long low = HoodieActiveTimeline.parseDateFromInstantTime((String)lowVal).getTime();
            ValidationUtils.checkArgument((high > low ? 1 : 0) != 0, (String)("Instant [" + highVal + "] should have newer timestamp than instant [" + lowVal + "]"));
            long median = low + (high - low) / 2L;
            String instantTime = HoodieActiveTimeline.formatDate((Date)new Date(median));
            if (HoodieTimeline.compareTimestamps((String)lowVal, (BiPredicate)HoodieTimeline.GREATER_THAN_OR_EQUALS, (String)instantTime) || HoodieTimeline.compareTimestamps((String)highVal, (BiPredicate)HoodieTimeline.LESSER_THAN_OR_EQUALS, (String)instantTime)) {
                return Option.empty();
            }
            return Option.of((Object)instantTime);
        }
        catch (ParseException e) {
            throw new HoodieException("Get median instant time with interval [" + lowVal + ", " + highVal + "] error", (Throwable)e);
        }
    }

    public static long instantTimeDiffSeconds(String newInstantTime, String oldInstantTime) {
        try {
            long newTimestamp = HoodieActiveTimeline.parseDateFromInstantTime((String)newInstantTime).getTime();
            long oldTimestamp = HoodieActiveTimeline.parseDateFromInstantTime((String)oldInstantTime).getTime();
            return (newTimestamp - oldTimestamp) / 1000L;
        }
        catch (ParseException e) {
            throw new HoodieException("Get instant time diff with interval [" + oldInstantTime + ", " + newInstantTime + "] error", (Throwable)e);
        }
    }

    public static Option<Transformer> createTransformer(List<String> classNames) throws IOException {
        try {
            ArrayList<Transformer> transformers = new ArrayList<Transformer>();
            for (String className : (List)Option.ofNullable(classNames).orElse(Collections.emptyList())) {
                transformers.add((Transformer)ReflectionUtils.loadClass((String)className));
            }
            return transformers.isEmpty() ? Option.empty() : Option.of((Object)new ChainedTransformer(transformers));
        }
        catch (Throwable e) {
            throw new IOException("Could not load transformer class(es) " + classNames, e);
        }
    }

    public static boolean isValidFile(FileStatus fileStatus) {
        String extension = FSUtils.getFileExtension((String)fileStatus.getPath().toString());
        if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
            return fileStatus.getLen() > (long)ParquetFileWriter.MAGIC.length;
        }
        if (HoodieFileFormat.ORC.getFileExtension().equals(extension)) {
            return fileStatus.getLen() > (long)"ORC".length();
        }
        if (HoodieFileFormat.HOODIE_LOG.getFileExtension().equals(extension)) {
            return fileStatus.getLen() > (long)HoodieLogFormat.MAGIC.length;
        }
        return fileStatus.getLen() > 0L;
    }

    public static String getLastPendingInstant(HoodieTableMetaClient metaClient) {
        return StreamerUtil.getLastPendingInstant(metaClient, true);
    }

    public static String getLastPendingInstant(HoodieTableMetaClient metaClient, boolean reloadTimeline) {
        if (reloadTimeline) {
            metaClient.reloadActiveTimeline();
        }
        return (String)metaClient.getCommitsTimeline().filterPendingExcludingCompaction().lastInstant().map(HoodieInstant::getTimestamp).orElse(null);
    }

    public static String getLastCompletedInstant(HoodieTableMetaClient metaClient) {
        return (String)metaClient.getCommitsTimeline().filterCompletedInstants().lastInstant().map(HoodieInstant::getTimestamp).orElse(null);
    }

    public static boolean haveSuccessfulCommits(HoodieTableMetaClient metaClient) {
        return !metaClient.getCommitsTimeline().filterCompletedInstants().empty();
    }

    public static long getMaxCompactionMemoryInBytes(Configuration conf) {
        return (long)conf.getInteger(FlinkOptions.COMPACTION_MAX_MEMORY) * 1024L * 1024L;
    }

    public static Schema getTableAvroSchema(HoodieTableMetaClient metaClient, boolean includeMetadataFields) throws Exception {
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        return schemaUtil.getTableAvroSchema(includeMetadataFields);
    }

    public static Schema getLatestTableSchema(String path, org.apache.hadoop.conf.Configuration hadoopConf) {
        if (StringUtils.isNullOrEmpty((String)path) || !StreamerUtil.tableExists(path, hadoopConf)) {
            return null;
        }
        try {
            HoodieTableMetaClient metaClient = StreamerUtil.createMetaClient(path, hadoopConf);
            return StreamerUtil.getTableAvroSchema(metaClient, false);
        }
        catch (Exception e) {
            LOG.warn("Error while resolving the latest table schema", (Throwable)e);
            return null;
        }
    }

    public static boolean fileExists(FileSystem fs, Path path) {
        try {
            return fs.exists(path);
        }
        catch (IOException e) {
            throw new HoodieException("Exception while checking file " + path + " existence", (Throwable)e);
        }
    }

    public static String getAuxiliaryPath(Configuration conf) {
        return conf.getString(FlinkOptions.PATH) + "/" + ".hoodie/.aux";
    }
}

