/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;
import org.apache.flink.contrib.streaming.state.EmbeddedRocksDBStateBackend;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.hashmap.HashMapStateBackend;
import org.apache.hudi.exception.HoodieException;

public class FlinkStateBackendConverter
implements IStringConverter<StateBackend> {
    public StateBackend convert(String value) throws ParameterException {
        switch (value) {
            case "hashmap": {
                return new HashMapStateBackend();
            }
            case "rocksdb": {
                return new EmbeddedRocksDBStateBackend();
            }
        }
        throw new HoodieException(String.format("Unknown flink state backend %s. Supports only hashmap and rocksdb by now", value));
    }
}

