/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;

public class DataTypeUtils {
    public static boolean isTimestampType(DataType type) {
        return type.getLogicalType().getTypeRoot() == LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE;
    }

    public static int precision(LogicalType logicalType) {
        if (logicalType instanceof TimestampType) {
            return ((TimestampType)logicalType).getPrecision();
        }
        if (logicalType instanceof LocalZonedTimestampType) {
            return ((LocalZonedTimestampType)logicalType).getPrecision();
        }
        throw new AssertionError((Object)("Unexpected type: " + logicalType));
    }

    public static boolean isDateType(DataType type) {
        return type.getLogicalType().getTypeRoot() == LogicalTypeRoot.DATE;
    }

    public static boolean isDatetimeType(DataType type) {
        return DataTypeUtils.isTimestampType(type) || DataTypeUtils.isDateType(type);
    }

    public static RowType.RowField[] projectRowFields(RowType rowType, String[] names) {
        int[] fieldIndices = Arrays.stream(names).mapToInt(arg_0 -> ((RowType)rowType).getFieldIndex(arg_0)).toArray();
        return (RowType.RowField[])Arrays.stream(fieldIndices).mapToObj(i -> (RowType.RowField)rowType.getFields().get(i)).toArray(RowType.RowField[]::new);
    }

    public static boolean isFamily(LogicalType logicalType, LogicalTypeFamily family) {
        return logicalType.getTypeRoot().getFamilies().contains(family);
    }

    public static Object resolvePartition(String partition, DataType type) {
        if (partition == null) {
            return null;
        }
        LogicalTypeRoot typeRoot = type.getLogicalType().getTypeRoot();
        switch (typeRoot) {
            case CHAR: 
            case VARCHAR: {
                return partition;
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(partition);
            }
            case TINYINT: {
                return Integer.valueOf(partition).byteValue();
            }
            case SMALLINT: {
                return Short.valueOf(partition);
            }
            case INTEGER: {
                return Integer.valueOf(partition);
            }
            case BIGINT: {
                return Long.valueOf(partition);
            }
            case FLOAT: {
                return Float.valueOf(partition);
            }
            case DOUBLE: {
                return Double.valueOf(partition);
            }
            case DATE: {
                return LocalDate.parse(partition);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return LocalDateTime.parse(partition);
            }
            case DECIMAL: {
                return new BigDecimal(partition);
            }
        }
        throw new RuntimeException(String.format("Can not convert %s to type %s for partition value", partition, type));
    }
}

