/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.catalog;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.exception.HoodieException;

public class CatalogOptions {
    public static final String HIVE_SITE_FILE = "hive-site.xml";
    public static final String DEFAULT_DB = "default";
    public static final ConfigOption<String> CATALOG_PATH = ConfigOptions.key((String)"catalog.path").stringType().noDefaultValue().withDescription("Catalog base DFS path, used for inferring the sink table path. The default strategy for a table path is: ${catalog.path}/${db_name}/${table_name}");
    public static final ConfigOption<String> DEFAULT_DATABASE = ConfigOptions.key((String)"default-database").stringType().defaultValue((Object)"default");
    public static final ConfigOption<String> HIVE_CONF_DIR = ConfigOptions.key((String)"hive.conf.dir").stringType().noDefaultValue();
    public static final ConfigOption<String> MODE = ConfigOptions.key((String)"mode").stringType().defaultValue((Object)"dfs");
    public static final ConfigOption<Boolean> TABLE_EXTERNAL = ConfigOptions.key((String)"table.external").booleanType().defaultValue((Object)false).withDescription("Whether the table is external, default false");

    public static List<ConfigOption<?>> allOptions() {
        Field[] declaredFields = CatalogOptions.class.getDeclaredFields();
        ArrayList options = new ArrayList();
        for (Field field : declaredFields) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(ConfigOption.class)) continue;
            try {
                options.add((ConfigOption)field.get(ConfigOption.class));
            }
            catch (IllegalAccessException e) {
                throw new HoodieException("Error while fetching static config option", (Throwable)e);
            }
        }
        return options;
    }

    public static Map<String, String> tableCommonOptions(Configuration catalogOptions) {
        Configuration copied = new Configuration(catalogOptions);
        copied.removeConfig(DEFAULT_DATABASE);
        copied.removeConfig(CATALOG_PATH);
        return copied.toMap();
    }
}

