/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.partitioner.profile;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.core.fs.Path;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.sink.partitioner.profile.DeltaWriteProfile;
import org.apache.hudi.sink.partitioner.profile.EmptyWriteProfile;
import org.apache.hudi.sink.partitioner.profile.WriteProfile;
import org.apache.hudi.util.StreamerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteProfiles {
    private static final Logger LOG = LoggerFactory.getLogger(WriteProfiles.class);
    private static final Map<String, WriteProfile> PROFILES = new HashMap<String, WriteProfile>();

    private WriteProfiles() {
    }

    public static synchronized WriteProfile singleton(boolean ignoreSmallFiles, boolean delta, HoodieWriteConfig config, HoodieFlinkEngineContext context) {
        return PROFILES.computeIfAbsent(config.getBasePath(), k -> WriteProfiles.getWriteProfile(ignoreSmallFiles, delta, config, context));
    }

    private static WriteProfile getWriteProfile(boolean ignoreSmallFiles, boolean delta, HoodieWriteConfig config, HoodieFlinkEngineContext context) {
        if (ignoreSmallFiles) {
            return new EmptyWriteProfile(config, context);
        }
        if (delta) {
            return new DeltaWriteProfile(config, context);
        }
        return new WriteProfile(config, context);
    }

    public static void clean(String path) {
        PROFILES.remove(path);
    }

    public static FileStatus[] getRawWritePathsOfInstants(Path basePath, Configuration hadoopConf, List<HoodieCommitMetadata> metadataList, HoodieTableType tableType) {
        HashMap uniqueIdToFileStatus = new HashMap();
        metadataList.forEach(metadata -> uniqueIdToFileStatus.putAll(WriteProfiles.getFilesToReadOfInstant(basePath, metadata, hadoopConf, tableType)));
        return uniqueIdToFileStatus.values().toArray(new FileStatus[0]);
    }

    public static FileStatus[] getWritePathsOfInstants(Path basePath, Configuration hadoopConf, List<HoodieCommitMetadata> metadataList, HoodieTableType tableType) {
        FileSystem fs = FSUtils.getFs((String)basePath.toString(), (Configuration)hadoopConf);
        HashMap uniqueIdToFileStatus = new HashMap();
        metadataList.forEach(metadata -> uniqueIdToFileStatus.putAll(WriteProfiles.getFilesToReadOfInstant(basePath, metadata, fs, tableType)));
        return uniqueIdToFileStatus.values().toArray(new FileStatus[0]);
    }

    private static Map<String, FileStatus> getFilesToReadOfInstant(Path basePath, HoodieCommitMetadata metadata, Configuration hadoopConf, HoodieTableType tableType) {
        return WriteProfiles.getFilesToRead(hadoopConf, metadata, basePath.toString(), tableType).entrySet().stream().filter(entry -> StreamerUtil.isValidFile((FileStatus)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<String, FileStatus> getFilesToReadOfInstant(Path basePath, HoodieCommitMetadata metadata, FileSystem fs, HoodieTableType tableType) {
        return WriteProfiles.getFilesToRead(fs.getConf(), metadata, basePath.toString(), tableType).entrySet().stream().filter(entry -> {
            try {
                return fs.exists(((FileStatus)entry.getValue()).getPath());
            }
            catch (IOException e) {
                LOG.error("Checking exists of path: {} error", (Object)((FileStatus)entry.getValue()).getPath());
                throw new HoodieException((Throwable)e);
            }
        }).filter(entry -> StreamerUtil.isValidFile((FileStatus)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<String, FileStatus> getFilesToRead(Configuration hadoopConf, HoodieCommitMetadata metadata, String basePath, HoodieTableType tableType) {
        switch (tableType) {
            case COPY_ON_WRITE: {
                return metadata.getFileIdToFileStatus(hadoopConf, basePath);
            }
            case MERGE_ON_READ: {
                return metadata.getFullPathToFileStatus(hadoopConf, basePath);
            }
        }
        throw new AssertionError();
    }

    public static Option<HoodieCommitMetadata> getCommitMetadataSafely(String tableName, Path basePath, HoodieInstant instant, HoodieTimeline timeline) {
        try {
            byte[] data = (byte[])timeline.getInstantDetails(instant).get();
            return Option.of((Object)HoodieCommitMetadata.fromBytes((byte[])data, HoodieCommitMetadata.class));
        }
        catch (FileNotFoundException fe) {
            LOG.warn("Instant {} was deleted by the cleaner, ignore", (Object)instant.getTimestamp());
            return Option.empty();
        }
        catch (Throwable throwable) {
            LOG.error("Get write metadata for table {} with instant {} and path: {} error", new Object[]{tableName, instant.getTimestamp(), basePath});
            return Option.empty();
        }
    }

    public static HoodieCommitMetadata getCommitMetadata(String tableName, Path basePath, HoodieInstant instant, HoodieTimeline timeline) {
        try {
            return HoodieInputFormatUtils.getCommitMetadata((HoodieInstant)instant, (HoodieTimeline)timeline);
        }
        catch (IOException e) {
            LOG.error("Get write metadata for table {} with instant {} and path: {} error", new Object[]{tableName, instant.getTimestamp(), basePath});
            throw new HoodieException((Throwable)e);
        }
    }
}

