/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.client.FlinkTaskContextSupplier;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.table.HoodieFlinkTable;
import org.apache.hudi.util.StreamerUtil;

public class FlinkTables {
    private FlinkTables() {
    }

    public static HoodieFlinkTable<?> createTable(Configuration conf, RuntimeContext runtimeContext) {
        HoodieFlinkEngineContext context = new HoodieFlinkEngineContext(new SerializableConfiguration(HadoopConfigurations.getHadoopConf(conf)), (TaskContextSupplier)new FlinkTaskContextSupplier(runtimeContext));
        HoodieWriteConfig writeConfig = StreamerUtil.getHoodieClientConfig(conf, true);
        return HoodieFlinkTable.create((HoodieWriteConfig)writeConfig, (HoodieFlinkEngineContext)context);
    }

    public static HoodieFlinkTable<?> createTable(HoodieWriteConfig writeConfig, org.apache.hadoop.conf.Configuration hadoopConf, RuntimeContext runtimeContext) {
        HoodieFlinkEngineContext context = new HoodieFlinkEngineContext(new SerializableConfiguration(hadoopConf), (TaskContextSupplier)new FlinkTaskContextSupplier(runtimeContext));
        return HoodieFlinkTable.create((HoodieWriteConfig)writeConfig, (HoodieFlinkEngineContext)context);
    }

    public static HoodieFlinkTable<?> createTable(Configuration conf) {
        HoodieWriteConfig writeConfig = StreamerUtil.getHoodieClientConfig(conf, true, false);
        return HoodieFlinkTable.create((HoodieWriteConfig)writeConfig, (HoodieFlinkEngineContext)HoodieFlinkEngineContext.DEFAULT);
    }
}

