/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source.stats;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.util.ExpressionUtils;

public class ExpressionEvaluator {
    private static final int IN_PREDICATE_LIMIT = 200;

    public static boolean filterExprs(List<ResolvedExpression> filters, RowData indexRow, RowType.RowField[] queryFields) {
        for (ResolvedExpression filter : filters) {
            if (Evaluator.bindCall((CallExpression)filter, indexRow, queryFields).eval()) continue;
            return false;
        }
        return true;
    }

    private static int compare(@NotNull Object val1, @NotNull Object val2, LogicalType logicalType) {
        switch (logicalType.getTypeRoot()) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: {
                return ((Long)val1).compareTo((Long)val2);
            }
            case BOOLEAN: {
                return ((Boolean)val1).compareTo((Boolean)val2);
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: {
                return ((Integer)val1).compareTo((Integer)val2);
            }
            case FLOAT: {
                return ((Float)val1).compareTo((Float)val2);
            }
            case DOUBLE: {
                return ((Double)val1).compareTo((Double)val2);
            }
            case BINARY: 
            case VARBINARY: {
                return ExpressionEvaluator.compareBytes((byte[])val1, (byte[])val2);
            }
            case CHAR: 
            case VARCHAR: {
                return ((String)val1).compareTo((String)val2);
            }
            case DECIMAL: {
                return ((BigDecimal)val1).compareTo((BigDecimal)val2);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + logicalType);
    }

    private static int compareBytes(byte[] v1, byte[] v2) {
        int len1 = v1.length;
        int len2 = v2.length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            byte c1 = v1[k];
            byte c2 = v2[k];
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    private static Object[] getInLiteralVals(List<Expression> childExprs) {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (int i = 1; i < childExprs.size(); ++i) {
            vals.add(ExpressionUtils.getValueFromLiteral((ValueLiteralExpression)childExprs.get(i)));
        }
        return vals.toArray();
    }

    private static Object getValAsJavaObj(RowData indexRow, int pos, LogicalType colType) {
        switch (colType.getTypeRoot()) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: {
                return indexRow.getLong(pos);
            }
            case BOOLEAN: {
                return indexRow.getBoolean(pos);
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: {
                return indexRow.getInt(pos);
            }
            case FLOAT: {
                return Float.valueOf(indexRow.getFloat(pos));
            }
            case DOUBLE: {
                return indexRow.getDouble(pos);
            }
            case BINARY: 
            case VARBINARY: {
                return indexRow.getBinary(pos);
            }
            case CHAR: 
            case VARCHAR: {
                return indexRow.getString(pos).toString();
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)colType;
                return indexRow.getDecimal(pos, decimalType.getPrecision(), decimalType.getScale()).toBigDecimal();
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + colType);
    }

    public static class Or
    extends Evaluator {
        private Evaluator[] evaluators;

        public static Or getInstance() {
            return new Or();
        }

        @Override
        public boolean eval() {
            for (Evaluator evaluator : this.evaluators) {
                if (!evaluator.eval()) continue;
                return true;
            }
            return false;
        }

        public Evaluator bindEvaluator(Evaluator ... evaluators) {
            this.evaluators = evaluators;
            return this;
        }
    }

    public static class And
    extends Evaluator {
        private Evaluator[] evaluators;

        public static And getInstance() {
            return new And();
        }

        @Override
        public boolean eval() {
            for (Evaluator evaluator : this.evaluators) {
                if (evaluator.eval()) continue;
                return false;
            }
            return true;
        }

        public Evaluator bindEvaluator(Evaluator ... evaluators) {
            this.evaluators = evaluators;
            return this;
        }
    }

    public static class Not
    extends Evaluator {
        private Evaluator evaluator;

        public static Not getInstance() {
            return new Not();
        }

        @Override
        public boolean eval() {
            return !this.evaluator.eval();
        }

        public Evaluator bindEvaluator(Evaluator evaluator) {
            this.evaluator = evaluator;
            return this;
        }
    }

    public static class In
    extends Evaluator {
        private Object[] vals;

        public static In getInstance() {
            return new In();
        }

        @Override
        public boolean eval() {
            if (this.minVal == null) {
                return false;
            }
            if (this.vals.length > 200) {
                return true;
            }
            this.vals = Arrays.stream(this.vals).filter(v -> ExpressionEvaluator.compare(this.minVal, v, this.type) <= 0).toArray();
            if (this.vals.length == 0) {
                return false;
            }
            this.vals = Arrays.stream(this.vals).filter(v -> ExpressionEvaluator.compare(this.maxVal, v, this.type) >= 0).toArray();
            return this.vals.length != 0;
        }

        public void bindVals(Object ... vals) {
            this.vals = vals;
        }
    }

    public static class GreaterThanOrEqual
    extends Evaluator {
        public static GreaterThanOrEqual getInstance() {
            return new GreaterThanOrEqual();
        }

        @Override
        public boolean eval() {
            if (this.maxVal == null) {
                return false;
            }
            return ExpressionEvaluator.compare(this.maxVal, this.val, this.type) >= 0;
        }
    }

    public static class LessThanOrEqual
    extends Evaluator {
        public static LessThanOrEqual getInstance() {
            return new LessThanOrEqual();
        }

        @Override
        public boolean eval() {
            if (this.minVal == null) {
                return false;
            }
            return ExpressionEvaluator.compare(this.minVal, this.val, this.type) <= 0;
        }
    }

    public static class GreaterThan
    extends Evaluator {
        public static GreaterThan getInstance() {
            return new GreaterThan();
        }

        @Override
        public boolean eval() {
            if (this.maxVal == null) {
                return false;
            }
            return ExpressionEvaluator.compare(this.maxVal, this.val, this.type) > 0;
        }
    }

    public static class LessThan
    extends Evaluator {
        public static LessThan getInstance() {
            return new LessThan();
        }

        @Override
        public boolean eval() {
            if (this.minVal == null) {
                return false;
            }
            return ExpressionEvaluator.compare(this.minVal, this.val, this.type) < 0;
        }
    }

    public static class IsNotNull
    extends Evaluator {
        public static IsNotNull getInstance() {
            return new IsNotNull();
        }

        @Override
        public boolean eval() {
            return this.minVal != null || this.nullCnt <= 0L;
        }
    }

    public static class IsNull
    extends Evaluator {
        public static IsNull getInstance() {
            return new IsNull();
        }

        @Override
        public boolean eval() {
            return this.nullCnt > 0L;
        }
    }

    public static class NotEqualTo
    extends Evaluator {
        public static NotEqualTo getInstance() {
            return new NotEqualTo();
        }

        @Override
        public boolean eval() {
            return true;
        }
    }

    public static class EqualTo
    extends Evaluator {
        public static EqualTo getInstance() {
            return new EqualTo();
        }

        @Override
        public boolean eval() {
            if (this.minVal == null || this.maxVal == null || this.val == null) {
                return false;
            }
            if (ExpressionEvaluator.compare(this.minVal, this.val, this.type) > 0) {
                return false;
            }
            return ExpressionEvaluator.compare(this.maxVal, this.val, this.type) >= 0;
        }
    }

    public static abstract class Evaluator {
        protected Object val;
        protected Object minVal;
        protected Object maxVal;
        protected long nullCnt = 0L;
        protected LogicalType type;

        public static Evaluator bindCall(CallExpression call, RowData indexRow, RowType.RowField[] queryFields) {
            Evaluator evaluator;
            FunctionDefinition funDef = call.getFunctionDefinition();
            List childExprs = call.getChildren();
            boolean normalized = childExprs.get(0) instanceof FieldReferenceExpression;
            if (BuiltInFunctionDefinitions.NOT.equals(funDef)) {
                Not evaluator2 = Not.getInstance();
                Evaluator childEvaluator = Evaluator.bindCall((CallExpression)childExprs.get(0), indexRow, queryFields);
                return evaluator2.bindEvaluator(childEvaluator);
            }
            if (BuiltInFunctionDefinitions.AND.equals(funDef)) {
                And evaluator3 = And.getInstance();
                Evaluator evaluator1 = Evaluator.bindCall((CallExpression)childExprs.get(0), indexRow, queryFields);
                Evaluator evaluator2 = Evaluator.bindCall((CallExpression)childExprs.get(1), indexRow, queryFields);
                return evaluator3.bindEvaluator(evaluator1, evaluator2);
            }
            if (BuiltInFunctionDefinitions.OR.equals(funDef)) {
                Or evaluator4 = Or.getInstance();
                Evaluator evaluator1 = Evaluator.bindCall((CallExpression)childExprs.get(0), indexRow, queryFields);
                Evaluator evaluator2 = Evaluator.bindCall((CallExpression)childExprs.get(1), indexRow, queryFields);
                return evaluator4.bindEvaluator(evaluator1, evaluator2);
            }
            if (BuiltInFunctionDefinitions.IN.equals(funDef)) {
                ValidationUtils.checkState((boolean)normalized, (String)"The IN expression expects to be normalized");
                In evaluator5 = In.getInstance();
                FieldReferenceExpression rExpr = (FieldReferenceExpression)childExprs.get(0);
                evaluator5.bindFieldReference(rExpr);
                evaluator5.bindVals(ExpressionEvaluator.getInLiteralVals(childExprs));
                return evaluator5.bindColStats(indexRow, queryFields, rExpr);
            }
            if (BuiltInFunctionDefinitions.IS_NULL.equals(funDef)) {
                FieldReferenceExpression rExpr = (FieldReferenceExpression)childExprs.get(0);
                return IsNull.getInstance().bindFieldReference(rExpr).bindColStats(indexRow, queryFields, rExpr);
            }
            if (BuiltInFunctionDefinitions.IS_NOT_NULL.equals(funDef)) {
                FieldReferenceExpression rExpr = (FieldReferenceExpression)childExprs.get(0);
                return IsNotNull.getInstance().bindFieldReference(rExpr).bindColStats(indexRow, queryFields, rExpr);
            }
            if (BuiltInFunctionDefinitions.EQUALS.equals(funDef)) {
                evaluator = EqualTo.getInstance();
            } else if (BuiltInFunctionDefinitions.NOT_EQUALS.equals(funDef)) {
                evaluator = NotEqualTo.getInstance();
            } else if (BuiltInFunctionDefinitions.LESS_THAN.equals(funDef)) {
                evaluator = normalized ? LessThan.getInstance() : GreaterThan.getInstance();
            } else if (BuiltInFunctionDefinitions.GREATER_THAN.equals(funDef)) {
                evaluator = normalized ? GreaterThan.getInstance() : LessThan.getInstance();
            } else if (BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL.equals(funDef)) {
                evaluator = normalized ? LessThanOrEqual.getInstance() : GreaterThanOrEqual.getInstance();
            } else if (BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL.equals(funDef)) {
                evaluator = normalized ? GreaterThanOrEqual.getInstance() : LessThanOrEqual.getInstance();
            } else {
                throw new AssertionError((Object)("Unexpected function definition " + funDef));
            }
            FieldReferenceExpression rExpr = normalized ? (FieldReferenceExpression)childExprs.get(0) : (FieldReferenceExpression)childExprs.get(1);
            ValueLiteralExpression vExpr = normalized ? (ValueLiteralExpression)childExprs.get(1) : (ValueLiteralExpression)childExprs.get(0);
            evaluator.bindFieldReference(rExpr).bindVal(vExpr).bindColStats(indexRow, queryFields, rExpr);
            return evaluator;
        }

        public Evaluator bindColStats(RowData indexRow, RowType.RowField[] queryFields, FieldReferenceExpression expr) {
            int colPos = -1;
            for (int i = 0; i < queryFields.length; ++i) {
                if (!expr.getName().equals(queryFields[i].getName())) continue;
                colPos = i;
            }
            ValidationUtils.checkState((colPos != -1 ? 1 : 0) != 0, (String)("Can not find column " + expr.getName()));
            int startPos = 2 + colPos * 3;
            LogicalType colType = queryFields[colPos].getType();
            Object minVal = indexRow.isNullAt(startPos) ? null : ExpressionEvaluator.getValAsJavaObj(indexRow, startPos, colType);
            Object maxVal = indexRow.isNullAt(startPos + 1) ? null : ExpressionEvaluator.getValAsJavaObj(indexRow, startPos + 1, colType);
            long nullCnt = indexRow.getLong(startPos + 2);
            this.minVal = minVal;
            this.maxVal = maxVal;
            this.nullCnt = nullCnt;
            return this;
        }

        public Evaluator bindVal(ValueLiteralExpression vExpr) {
            this.val = ExpressionUtils.getValueFromLiteral(vExpr);
            return this;
        }

        public Evaluator bindFieldReference(FieldReferenceExpression expr) {
            this.type = expr.getOutputDataType().getLogicalType();
            return this;
        }

        public abstract boolean eval();
    }
}

