/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.compact.strategy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.sink.compact.FlinkCompactionConfig;
import org.apache.hudi.sink.compact.strategy.CompactionPlanStrategy;
import org.apache.hudi.util.CompactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionPlanStrategies {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionPlanStrategies.class);

    private CompactionPlanStrategies() {
    }

    public static CompactionPlanStrategy getStrategy(FlinkCompactionConfig config) {
        switch (config.compactionPlanSelectStrategy.toLowerCase(Locale.ROOT)) {
            case "all": {
                return pendingCompactionTimeline -> pendingCompactionTimeline.getInstants().collect(Collectors.toList());
            }
            case "instants": {
                return pendingCompactionTimeline -> {
                    if (StringUtils.isNullOrEmpty((String)config.compactionPlanInstant)) {
                        LOG.warn("None instant is selected");
                        return Collections.emptyList();
                    }
                    List<String> instants = Arrays.asList(config.compactionPlanInstant.split(","));
                    return pendingCompactionTimeline.getInstants().filter(instant -> instants.contains(instant.getTimestamp())).collect(Collectors.toList());
                };
            }
            case "num_instants": {
                return pendingCompactionTimeline -> {
                    List pendingCompactionPlanInstants = pendingCompactionTimeline.getInstants().collect(Collectors.toList());
                    if (CompactionUtil.isLIFO(config.compactionSeq)) {
                        Collections.reverse(pendingCompactionPlanInstants);
                    }
                    int range = Math.min(config.maxNumCompactionPlans, pendingCompactionPlanInstants.size());
                    return pendingCompactionPlanInstants.subList(0, range);
                };
            }
        }
        throw new UnsupportedOperationException("Unknown compaction plan strategy: " + config.compactionPlanSelectStrategy + ", supported strategies:[num_instants,instants,all]");
    }
}

