/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.bucket;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.io.storage.row.HoodieRowDataCreateHandle;
import org.apache.hudi.sink.bulk.BulkInsertWriterHelper;
import org.apache.hudi.sink.bulk.RowDataKeyGen;
import org.apache.hudi.sink.bulk.sort.SortOperatorGen;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketBulkInsertWriterHelper
extends BulkInsertWriterHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BucketBulkInsertWriterHelper.class);
    public static final String FILE_GROUP_META_FIELD = "_fg";
    private final int recordArity;
    private String lastFileId;

    public BucketBulkInsertWriterHelper(Configuration conf, HoodieTable<?, ?, ?, ?> hoodieTable, HoodieWriteConfig writeConfig, String instantTime, int taskPartitionId, long taskId, long taskEpochId, RowType rowType) {
        super(conf, hoodieTable, writeConfig, instantTime, taskPartitionId, taskId, taskEpochId, rowType);
        this.recordArity = rowType.getFieldCount();
    }

    @Override
    public void write(RowData tuple) throws IOException {
        try {
            RowData record = tuple.getRow(1, this.recordArity);
            String recordKey = this.keyGen.getRecordKey(record);
            String partitionPath = this.keyGen.getPartitionPath(record);
            String fileId = tuple.getString(0).toString();
            if (this.lastFileId == null || !this.lastFileId.equals(fileId)) {
                LOG.info("Creating new file for partition path " + partitionPath);
                this.handle = this.getRowCreateHandle(partitionPath, fileId);
                this.lastFileId = fileId;
            }
            this.handle.write(recordKey, partitionPath, record);
        }
        catch (Throwable throwable) {
            LOG.error("Global error thrown while trying to write records in HoodieRowDataCreateHandle", throwable);
            throw throwable;
        }
    }

    private HoodieRowDataCreateHandle getRowCreateHandle(String partitionPath, String fileId) throws IOException {
        if (!this.handles.containsKey(fileId)) {
            if (this.isInputSorted.booleanValue()) {
                this.close();
            }
            HoodieRowDataCreateHandle rowCreateHandle = new HoodieRowDataCreateHandle(this.hoodieTable, this.writeConfig, partitionPath, fileId, this.instantTime, this.taskPartitionId, this.taskId, this.taskEpochId, this.rowType);
            this.handles.put(fileId, rowCreateHandle);
        }
        return (HoodieRowDataCreateHandle)this.handles.get(fileId);
    }

    public static SortOperatorGen getFileIdSorterGen(RowType rowType) {
        return new SortOperatorGen(rowType, new String[]{FILE_GROUP_META_FIELD});
    }

    private static String getFileId(Map<String, String> bucketIdToFileId, RowDataKeyGen keyGen, RowData record, String indexKeys, int numBuckets) {
        String recordKey = keyGen.getRecordKey(record);
        String partition = keyGen.getPartitionPath(record);
        int bucketNum = BucketIdentifier.getBucketId((String)recordKey, (String)indexKeys, (int)numBuckets);
        String bucketId = partition + bucketNum;
        return bucketIdToFileId.computeIfAbsent(bucketId, k -> BucketIdentifier.newBucketFileIdPrefix((int)bucketNum));
    }

    public static RowData rowWithFileId(Map<String, String> bucketIdToFileId, RowDataKeyGen keyGen, RowData record, String indexKeys, int numBuckets) {
        String fileId = BucketBulkInsertWriterHelper.getFileId(bucketIdToFileId, keyGen, record, indexKeys, numBuckets);
        return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)fileId), record});
    }

    public static RowType rowTypeWithFileId(RowType rowType) {
        LogicalType[] types = new LogicalType[]{DataTypes.STRING().getLogicalType(), rowType};
        String[] names = new String[]{FILE_GROUP_META_FIELD, "record"};
        return RowType.of((LogicalType[])types, (String[])names);
    }
}

