/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils.factory;

import java.util.Collections;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.utils.source.ContinuousFileSource;

public class ContinuousFileSourceFactory
implements DynamicTableSourceFactory {
    public static final String FACTORY_ID = "continuous-file-source";
    public static final ConfigOption<Integer> CHECKPOINTS = ConfigOptions.key((String)"checkpoints").intType().defaultValue((Object)2).withDescription("Number of checkpoints to write the data set as, default 2");

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validate();
        Configuration conf = (Configuration)helper.getOptions();
        Path path = new Path((String)conf.getOptional(FlinkOptions.PATH).orElseThrow(() -> new ValidationException("Option [path] should be not empty.")));
        return new ContinuousFileSource(context.getCatalogTable().getResolvedSchema(), path, conf);
    }

    public String factoryIdentifier() {
        return FACTORY_ID;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.singleton(FlinkOptions.PATH);
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.singleton(CHECKPOINTS);
    }
}

