/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.io.File;
import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.util.ViewStorageProperties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestViewStorageProperties {
    @TempDir
    File tempFile;

    @Test
    void testReadWriteProperties() throws IOException {
        String basePath = this.tempFile.getAbsolutePath();
        FileSystemViewStorageConfig config = FileSystemViewStorageConfig.newBuilder().withStorageType(FileSystemViewStorageType.SPILLABLE_DISK).withRemoteServerHost("host1").withRemoteServerPort(Integer.valueOf(1234)).build();
        Configuration flinkConfig = new Configuration();
        ViewStorageProperties.createProperties((String)basePath, (FileSystemViewStorageConfig)config, (Configuration)flinkConfig);
        ViewStorageProperties.createProperties((String)basePath, (FileSystemViewStorageConfig)config, (Configuration)flinkConfig);
        ViewStorageProperties.createProperties((String)basePath, (FileSystemViewStorageConfig)config, (Configuration)flinkConfig);
        FileSystemViewStorageConfig readConfig = ViewStorageProperties.loadFromProperties((String)basePath, (Configuration)new Configuration());
        MatcherAssert.assertThat((Object)readConfig.getStorageType(), (Matcher)CoreMatchers.is((Object)FileSystemViewStorageType.SPILLABLE_DISK));
        MatcherAssert.assertThat((Object)readConfig.getRemoteViewServerHost(), (Matcher)CoreMatchers.is((Object)"host1"));
        MatcherAssert.assertThat((Object)readConfig.getRemoteViewServerPort(), (Matcher)CoreMatchers.is((Object)1234));
    }
}

