/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.io.File;
import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.util.StreamerUtil;
import org.apache.hudi.util.ViewStorageProperties;
import org.apache.hudi.utils.TestConfigurations;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestStreamerUtil {
    @TempDir
    File tempFile;

    @Test
    void testInitTableIfNotExists() throws IOException {
        Configuration conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath());
        conf.setString(FlinkOptions.PRECOMBINE_FIELD, "ts");
        conf.setString(FlinkOptions.PARTITION_PATH_FIELD, "p0,p1");
        StreamerUtil.initTableIfNotExists((Configuration)conf);
        HoodieTableMetaClient metaClient1 = HoodieTableMetaClient.builder().setBasePath(this.tempFile.getAbsolutePath()).setConf(new org.apache.hadoop.conf.Configuration()).build();
        Assertions.assertTrue((boolean)metaClient1.getTableConfig().getPartitionFields().isPresent(), (String)"Missing partition columns in the hoodie.properties.");
        Assertions.assertArrayEquals((Object[])((Object[])metaClient1.getTableConfig().getPartitionFields().get()), (Object[])new String[]{"p0", "p1"});
        Assertions.assertEquals((Object)metaClient1.getTableConfig().getPreCombineField(), (Object)"ts");
        conf.removeConfig(FlinkOptions.PARTITION_PATH_FIELD);
        FileIOUtils.deleteDirectory((File)this.tempFile);
        StreamerUtil.initTableIfNotExists((Configuration)conf);
        HoodieTableMetaClient metaClient2 = HoodieTableMetaClient.builder().setBasePath(this.tempFile.getAbsolutePath()).setConf(new org.apache.hadoop.conf.Configuration()).build();
        Assertions.assertFalse((boolean)metaClient2.getTableConfig().getPartitionFields().isPresent());
    }

    @Test
    void testMedianInstantTime() {
        String higher = "20210705125921";
        String lower = "20210705125806";
        String expectedMedianInstant = "20210705125844499";
        String median1 = (String)StreamerUtil.medianInstantTime((String)higher, (String)lower).get();
        MatcherAssert.assertThat((Object)median1, (Matcher)CoreMatchers.is((Object)expectedMedianInstant));
        Assertions.assertThrows(IllegalArgumentException.class, () -> StreamerUtil.medianInstantTime((String)lower, (String)higher), (String)"The first argument should have newer instant time");
        Assertions.assertFalse((boolean)StreamerUtil.medianInstantTime((String)"20211116115634", (String)"20211116115633").isPresent());
    }

    @Test
    void testInstantTimeDiff() {
        String higher = "20210705125921";
        String lower = "20210705125806";
        long diff = StreamerUtil.instantTimeDiffSeconds((String)higher, (String)lower);
        MatcherAssert.assertThat((Object)diff, (Matcher)CoreMatchers.is((Object)75L));
    }

    @Test
    void testDumpRemoteViewStorageConfig() throws IOException {
        Configuration conf = TestConfigurations.getDefaultConf(this.tempFile.getAbsolutePath());
        StreamerUtil.createWriteClient((Configuration)conf);
        FileSystemViewStorageConfig storageConfig = ViewStorageProperties.loadFromProperties((String)conf.getString(FlinkOptions.PATH), (Configuration)new Configuration());
        MatcherAssert.assertThat((Object)storageConfig.getStorageType(), (Matcher)CoreMatchers.is((Object)FileSystemViewStorageType.REMOTE_FIRST));
    }
}

