/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import org.apache.avro.Schema;
import org.apache.flink.table.types.DataType;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.util.AvroSchemaConverter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class TestAvroSchemaConverter {
    @Test
    void testUnionSchemaWithMultipleRecordTypes() {
        Schema schema = HoodieMetadataRecord.SCHEMA$;
        DataType dataType = AvroSchemaConverter.convertToDataType((Schema)schema);
        int pos = HoodieMetadataRecord.SCHEMA$.getField("ColumnStatsMetadata").pos();
        String expected = "ROW<`fileName` STRING, `columnName` STRING, `minValue` ROW<`wrapper` RAW('java.lang.Object', ?) NOT NULL>, `maxValue` ROW<`wrapper` RAW('java.lang.Object', ?) NOT NULL>, `valueCount` BIGINT, `nullCount` BIGINT, `totalSize` BIGINT, `totalUncompressedSize` BIGINT, `isDeleted` BOOLEAN NOT NULL>";
        MatcherAssert.assertThat((Object)((DataType)dataType.getChildren().get(pos)).toString(), (Matcher)CoreMatchers.is((Object)"ROW<`fileName` STRING, `columnName` STRING, `minValue` ROW<`wrapper` RAW('java.lang.Object', ?) NOT NULL>, `maxValue` ROW<`wrapper` RAW('java.lang.Object', ?) NOT NULL>, `valueCount` BIGINT, `nullCount` BIGINT, `totalSize` BIGINT, `totalUncompressedSize` BIGINT, `isDeleted` BOOLEAN NOT NULL>"));
    }
}

