/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.catalog;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.exception.HoodieCatalogException;
import org.apache.hudi.table.catalog.CatalogOptions;
import org.apache.hudi.table.catalog.HoodieCatalogTestUtils;
import org.apache.hudi.table.catalog.HoodieHiveCatalog;
import org.apache.hudi.util.StreamerUtil;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHoodieHiveCatalog {
    TableSchema schema = TableSchema.builder().field("uuid", (DataType)DataTypes.INT().notNull()).field("name", DataTypes.STRING()).field("age", DataTypes.INT()).field("par1", DataTypes.STRING()).field("ts", DataTypes.BIGINT()).primaryKey(new String[]{"uuid"}).build();
    List<String> partitions = Collections.singletonList("par1");
    private static HoodieHiveCatalog hoodieCatalog;
    private final ObjectPath tablePath = new ObjectPath("default", "test");

    @BeforeAll
    public static void createCatalog() {
        hoodieCatalog = HoodieCatalogTestUtils.createHiveCatalog();
        hoodieCatalog.open();
    }

    @AfterEach
    public void dropTable() throws TableNotExistException {
        hoodieCatalog.dropTable(this.tablePath, true);
    }

    @AfterAll
    public static void closeCatalog() {
        if (hoodieCatalog != null) {
            hoodieCatalog.close();
        }
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testCreateAndGetHoodieTable(HoodieTableType tableType) throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(FactoryUtil.CONNECTOR.key(), "hudi");
        options.put(FlinkOptions.TABLE_TYPE.key(), tableType.toString());
        CatalogTableImpl table = new CatalogTableImpl(this.schema, this.partitions, options, "hudi table");
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
        CatalogBaseTable table1 = hoodieCatalog.getTable(this.tablePath);
        Assertions.assertEquals((Object)"hudi", table1.getOptions().get(FactoryUtil.CONNECTOR.key()));
        Assertions.assertEquals((Object)tableType.toString(), table1.getOptions().get(FlinkOptions.TABLE_TYPE.key()));
        Assertions.assertEquals((Object)"uuid", table1.getOptions().get(FlinkOptions.RECORD_KEY_FIELD.key()));
        Assertions.assertNull(table1.getOptions().get(FlinkOptions.PRECOMBINE_FIELD.key()), (String)"preCombine key is not declared");
        Assertions.assertEquals(Collections.singletonList("uuid"), (Object)((Schema.UnresolvedPrimaryKey)table1.getUnresolvedSchema().getPrimaryKey().get()).getColumnNames());
        Assertions.assertEquals(Collections.singletonList("par1"), (Object)((CatalogTable)table1).getPartitionKeys());
        options.put(FlinkOptions.RECORD_KEY_FIELD.key(), "id");
        table = new CatalogTableImpl(this.schema, this.partitions, options, "hudi table");
        hoodieCatalog.alterTable(this.tablePath, (CatalogBaseTable)table, true);
        CatalogBaseTable table2 = hoodieCatalog.getTable(this.tablePath);
        Assertions.assertEquals((Object)"id", table2.getOptions().get(FlinkOptions.RECORD_KEY_FIELD.key()));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCreateExternalTable(boolean isExternal) throws TableAlreadyExistException, DatabaseNotExistException, TableNotExistException, IOException {
        HashMap<String, String> originOptions = new HashMap<String, String>();
        originOptions.put(FactoryUtil.CONNECTOR.key(), "hudi");
        originOptions.put(CatalogOptions.TABLE_EXTERNAL.key(), String.valueOf(isExternal));
        CatalogTableImpl table = new CatalogTableImpl(this.schema, originOptions, "hudi table");
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
        Table table1 = hoodieCatalog.getHiveTable(this.tablePath);
        if (isExternal) {
            Assertions.assertTrue((boolean)Boolean.parseBoolean((String)table1.getParameters().get(CatalogOptions.TABLE_EXTERNAL.key())));
            Assertions.assertEquals((Object)"EXTERNAL_TABLE", (Object)table1.getTableType());
        } else {
            Assertions.assertFalse((boolean)Boolean.parseBoolean((String)table1.getParameters().get(CatalogOptions.TABLE_EXTERNAL.key())));
            Assertions.assertEquals((Object)"MANAGED_TABLE", (Object)table1.getTableType());
        }
        hoodieCatalog.dropTable(this.tablePath, false);
        Path path = new Path((String)table1.getParameters().get(FlinkOptions.PATH.key()));
        boolean exists = StreamerUtil.fileExists((FileSystem)FileSystem.getLocal((Configuration)new Configuration()), (Path)path);
        Assertions.assertTrue((isExternal && exists || !isExternal && !exists ? 1 : 0) != 0);
    }

    @Test
    public void testCreateNonHoodieTable() throws TableAlreadyExistException, DatabaseNotExistException {
        CatalogTableImpl table = new CatalogTableImpl(this.schema, Collections.emptyMap(), "hudi table");
        try {
            hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)table, false);
        }
        catch (HoodieCatalogException e) {
            Assertions.assertEquals((Object)String.format("The %s is not hoodie table", this.tablePath.getObjectName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testAlterTable() throws Exception {
        HashMap<String, String> originOptions = new HashMap<String, String>();
        originOptions.put(FactoryUtil.CONNECTOR.key(), "hudi");
        CatalogTableImpl originTable = new CatalogTableImpl(this.schema, this.partitions, originOptions, "hudi table");
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)originTable, false);
        Table hiveTable = hoodieCatalog.getHiveTable(this.tablePath);
        Map newOptions = hiveTable.getParameters();
        newOptions.put("k", "v");
        CatalogTableImpl newTable = new CatalogTableImpl(this.schema, this.partitions, newOptions, "alter hudi table");
        hoodieCatalog.alterTable(this.tablePath, (CatalogBaseTable)newTable, false);
        hiveTable = hoodieCatalog.getHiveTable(this.tablePath);
        Assertions.assertEquals(hiveTable.getParameters().get(FactoryUtil.CONNECTOR.key()), (Object)"hudi");
        Assertions.assertEquals(hiveTable.getParameters().get("k"), (Object)"v");
    }

    @Test
    public void testRenameTable() throws Exception {
        HashMap<String, String> originOptions = new HashMap<String, String>();
        originOptions.put(FactoryUtil.CONNECTOR.key(), "hudi");
        CatalogTableImpl originTable = new CatalogTableImpl(this.schema, this.partitions, originOptions, "hudi table");
        hoodieCatalog.createTable(this.tablePath, (CatalogBaseTable)originTable, false);
        hoodieCatalog.renameTable(this.tablePath, "test1", false);
        Assertions.assertEquals((Object)hoodieCatalog.getHiveTable(new ObjectPath("default", "test1")).getTableName(), (Object)"test1");
        hoodieCatalog.renameTable(new ObjectPath("default", "test1"), "test", false);
    }
}

