/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.catalog;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CommonCatalogOptions;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.table.catalog.CatalogOptions;
import org.apache.hudi.table.catalog.HoodieCatalog;
import org.apache.hudi.table.catalog.HoodieCatalogTestUtils;
import org.apache.hudi.table.catalog.HoodieHiveCatalog;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestHoodieCatalogFactory {
    private static final URL CONF_DIR = Thread.currentThread().getContextClassLoader().getResource("test-catalog-factory-conf");
    @TempDir
    File tempFile;

    @Test
    public void testCreateHMSCatalog() {
        String catalogName = "mycatalog";
        HoodieHiveCatalog expectedCatalog = HoodieCatalogTestUtils.createHiveCatalog("mycatalog");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(CommonCatalogOptions.CATALOG_TYPE.key(), "hudi");
        options.put(CatalogOptions.HIVE_CONF_DIR.key(), CONF_DIR.getPath());
        options.put(CatalogOptions.MODE.key(), "hms");
        Catalog actualCatalog = FactoryUtil.createCatalog((String)"mycatalog", options, null, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Assertions.assertEquals((Object)((HoodieHiveCatalog)actualCatalog).getHiveConf().getVar(HiveConf.ConfVars.METASTOREURIS), (Object)"dummy-hms");
        TestHoodieCatalogFactory.checkEquals((AbstractCatalog)expectedCatalog, (AbstractCatalog)((HoodieHiveCatalog)actualCatalog));
    }

    @Test
    public void testCreateDFSCatalog() {
        String catalogName = "mycatalog";
        HashMap<String, String> catalogOptions = new HashMap<String, String>();
        catalogOptions.put(CatalogOptions.CATALOG_PATH.key(), this.tempFile.getAbsolutePath());
        catalogOptions.put(CatalogOptions.DEFAULT_DATABASE.key(), "test_db");
        HoodieCatalog expectedCatalog = new HoodieCatalog("mycatalog", Configuration.fromMap(catalogOptions));
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(CommonCatalogOptions.CATALOG_TYPE.key(), "hudi");
        options.put(CatalogOptions.CATALOG_PATH.key(), this.tempFile.getAbsolutePath());
        options.put(CatalogOptions.DEFAULT_DATABASE.key(), "test_db");
        options.put(CatalogOptions.MODE.key(), "dfs");
        Catalog actualCatalog = FactoryUtil.createCatalog((String)"mycatalog", options, null, (ClassLoader)Thread.currentThread().getContextClassLoader());
        TestHoodieCatalogFactory.checkEquals((AbstractCatalog)expectedCatalog, (AbstractCatalog)actualCatalog);
    }

    private static void checkEquals(AbstractCatalog c1, AbstractCatalog c2) {
        Assertions.assertEquals((Object)c2.getName(), (Object)c1.getName());
        Assertions.assertEquals((Object)c2.getDefaultDatabase(), (Object)c1.getDefaultDatabase());
    }
}

