/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source.stats;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.source.stats.ExpressionEvaluator;
import org.apache.hudi.utils.TestData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExpressionEvaluator {
    private static final DataType ROW_DATA_TYPE = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f_tinyint", (DataType)DataTypes.TINYINT()), DataTypes.FIELD((String)"f_smallint", (DataType)DataTypes.SMALLINT()), DataTypes.FIELD((String)"f_int", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f_long", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f_float", (DataType)DataTypes.FLOAT()), DataTypes.FIELD((String)"f_double", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"f_boolean", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"f_decimal", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f_bytes", (DataType)DataTypes.VARBINARY((int)10)), DataTypes.FIELD((String)"f_string", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"f_time", (DataType)DataTypes.TIME((int)3)), DataTypes.FIELD((String)"f_date", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"f_timestamp", (DataType)DataTypes.TIMESTAMP((int)3))}).notNull();
    private static final DataType INDEX_ROW_DATA_TYPE = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"file_name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"value_cnt", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f_int_min", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f_int_max", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f_int_null_cnt", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f_string_min", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"f_string_max", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"f_string_null_cnt", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f_timestamp_min", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"f_timestamp_max", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"f_timestamp_null_cnt", (DataType)DataTypes.BIGINT())}).notNull();
    private static final RowType INDEX_ROW_TYPE = (RowType)INDEX_ROW_DATA_TYPE.getLogicalType();

    @Test
    void testEqualTo() {
        ExpressionEvaluator.EqualTo equalTo = ExpressionEvaluator.EqualTo.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        ValueLiteralExpression vExpr = new ValueLiteralExpression((Object)12);
        RowData indexRow1 = TestExpressionEvaluator.intIndexRow(11, 13);
        equalTo.bindFieldReference(rExpr).bindVal(vExpr).bindColStats(indexRow1, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)equalTo.eval(), (String)"11 < 12 < 13");
        RowData indexRow2 = TestExpressionEvaluator.intIndexRow(12, 13);
        equalTo.bindColStats(indexRow2, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)equalTo.eval(), (String)"12 <= 12 < 13");
        RowData indexRow3 = TestExpressionEvaluator.intIndexRow(11, 12);
        equalTo.bindColStats(indexRow3, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)equalTo.eval(), (String)"11 < 12 <= 12");
        RowData indexRow4 = TestExpressionEvaluator.intIndexRow(10, 11);
        equalTo.bindColStats(indexRow4, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)equalTo.eval(), (String)"11 < 12");
        RowData indexRow5 = TestExpressionEvaluator.intIndexRow(13, 14);
        equalTo.bindColStats(indexRow5, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)equalTo.eval(), (String)"12 < 13");
        RowData indexRow6 = TestExpressionEvaluator.intIndexRow(null, null);
        equalTo.bindColStats(indexRow6, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)equalTo.eval(), (String)"12 <> null");
        equalTo.bindVal(new ValueLiteralExpression(null, DataTypes.INT()));
        Assertions.assertFalse((boolean)equalTo.eval(), (String)"null <> null");
    }

    @Test
    void testNotEqualTo() {
        ExpressionEvaluator.NotEqualTo notEqualTo = ExpressionEvaluator.NotEqualTo.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        ValueLiteralExpression vExpr = new ValueLiteralExpression((Object)12);
        RowData indexRow1 = TestExpressionEvaluator.intIndexRow(11, 13);
        notEqualTo.bindFieldReference(rExpr).bindVal(vExpr).bindColStats(indexRow1, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)notEqualTo.eval(), (String)"11 <> 12 && 12 <> 13");
        RowData indexRow2 = TestExpressionEvaluator.intIndexRow(12, 13);
        notEqualTo.bindColStats(indexRow2, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)notEqualTo.eval(), (String)"12 <> 13");
        RowData indexRow3 = TestExpressionEvaluator.intIndexRow(11, 12);
        notEqualTo.bindColStats(indexRow3, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)notEqualTo.eval(), (String)"11 <> 12");
        RowData indexRow4 = TestExpressionEvaluator.intIndexRow(10, 11);
        notEqualTo.bindColStats(indexRow4, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)notEqualTo.eval(), (String)"10 <> 12 and 11 < 12");
        RowData indexRow5 = TestExpressionEvaluator.intIndexRow(13, 14);
        notEqualTo.bindColStats(indexRow5, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)notEqualTo.eval(), (String)"12 <> 13 and 12 <> 14");
        RowData indexRow6 = TestExpressionEvaluator.intIndexRow(null, null);
        notEqualTo.bindColStats(indexRow6, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)notEqualTo.eval(), (String)"12 <> null");
        notEqualTo.bindVal(new ValueLiteralExpression(null, DataTypes.INT()));
        Assertions.assertTrue((boolean)notEqualTo.eval(), (String)"null <> null");
    }

    @Test
    void testIsNull() {
        ExpressionEvaluator.IsNull isNull = ExpressionEvaluator.IsNull.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        RowData indexRow1 = TestExpressionEvaluator.intIndexRow(11, 13);
        isNull.bindFieldReference(rExpr).bindColStats(indexRow1, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)isNull.eval(), (String)"2 nulls");
        RowData indexRow2 = TestExpressionEvaluator.intIndexRow(12, 13, 0L);
        isNull.bindColStats(indexRow2, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)isNull.eval(), (String)"0 nulls");
    }

    @Test
    void testIsNotNull() {
        ExpressionEvaluator.IsNotNull isNotNull = ExpressionEvaluator.IsNotNull.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        RowData indexRow1 = TestExpressionEvaluator.intIndexRow(11, 13);
        isNotNull.bindFieldReference(rExpr).bindColStats(indexRow1, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)isNotNull.eval(), (String)"min 11 is not null");
        RowData indexRow2 = TestExpressionEvaluator.intIndexRow(null, null, 0L);
        isNotNull.bindColStats(indexRow2, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)isNotNull.eval(), (String)"min is null and 0 nulls");
    }

    @Test
    void testLessThan() {
        ExpressionEvaluator.LessThan lessThan = ExpressionEvaluator.LessThan.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        ValueLiteralExpression vExpr = new ValueLiteralExpression((Object)12);
        RowData indexRow1 = TestExpressionEvaluator.intIndexRow(11, 13);
        lessThan.bindFieldReference(rExpr).bindVal(vExpr).bindColStats(indexRow1, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)lessThan.eval(), (String)"12 < 13");
        RowData indexRow2 = TestExpressionEvaluator.intIndexRow(12, 13);
        lessThan.bindColStats(indexRow2, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)lessThan.eval(), (String)"min 12 = 12");
        RowData indexRow3 = TestExpressionEvaluator.intIndexRow(11, 12);
        lessThan.bindColStats(indexRow3, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)lessThan.eval(), (String)"11 < 12");
        RowData indexRow4 = TestExpressionEvaluator.intIndexRow(10, 11);
        lessThan.bindColStats(indexRow4, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)lessThan.eval(), (String)"11 < 12");
        RowData indexRow5 = TestExpressionEvaluator.intIndexRow(13, 14);
        lessThan.bindColStats(indexRow5, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)lessThan.eval(), (String)"12 < min 13");
        RowData indexRow6 = TestExpressionEvaluator.intIndexRow(null, null);
        lessThan.bindColStats(indexRow6, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)lessThan.eval(), (String)"12 <> null");
        lessThan.bindVal(new ValueLiteralExpression(null, DataTypes.INT()));
        Assertions.assertFalse((boolean)lessThan.eval(), (String)"null <> null");
    }

    @Test
    void testGreaterThan() {
        ExpressionEvaluator.GreaterThan greaterThan = ExpressionEvaluator.GreaterThan.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        ValueLiteralExpression vExpr = new ValueLiteralExpression((Object)12);
        RowData indexRow1 = TestExpressionEvaluator.intIndexRow(11, 13);
        greaterThan.bindFieldReference(rExpr).bindVal(vExpr).bindColStats(indexRow1, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)greaterThan.eval(), (String)"12 < 13");
        RowData indexRow2 = TestExpressionEvaluator.intIndexRow(12, 13);
        greaterThan.bindColStats(indexRow2, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)greaterThan.eval(), (String)"12 < 13");
        RowData indexRow3 = TestExpressionEvaluator.intIndexRow(11, 12);
        greaterThan.bindColStats(indexRow3, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)greaterThan.eval(), (String)"max 12 = 12");
        RowData indexRow4 = TestExpressionEvaluator.intIndexRow(10, 11);
        greaterThan.bindColStats(indexRow4, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)greaterThan.eval(), (String)"max 11 < 12");
        RowData indexRow5 = TestExpressionEvaluator.intIndexRow(13, 14);
        greaterThan.bindColStats(indexRow5, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)greaterThan.eval(), (String)"12 < 13");
        RowData indexRow6 = TestExpressionEvaluator.intIndexRow(null, null);
        greaterThan.bindColStats(indexRow6, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)greaterThan.eval(), (String)"12 <> null");
        greaterThan.bindVal(new ValueLiteralExpression(null, DataTypes.INT()));
        Assertions.assertFalse((boolean)greaterThan.eval(), (String)"null <> null");
    }

    @Test
    void testLessThanOrEqual() {
        ExpressionEvaluator.LessThanOrEqual lessThanOrEqual = ExpressionEvaluator.LessThanOrEqual.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        ValueLiteralExpression vExpr = new ValueLiteralExpression((Object)12);
        RowData indexRow1 = TestExpressionEvaluator.intIndexRow(11, 13);
        lessThanOrEqual.bindFieldReference(rExpr).bindVal(vExpr).bindColStats(indexRow1, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)lessThanOrEqual.eval(), (String)"11 < 12");
        RowData indexRow2 = TestExpressionEvaluator.intIndexRow(12, 13);
        lessThanOrEqual.bindColStats(indexRow2, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)lessThanOrEqual.eval(), (String)"min 12 = 12");
        RowData indexRow3 = TestExpressionEvaluator.intIndexRow(11, 12);
        lessThanOrEqual.bindColStats(indexRow3, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)lessThanOrEqual.eval(), (String)"max 12 = 12");
        RowData indexRow4 = TestExpressionEvaluator.intIndexRow(10, 11);
        lessThanOrEqual.bindColStats(indexRow4, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)lessThanOrEqual.eval(), (String)"max 11 < 12");
        RowData indexRow5 = TestExpressionEvaluator.intIndexRow(13, 14);
        lessThanOrEqual.bindColStats(indexRow5, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)lessThanOrEqual.eval(), (String)"12 < 13");
        RowData indexRow6 = TestExpressionEvaluator.intIndexRow(null, null);
        lessThanOrEqual.bindColStats(indexRow6, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)lessThanOrEqual.eval(), (String)"12 <> null");
        lessThanOrEqual.bindVal(new ValueLiteralExpression(null, DataTypes.INT()));
        Assertions.assertFalse((boolean)lessThanOrEqual.eval(), (String)"null <> null");
    }

    @Test
    void testGreaterThanOrEqual() {
        ExpressionEvaluator.GreaterThanOrEqual greaterThanOrEqual = ExpressionEvaluator.GreaterThanOrEqual.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        ValueLiteralExpression vExpr = new ValueLiteralExpression((Object)12);
        RowData indexRow1 = TestExpressionEvaluator.intIndexRow(11, 13);
        greaterThanOrEqual.bindFieldReference(rExpr).bindVal(vExpr).bindColStats(indexRow1, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)greaterThanOrEqual.eval(), (String)"12 < 13");
        RowData indexRow2 = TestExpressionEvaluator.intIndexRow(12, 13);
        greaterThanOrEqual.bindColStats(indexRow2, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)greaterThanOrEqual.eval(), (String)"min 12 = 12");
        RowData indexRow3 = TestExpressionEvaluator.intIndexRow(11, 12);
        greaterThanOrEqual.bindColStats(indexRow3, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)greaterThanOrEqual.eval(), (String)"max 12 = 12");
        RowData indexRow4 = TestExpressionEvaluator.intIndexRow(10, 11);
        greaterThanOrEqual.bindColStats(indexRow4, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)greaterThanOrEqual.eval(), (String)"max 11 < 12");
        RowData indexRow5 = TestExpressionEvaluator.intIndexRow(13, 14);
        greaterThanOrEqual.bindColStats(indexRow5, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)greaterThanOrEqual.eval(), (String)"12 < 13");
        RowData indexRow6 = TestExpressionEvaluator.intIndexRow(null, null);
        greaterThanOrEqual.bindColStats(indexRow6, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)greaterThanOrEqual.eval(), (String)"12 <> null");
        greaterThanOrEqual.bindVal(new ValueLiteralExpression(null, DataTypes.INT()));
        Assertions.assertFalse((boolean)greaterThanOrEqual.eval(), (String)"null <> null");
    }

    @Test
    void testIn() {
        ExpressionEvaluator.In in = ExpressionEvaluator.In.getInstance();
        FieldReferenceExpression rExpr = new FieldReferenceExpression("f_int", DataTypes.INT(), 2, 2);
        RowData indexRow1 = TestExpressionEvaluator.intIndexRow(11, 13);
        in.bindFieldReference(rExpr).bindColStats(indexRow1, TestExpressionEvaluator.queryFields(2), rExpr);
        in.bindVals(new Object[]{12});
        Assertions.assertTrue((boolean)in.eval(), (String)"11 < 12 < 13");
        RowData indexRow2 = TestExpressionEvaluator.intIndexRow(12, 13);
        in.bindColStats(indexRow2, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)in.eval(), (String)"min 12 = 12");
        RowData indexRow3 = TestExpressionEvaluator.intIndexRow(11, 12);
        in.bindColStats(indexRow3, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertTrue((boolean)in.eval(), (String)"max 12 = 12");
        RowData indexRow4 = TestExpressionEvaluator.intIndexRow(10, 11);
        in.bindColStats(indexRow4, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)in.eval(), (String)"max 11 < 12");
        RowData indexRow5 = TestExpressionEvaluator.intIndexRow(13, 14);
        in.bindColStats(indexRow5, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)in.eval(), (String)"12 < 13");
        RowData indexRow6 = TestExpressionEvaluator.intIndexRow(null, null);
        in.bindColStats(indexRow6, TestExpressionEvaluator.queryFields(2), rExpr);
        Assertions.assertFalse((boolean)in.eval(), (String)"12 <> null");
        in.bindVals(new Object[]{null});
        Assertions.assertFalse((boolean)in.eval(), (String)"null <> null");
    }

    private static RowData intIndexRow(Integer minVal, Integer maxVal) {
        return TestExpressionEvaluator.intIndexRow(minVal, maxVal, 2L);
    }

    private static RowData intIndexRow(Integer minVal, Integer maxVal, Long nullCnt) {
        return TestExpressionEvaluator.indexRow(StringData.fromString((String)"f1"), 100L, minVal, maxVal, nullCnt, StringData.fromString((String)"1"), StringData.fromString((String)"100"), 5L, TimestampData.fromEpochMillis((long)1L), TimestampData.fromEpochMillis((long)100L), 3L);
    }

    private static RowData indexRow(Object ... fields) {
        return TestData.insertRow(INDEX_ROW_TYPE, fields);
    }

    private static RowType.RowField[] queryFields(int ... pos) {
        List fields = ((RowType)ROW_DATA_TYPE.getLogicalType()).getFields();
        return (RowType.RowField[])Arrays.stream(pos).mapToObj(fields::get).toArray(RowType.RowField[]::new);
    }
}

