/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.utils;

import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.sink.utils.HiveSyncContext;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveSyncContext {
    @Test
    public void testBuildSyncConfig() throws Exception {
        Configuration configuration1 = new Configuration();
        Configuration configuration2 = new Configuration();
        String hiveSyncPartitionField = "hiveSyncPartitionField";
        String partitionPathField = "partitionPathField";
        configuration1.setString(FlinkOptions.HIVE_SYNC_PARTITION_FIELDS, hiveSyncPartitionField);
        configuration1.setString(FlinkOptions.PARTITION_PATH_FIELD, partitionPathField);
        configuration2.setString(FlinkOptions.PARTITION_PATH_FIELD, partitionPathField);
        Class<?> threadClazz = Class.forName("org.apache.hudi.sink.utils.HiveSyncContext");
        Method buildSyncConfigMethod = threadClazz.getDeclaredMethod("buildSyncConfig", Configuration.class);
        buildSyncConfigMethod.setAccessible(true);
        Properties props1 = HiveSyncContext.buildSyncConfig((Configuration)configuration1);
        Properties props2 = HiveSyncContext.buildSyncConfig((Configuration)configuration2);
        Assertions.assertEquals((Object)hiveSyncPartitionField, (Object)props1.getProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key()));
        Assertions.assertEquals((Object)partitionPathField, (Object)props2.getProperty(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key()));
    }
}

