/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.utils;

import java.util.ArrayList;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.MockOperatorCoordinatorContext;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.util.Collector;
import org.apache.hudi.sink.compact.CompactFunction;
import org.apache.hudi.sink.compact.CompactionCommitEvent;
import org.apache.hudi.sink.compact.CompactionCommitSink;
import org.apache.hudi.sink.compact.CompactionPlanEvent;
import org.apache.hudi.sink.compact.CompactionPlanOperator;
import org.apache.hudi.sink.utils.CollectorOutput;
import org.apache.hudi.sink.utils.MockCoordinatorExecutor;
import org.apache.hudi.sink.utils.MockStreamingRuntimeContext;
import org.apache.hudi.sink.utils.NonThrownExecutor;

public class CompactFunctionWrapper {
    private final Configuration conf;
    private final IOManager ioManager = new IOManagerAsync();
    private final StreamingRuntimeContext runtimeContext;
    private CompactionPlanOperator compactionPlanOperator;
    private CompactFunction compactFunction;
    private CompactionCommitSink commitSink;

    public CompactFunctionWrapper(Configuration conf) throws Exception {
        MockEnvironment environment = new MockEnvironmentBuilder().setTaskName("mockTask").setManagedMemorySize(131072L).setIOManager(this.ioManager).build();
        this.runtimeContext = new MockStreamingRuntimeContext(false, 1, 0, environment);
        this.conf = conf;
    }

    public void openFunction() throws Exception {
        this.compactionPlanOperator = new CompactionPlanOperator(this.conf);
        this.compactionPlanOperator.open();
        this.compactFunction = new CompactFunction(this.conf);
        this.compactFunction.setRuntimeContext((RuntimeContext)this.runtimeContext);
        this.compactFunction.open(this.conf);
        MockCoordinatorExecutor syncExecutor = new MockCoordinatorExecutor((OperatorCoordinator.Context)new MockOperatorCoordinatorContext(new OperatorID(), 1));
        this.compactFunction.setExecutor((NonThrownExecutor)syncExecutor);
        this.commitSink = new CompactionCommitSink(this.conf);
        this.commitSink.setRuntimeContext((RuntimeContext)this.runtimeContext);
        this.commitSink.open(this.conf);
    }

    public void compact(long checkpointID) throws Exception {
        CollectorOutput output = new CollectorOutput();
        this.compactionPlanOperator.setOutput(output);
        this.compactionPlanOperator.notifyCheckpointComplete(checkpointID);
        final ArrayList compactCommitEvents = new ArrayList();
        for (CompactionPlanEvent event : output.getRecords()) {
            this.compactFunction.processElement(event, null, (Collector)new Collector<CompactionCommitEvent>(){

                public void collect(CompactionCommitEvent event) {
                    compactCommitEvents.add(event);
                }

                public void close() {
                }
            });
        }
        for (CompactionPlanEvent event : compactCommitEvents) {
            this.commitSink.invoke((CompactionCommitEvent)event, null);
        }
    }

    public void close() throws Exception {
        this.ioManager.close();
    }
}

