/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.meta;

import java.io.File;
import java.util.stream.IntStream;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.sink.meta.CkpMetadata;
import org.apache.hudi.util.StreamerUtil;
import org.apache.hudi.utils.TestConfigurations;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestCkpMetadata {
    private CkpMetadata metadata;
    @TempDir
    File tempFile;

    @BeforeEach
    public void beforeEach() throws Exception {
        String basePath = this.tempFile.getAbsolutePath();
        FileSystem fs = FSUtils.getFs((String)this.tempFile.getAbsolutePath(), (org.apache.hadoop.conf.Configuration)HadoopConfigurations.getHadoopConf((Configuration)new Configuration()));
        Configuration conf = TestConfigurations.getDefaultConf(basePath);
        StreamerUtil.initTableIfNotExists((Configuration)conf);
        this.metadata = CkpMetadata.getInstance((FileSystem)fs, (String)basePath);
    }

    @Test
    void testWriteAndReadMessage() {
        IntStream.range(0, 3).forEach(i -> this.metadata.startInstant(i + ""));
        MatcherAssert.assertThat((Object)this.metadata.lastPendingInstant(), (Matcher)CoreMatchers.is((Object)"2"));
        this.metadata.commitInstant("2");
        MatcherAssert.assertThat((Object)this.metadata.lastPendingInstant(), (Matcher)CoreMatchers.is((Object)"1"));
        IntStream.range(3, 6).forEach(i -> this.metadata.startInstant(i + ""));
        MatcherAssert.assertThat((Object)this.metadata.getMessages().size(), (Matcher)CoreMatchers.is((Object)3));
        this.metadata.commitInstant("6");
        this.metadata.abortInstant("7");
        MatcherAssert.assertThat((Object)this.metadata.getMessages().size(), (Matcher)CoreMatchers.is((Object)5));
    }
}

