/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.hudi.common.util.ValidationUtils;

public class DataTypeUtils {
    public static boolean isTimestampType(DataType type) {
        return type.getLogicalType().getTypeRoot() == LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE;
    }

    public static int precision(LogicalType logicalType) {
        ValidationUtils.checkArgument((boolean)(logicalType instanceof TimestampType));
        TimestampType timestampType = (TimestampType)logicalType;
        return timestampType.getPrecision();
    }

    public static boolean isDateType(DataType type) {
        return type.getLogicalType().getTypeRoot() == LogicalTypeRoot.DATE;
    }

    public static boolean isDatetimeType(DataType type) {
        return DataTypeUtils.isTimestampType(type) || DataTypeUtils.isDateType(type);
    }
}

