/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.TableException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.configuration.FlinkOptions;

public class FilePathUtils {
    private static final Pattern HIVE_PARTITION_NAME_PATTERN;
    private static final BitSet CHAR_TO_ESCAPE;

    private static boolean needsEscaping(char c) {
        return c < CHAR_TO_ESCAPE.size() && CHAR_TO_ESCAPE.get(c);
    }

    public static String generatePartitionPath(LinkedHashMap<String, String> partitionKVs, boolean hivePartition, boolean sepSuffix) {
        if (partitionKVs.isEmpty()) {
            return "";
        }
        StringBuilder suffixBuf = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> e : partitionKVs.entrySet()) {
            if (i > 0) {
                suffixBuf.append("/");
            }
            if (hivePartition) {
                suffixBuf.append(FilePathUtils.escapePathName(e.getKey()));
                suffixBuf.append('=');
            }
            suffixBuf.append(FilePathUtils.escapePathName(e.getValue()));
            ++i;
        }
        if (sepSuffix) {
            suffixBuf.append("/");
        }
        return suffixBuf.toString();
    }

    private static String escapePathName(String path) {
        if (path == null || path.length() == 0) {
            throw new TableException("Path should not be null or empty: " + path);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (FilePathUtils.needsEscaping(c)) {
                sb.append('%');
                sb.append(String.format("%1$02X", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static LinkedHashMap<String, String> extractPartitionKeyValues(org.apache.hadoop.fs.Path currPath, boolean hivePartition, String[] partitionKeys) {
        LinkedHashMap<String, String> fullPartSpec = new LinkedHashMap<String, String>();
        if (partitionKeys.length == 0) {
            return fullPartSpec;
        }
        ArrayList<String[]> kvs = new ArrayList<String[]>();
        int curDepth = 0;
        do {
            String component = currPath.getName();
            String[] kv = new String[2];
            if (hivePartition) {
                Matcher m = HIVE_PARTITION_NAME_PATTERN.matcher(component);
                if (m.matches()) {
                    String k = FilePathUtils.unescapePathName(m.group(1));
                    String v = FilePathUtils.unescapePathName(m.group(2));
                    kv[0] = k;
                    kv[1] = v;
                }
            } else {
                kv[0] = partitionKeys[partitionKeys.length - 1 - curDepth];
                kv[1] = FilePathUtils.unescapePathName(component);
            }
            kvs.add(kv);
        } while ((currPath = currPath.getParent()) != null && !currPath.getName().isEmpty() && ++curDepth < partitionKeys.length);
        for (int i = kvs.size(); i > 0; --i) {
            fullPartSpec.put(((String[])kvs.get(i - 1))[0], ((String[])kvs.get(i - 1))[1]);
        }
        return fullPartSpec;
    }

    public static String unescapePathName(String path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < path.length()) {
                int code = -1;
                try {
                    code = Integer.parseInt(path.substring(i + 1, i + 3), 16);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (code >= 0) {
                    sb.append((char)code);
                    i += 2;
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static List<Tuple2<LinkedHashMap<String, String>, org.apache.hadoop.fs.Path>> searchPartKeyValueAndPaths(FileSystem fs, org.apache.hadoop.fs.Path path, boolean hivePartition, String[] partitionKeys) {
        FileStatus[] generatedParts = FilePathUtils.getFileStatusRecursively(path, partitionKeys.length, fs);
        ArrayList<Tuple2<LinkedHashMap<String, String>, org.apache.hadoop.fs.Path>> ret = new ArrayList<Tuple2<LinkedHashMap<String, String>, org.apache.hadoop.fs.Path>>();
        for (FileStatus part : generatedParts) {
            ret.add((Tuple2<LinkedHashMap<String, String>, org.apache.hadoop.fs.Path>)new Tuple2(FilePathUtils.extractPartitionKeyValues(part.getPath(), hivePartition, partitionKeys), (Object)part.getPath()));
        }
        return ret;
    }

    public static FileStatus[] getFileStatusRecursively(org.apache.hadoop.fs.Path path, int expectLevel, org.apache.hadoop.conf.Configuration conf) {
        return FilePathUtils.getFileStatusRecursively(path, expectLevel, FSUtils.getFs((String)path.toString(), (org.apache.hadoop.conf.Configuration)conf));
    }

    public static FileStatus[] getFileStatusRecursively(org.apache.hadoop.fs.Path path, int expectLevel, FileSystem fs) {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        try {
            FileStatus fileStatus = fs.getFileStatus(path);
            FilePathUtils.listStatusRecursively(fs, fileStatus, 0, expectLevel, result);
        }
        catch (IOException ignore) {
            return new FileStatus[0];
        }
        return result.toArray(new FileStatus[0]);
    }

    private static void listStatusRecursively(FileSystem fs, FileStatus fileStatus, int level, int expectLevel, List<FileStatus> results) throws IOException {
        if (expectLevel == level && !FilePathUtils.isHiddenFile(fileStatus)) {
            results.add(fileStatus);
            return;
        }
        if (fileStatus.isDirectory() && !FilePathUtils.isHiddenFile(fileStatus)) {
            for (FileStatus stat : fs.listStatus(fileStatus.getPath())) {
                FilePathUtils.listStatusRecursively(fs, stat, level + 1, expectLevel, results);
            }
        }
    }

    private static boolean isHiddenFile(FileStatus fileStatus) {
        String name = fileStatus.getPath().getName();
        return name.startsWith("_") || name.startsWith(".") && !name.contains(".log.");
    }

    public static List<Map<String, String>> getPartitions(org.apache.hadoop.fs.Path path, org.apache.hadoop.conf.Configuration hadoopConf, List<String> partitionKeys, String defaultParName, boolean hivePartition) {
        try {
            return FilePathUtils.searchPartKeyValueAndPaths(FSUtils.getFs((String)path.toString(), (org.apache.hadoop.conf.Configuration)hadoopConf), path, hivePartition, partitionKeys.toArray(new String[0])).stream().map(tuple2 -> (LinkedHashMap)tuple2.f0).map(spec -> {
                LinkedHashMap ret = new LinkedHashMap();
                spec.forEach((k, v) -> ret.put(k, defaultParName.equals(v) ? null : v));
                return ret;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new TableException("Fetch partitions fail.", (Throwable)e);
        }
    }

    public static LinkedHashMap<String, String> validateAndReorderPartitions(Map<String, String> partitionKVs, List<String> partitionKeys) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String k : partitionKeys) {
            if (!partitionKVs.containsKey(k)) {
                throw new TableException("Partition keys are: " + partitionKeys + ", incomplete partition spec: " + partitionKVs);
            }
            map.put(k, partitionKVs.get(k));
        }
        return map;
    }

    public static org.apache.hadoop.fs.Path[] getReadPaths(org.apache.hadoop.fs.Path path, Configuration conf, org.apache.hadoop.conf.Configuration hadoopConf, List<String> partitionKeys) {
        if (partitionKeys.isEmpty()) {
            return new org.apache.hadoop.fs.Path[]{path};
        }
        String defaultParName = conf.getString(FlinkOptions.PARTITION_DEFAULT_NAME);
        boolean hivePartition = conf.getBoolean(FlinkOptions.HIVE_STYLE_PARTITIONING);
        List<Map<String, String>> partitionPaths = FilePathUtils.getPartitions(path, hadoopConf, partitionKeys, defaultParName, hivePartition);
        return FilePathUtils.partitionPath2ReadPath(path, partitionKeys, partitionPaths, hivePartition);
    }

    public static org.apache.hadoop.fs.Path[] partitionPath2ReadPath(org.apache.hadoop.fs.Path path, List<String> partitionKeys, List<Map<String, String>> partitionPaths, boolean hivePartition) {
        return (org.apache.hadoop.fs.Path[])partitionPaths.stream().map(m -> FilePathUtils.validateAndReorderPartitions(m, partitionKeys)).map(kvs -> FilePathUtils.generatePartitionPath(kvs, hivePartition, true)).map(n -> new org.apache.hadoop.fs.Path(path, n)).toArray(org.apache.hadoop.fs.Path[]::new);
    }

    public static Set<String> toRelativePartitionPaths(List<String> partitionKeys, List<Map<String, String>> partitionPaths, boolean hivePartition) {
        return partitionPaths.stream().map(m -> FilePathUtils.validateAndReorderPartitions(m, partitionKeys)).map(kvs -> FilePathUtils.generatePartitionPath(kvs, hivePartition, false)).collect(Collectors.toSet());
    }

    public static Path[] toFlinkPaths(org.apache.hadoop.fs.Path[] paths) {
        return (Path[])Arrays.stream(paths).map(FilePathUtils::toFlinkPath).toArray(Path[]::new);
    }

    public static Path toFlinkPath(org.apache.hadoop.fs.Path path) {
        return new Path(path.toUri());
    }

    public static String[] extractPartitionKeys(Configuration conf) {
        if (FlinkOptions.isDefaultValueDefined(conf, FlinkOptions.PARTITION_PATH_FIELD)) {
            return new String[0];
        }
        return conf.getString(FlinkOptions.PARTITION_PATH_FIELD).split(",");
    }

    public static String[] extractHivePartitionFields(Configuration conf) {
        if (FlinkOptions.isDefaultValueDefined(conf, FlinkOptions.HIVE_SYNC_PARTITION_FIELDS)) {
            return FilePathUtils.extractPartitionKeys(conf);
        }
        return conf.getString(FlinkOptions.HIVE_SYNC_PARTITION_FIELDS).split(",");
    }

    static {
        char[] clist;
        HIVE_PARTITION_NAME_PATTERN = Pattern.compile("([^/]+)=([^/]+)");
        CHAR_TO_ESCAPE = new BitSet(128);
        for (int c = 0; c < 32; c = (int)((char)(c + 1))) {
            CHAR_TO_ESCAPE.set(c);
        }
        for (char c : clist = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '[', ']', '^'}) {
            CHAR_TO_ESCAPE.set(c);
        }
    }
}

