/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableOptionProperties {
    private static final Logger LOG = LoggerFactory.getLogger(TableOptionProperties.class);
    private static final String FILE_NAME = "table_option.properties";
    public static final String PK_CONSTRAINT_NAME = "pk.constraint.name";
    public static final String PK_COLUMNS = "pk.columns";
    public static final String COMMENT = "comment";
    public static final String PARTITION_COLUMNS = "partition.columns";
    public static final List<String> NON_OPTION_KEYS = Arrays.asList("pk.constraint.name", "pk.columns", "comment", "partition.columns");

    public static void createProperties(String basePath, Configuration hadoopConf, Map<String, String> options) throws IOException {
        Path propertiesFilePath = TableOptionProperties.getPropertiesFilePath(basePath);
        FileSystem fs = FSUtils.getFs((String)basePath, (Configuration)hadoopConf);
        try (FSDataOutputStream outputStream = fs.create(propertiesFilePath);){
            Properties properties = new Properties();
            properties.putAll(options);
            properties.store((OutputStream)outputStream, "Table option properties saved on " + new Date(System.currentTimeMillis()));
        }
        LOG.info(String.format("Create file %s success.", propertiesFilePath));
    }

    public static Map<String, String> loadFromProperties(String basePath, Configuration hadoopConf) {
        Path propertiesFilePath = TableOptionProperties.getPropertiesFilePath(basePath);
        HashMap<String, String> options = new HashMap<String, String>();
        Properties props = new Properties();
        FileSystem fs = FSUtils.getFs((String)basePath, (Configuration)hadoopConf);
        try (FSDataInputStream inputStream = fs.open(propertiesFilePath);){
            props.load((InputStream)inputStream);
            for (String name : props.stringPropertyNames()) {
                options.put(name, props.getProperty(name));
            }
        }
        catch (IOException e) {
            throw new HoodieIOException(String.format("Could not load table option properties from %s", propertiesFilePath), e);
        }
        LOG.info(String.format("Loading table option properties from %s success.", propertiesFilePath));
        return options;
    }

    private static Path getPropertiesFilePath(String basePath) {
        String auxPath = basePath + "/" + ".hoodie/.aux";
        return new Path(auxPath, FILE_NAME);
    }

    public static String getPkConstraintName(Map<String, String> options) {
        return options.get(PK_CONSTRAINT_NAME);
    }

    public static List<String> getPkColumns(Map<String, String> options) {
        if (options.containsKey(PK_COLUMNS)) {
            return Arrays.stream(options.get(PK_COLUMNS).split(",")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<String> getPartitionColumns(Map<String, String> options) {
        if (options.containsKey(PARTITION_COLUMNS)) {
            return Arrays.stream(options.get(PARTITION_COLUMNS).split(",")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static String getComment(Map<String, String> options) {
        return options.get(COMMENT);
    }

    public static Map<String, String> getTableOptions(Map<String, String> options) {
        HashMap<String, String> copied = new HashMap<String, String>(options);
        NON_OPTION_KEYS.forEach(copied::remove);
        return copied;
    }
}

