/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.schema;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.schema.SchemaProvider;
import org.apache.hudi.util.StreamerUtil;

public class FilebasedSchemaProvider
extends SchemaProvider {
    private final Schema sourceSchema;
    private Schema targetSchema;

    @Deprecated
    public FilebasedSchemaProvider(TypedProperties props) {
        StreamerUtil.checkRequiredProperties(props, Collections.singletonList("hoodie.deltastreamer.schemaprovider.source.schema.file"));
        FileSystem fs = FSUtils.getFs((String)props.getString("hoodie.deltastreamer.schemaprovider.source.schema.file"), (org.apache.hadoop.conf.Configuration)HadoopConfigurations.getHadoopConf(new Configuration()));
        try {
            this.sourceSchema = new Schema.Parser().parse((InputStream)fs.open(new Path(props.getString("hoodie.deltastreamer.schemaprovider.source.schema.file"))));
            if (props.containsKey((Object)"hoodie.deltastreamer.schemaprovider.target.schema.file")) {
                this.targetSchema = new Schema.Parser().parse((InputStream)fs.open(new Path(props.getString("hoodie.deltastreamer.schemaprovider.target.schema.file"))));
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error reading schema", ioe);
        }
    }

    public FilebasedSchemaProvider(Configuration conf) {
        String sourceSchemaPath = conf.getString(FlinkOptions.SOURCE_AVRO_SCHEMA_PATH);
        FileSystem fs = FSUtils.getFs((String)sourceSchemaPath, (org.apache.hadoop.conf.Configuration)HadoopConfigurations.getHadoopConf(conf));
        try {
            this.sourceSchema = new Schema.Parser().parse((InputStream)fs.open(new Path(sourceSchemaPath)));
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error reading schema", ioe);
        }
    }

    @Override
    public Schema getSourceSchema() {
        return this.sourceSchema;
    }

    @Override
    public Schema getTargetSchema() {
        if (this.targetSchema != null) {
            return this.targetSchema;
        }
        return super.getTargetSchema();
    }

    public static class Config {
        private static final String SOURCE_SCHEMA_FILE_PROP = "hoodie.deltastreamer.schemaprovider.source.schema.file";
        private static final String TARGET_SCHEMA_FILE_PROP = "hoodie.deltastreamer.schemaprovider.target.schema.file";
    }
}

