/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.ttl.strategy;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.ttl.strategy.TTLStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PartitionTTLStrategy
implements TTLStrategy,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionTTLStrategy.class);
    protected final HoodieTable hoodieTable;
    protected final HoodieWriteConfig writeConfig;
    protected final String instantTime;

    public PartitionTTLStrategy(HoodieTable hoodieTable, String instantTime) {
        this.writeConfig = hoodieTable.getConfig();
        this.hoodieTable = hoodieTable;
        this.instantTime = instantTime;
    }

    public abstract List<String> getExpiredPartitionPaths();

    protected List<String> getPartitionPathsForTTL() {
        String partitionSelected = this.writeConfig.getPartitionTTLPartitionSelected();
        HoodieTimer timer = HoodieTimer.start();
        List partitionsForTTL = StringUtils.isNullOrEmpty((String)partitionSelected) ? FSUtils.getAllPartitionPaths((HoodieEngineContext)this.hoodieTable.getContext(), (HoodieStorage)this.hoodieTable.getStorage(), (HoodieMetadataConfig)this.writeConfig.getMetadataConfig(), (String)this.writeConfig.getBasePath()) : Arrays.asList(partitionSelected.split(","));
        LOG.info("Get partitions for ttl cost {} ms", (Object)timer.endTimer());
        return partitionsForTTL;
    }
}

