/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseCommitActionExecutor;
import org.apache.hudi.table.action.commit.ParallelismHelper;

public abstract class BaseWriteHelper<T, I, K, O, R>
extends ParallelismHelper<I> {
    protected BaseWriteHelper(SerializableFunctionUnchecked<I, Integer> partitionNumberExtractor) {
        super(partitionNumberExtractor);
    }

    public HoodieWriteMetadata<O> write(String instantTime, I inputRecords, HoodieEngineContext context, HoodieTable<T, I, K, O> table, boolean shouldCombine, int configuredShuffleParallelism, BaseCommitActionExecutor<T, I, K, O, R> executor, WriteOperationType operationType) {
        try {
            I dedupedRecords;
            HoodieTimer sourceReadAndIndexTimer = HoodieTimer.start();
            I taggedRecords = dedupedRecords = this.combineOnCondition(shouldCombine, inputRecords, configuredShuffleParallelism, table);
            if (table.getIndex().requiresTagging(operationType)) {
                context.setJobStatus(this.getClass().getSimpleName(), "Tagging: " + table.getConfig().getTableName());
                taggedRecords = this.tag(dedupedRecords, context, table);
            }
            HoodieWriteMetadata<O> result = executor.execute(taggedRecords, (Option<HoodieTimer>)Option.of((Object)sourceReadAndIndexTimer));
            return result;
        }
        catch (Throwable e) {
            if (e instanceof HoodieUpsertException) {
                throw (HoodieUpsertException)((Object)e);
            }
            throw new HoodieUpsertException("Failed to upsert for commit time " + instantTime, e);
        }
    }

    protected abstract I tag(I var1, HoodieEngineContext var2, HoodieTable<T, I, K, O> var3);

    public I combineOnCondition(boolean condition, I records, int configuredParallelism, HoodieTable<T, I, K, O> table) {
        int targetParallelism = this.deduceShuffleParallelism(records, configuredParallelism);
        return condition ? this.deduplicateRecords(records, table, targetParallelism) : records;
    }

    public I deduplicateRecords(I records, HoodieTable<T, I, K, O> table, int parallelism) {
        HoodieRecordMerger recordMerger = HoodieRecordUtils.mergerToPreCombineMode((HoodieRecordMerger)table.getConfig().getRecordMerger());
        return this.deduplicateRecords(records, table.getIndex(), parallelism, table.getConfig().getSchema(), table.getConfig().getProps(), recordMerger);
    }

    public abstract I deduplicateRecords(I var1, HoodieIndex<?, ?> var2, int var3, String var4, TypedProperties var5, HoodieRecordMerger var6);
}

