/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster.strategy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieClusteringStrategy;
import org.apache.hudi.avro.model.HoodieSliceInfo;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.IncrementalPartitionAwareStrategy;
import org.apache.hudi.table.action.cluster.ClusteringPlanActionExecutor;
import org.apache.hudi.table.action.cluster.ClusteringPlanPartitionFilter;
import org.apache.hudi.table.action.cluster.strategy.ClusteringPlanStrategy;
import org.apache.hudi.util.Lazy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PartitionAwareClusteringPlanStrategy<T, I, K, O>
extends ClusteringPlanStrategy<T, I, K, O>
implements IncrementalPartitionAwareStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionAwareClusteringPlanStrategy.class);

    public PartitionAwareClusteringPlanStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    protected Pair<Stream<HoodieClusteringGroup>, Boolean> buildClusteringGroupsForPartition(String partitionPath, List<FileSlice> fileSlices) {
        HoodieWriteConfig writeConfig = this.getWriteConfig();
        ArrayList<Pair> fileSliceGroups = new ArrayList<Pair>();
        ArrayList<FileSlice> currentGroup = new ArrayList<FileSlice>();
        ArrayList<FileSlice> sortedFileSlices = new ArrayList<FileSlice>(fileSlices);
        sortedFileSlices.sort((o1, o2) -> (int)((o2.getBaseFile().isPresent() ? ((HoodieBaseFile)o2.getBaseFile().get()).getFileSize() : writeConfig.getParquetMaxFileSize()) - (o1.getBaseFile().isPresent() ? ((HoodieBaseFile)o1.getBaseFile().get()).getFileSize() : writeConfig.getParquetMaxFileSize())));
        long totalSizeSoFar = 0L;
        boolean partialScheduled = false;
        for (FileSlice currentSlice : sortedFileSlices) {
            long currentSize;
            long l = currentSize = currentSlice.getBaseFile().isPresent() ? ((HoodieBaseFile)currentSlice.getBaseFile().get()).getFileSize() : writeConfig.getParquetMaxFileSize();
            if (totalSizeSoFar + currentSize > writeConfig.getClusteringMaxBytesInGroup() && !currentGroup.isEmpty()) {
                int numOutputGroups = this.getNumberOfOutputFileGroups(totalSizeSoFar, writeConfig.getClusteringTargetFileMaxBytes());
                LOG.info("Adding one clustering group " + totalSizeSoFar + " max bytes: " + writeConfig.getClusteringMaxBytesInGroup() + " num input slices: " + currentGroup.size() + " output groups: " + numOutputGroups);
                fileSliceGroups.add(Pair.of(currentGroup, (Object)numOutputGroups));
                currentGroup = new ArrayList();
                totalSizeSoFar = 0L;
                if (fileSliceGroups.size() >= writeConfig.getClusteringMaxNumGroups()) {
                    LOG.info("Having generated the maximum number of groups : " + writeConfig.getClusteringMaxNumGroups());
                    partialScheduled = true;
                    break;
                }
            }
            currentGroup.add(currentSlice);
            totalSizeSoFar += currentSize;
        }
        if (!currentGroup.isEmpty() && (currentGroup.size() > 1 || writeConfig.shouldClusteringSingleGroup())) {
            int numOutputGroups = this.getNumberOfOutputFileGroups(totalSizeSoFar, writeConfig.getClusteringTargetFileMaxBytes());
            LOG.info("Adding final clustering group " + totalSizeSoFar + " max bytes: " + writeConfig.getClusteringMaxBytesInGroup() + " num input slices: " + currentGroup.size() + " output groups: " + numOutputGroups);
            fileSliceGroups.add(Pair.of(currentGroup, (Object)numOutputGroups));
        }
        return Pair.of(fileSliceGroups.stream().map(fileSliceGroup -> HoodieClusteringGroup.newBuilder().setSlices(PartitionAwareClusteringPlanStrategy.getFileSliceInfo((List)fileSliceGroup.getLeft())).setNumOutputFileGroups((Integer)fileSliceGroup.getRight()).setMetrics(this.buildMetrics((List)fileSliceGroup.getLeft())).build()), (Object)partialScheduled);
    }

    @Override
    public Pair<List<String>, List<String>> filterPartitionPaths(HoodieWriteConfig writeConfig, List<String> partitions) {
        return ClusteringPlanPartitionFilter.filter(partitions, this.getWriteConfig());
    }

    @Override
    public Option<HoodieClusteringPlan> generateClusteringPlan(ClusteringPlanActionExecutor executor, Lazy<List<String>> partitions) {
        List clusteringGroups;
        if (!this.checkPrecondition()) {
            return Option.empty();
        }
        HoodieTableMetaClient metaClient = this.getHoodieTable().getMetaClient();
        LOG.info("Scheduling clustering for {}", (Object)metaClient.getBasePath());
        HoodieWriteConfig config = this.getWriteConfig();
        String partitionSelected = config.getClusteringPartitionSelected();
        LOG.info("Scheduling clustering partitionSelected: {}", (Object)partitionSelected);
        List<Object> partitionPaths = new ArrayList();
        List missingPartitions = new ArrayList();
        int clusteringMaxNumGroups = this.getWriteConfig().getClusteringMaxNumGroups();
        if (StringUtils.isNullOrEmpty((String)partitionSelected)) {
            partitionPaths = this.getRegexPatternMatchedPartitions(config, (List)partitions.get());
        } else {
            partitionPaths = Arrays.asList(partitionSelected.split(","));
            missingPartitions = (List)executor.fetchMissingPartitions(TableServiceType.CLUSTER).getRight();
        }
        Pair<List<String>, List<String>> partitionsPair = this.filterPartitionPaths(this.getWriteConfig(), partitionPaths);
        partitionPaths = (List)partitionsPair.getLeft();
        missingPartitions.addAll((Collection)partitionsPair.getRight());
        LOG.info("Scheduling clustering partitionPaths: {}", partitionPaths);
        LOG.info("Missing Scheduled clustering partitionPaths: {}", missingPartitions);
        if (partitionPaths.isEmpty()) {
            return Option.empty();
        }
        List res = this.getEngineContext().map(partitionPaths, (SerializableFunction & Serializable)partitionPath -> {
            List<FileSlice> fileSlicesEligible = this.getFileSlicesEligibleForClustering((String)partitionPath).collect(Collectors.toList());
            Pair<Stream<HoodieClusteringGroup>, Boolean> groupPair = this.buildClusteringGroupsForPartition((String)partitionPath, fileSlicesEligible);
            List clusteringGroupsPartition = ((Stream)groupPair.getLeft()).collect(Collectors.toList());
            boolean partialScheduled = (Boolean)groupPair.getRight();
            if (clusteringGroupsPartition.size() > clusteringMaxNumGroups) {
                return Pair.of(clusteringGroupsPartition.subList(0, clusteringMaxNumGroups), (Object)partitionPath);
            }
            if (partialScheduled) {
                return Pair.of(clusteringGroupsPartition, (Object)partitionPath);
            }
            return Pair.of(clusteringGroupsPartition, (Object)"");
        }, partitionPaths.size());
        if (config.isIncrementalTableServiceEnabled()) {
            HashSet skippedPartitions = new HashSet();
            List collectedGroups = res.stream().flatMap(pair -> {
                String missingPartition = (String)pair.getRight();
                if (!StringUtils.isNullOrEmpty((String)missingPartition)) {
                    skippedPartitions.add(missingPartition);
                }
                return ((List)pair.getLeft()).stream();
            }).collect(Collectors.toList());
            clusteringGroups = collectedGroups.stream().limit(clusteringMaxNumGroups).collect(Collectors.toList());
            collectedGroups.subList(Math.min(clusteringMaxNumGroups, collectedGroups.size()), collectedGroups.size()).forEach(group -> {
                String missed = ((HoodieSliceInfo)group.getSlices().get(0)).getPartitionPath();
                skippedPartitions.add(missed);
            });
            skippedPartitions.addAll(missingPartitions);
            missingPartitions = new ArrayList(skippedPartitions);
        } else {
            clusteringGroups = res.stream().flatMap(pair -> ((List)pair.getLeft()).stream()).limit(clusteringMaxNumGroups).collect(Collectors.toList());
            missingPartitions = null;
        }
        if (clusteringGroups.isEmpty()) {
            LOG.warn("No data available to cluster");
            return Option.empty();
        }
        HoodieClusteringStrategy strategy = HoodieClusteringStrategy.newBuilder().setStrategyClassName(this.getWriteConfig().getClusteringExecutionStrategyClass()).setStrategyParams(this.getStrategyParams()).build();
        return Option.of((Object)HoodieClusteringPlan.newBuilder().setStrategy(strategy).setInputGroups(clusteringGroups).setExtraMetadata(this.getExtraMetadata()).setVersion(Integer.valueOf(this.getPlanVersion())).setPreserveHoodieMetadata(Boolean.valueOf(true)).setMissingSchedulePartitions(missingPartitions).build());
    }

    public List<String> getRegexPatternMatchedPartitions(HoodieWriteConfig config, List<String> partitionPaths) {
        String pattern = config.getClusteringPartitionFilterRegexPattern();
        if (!StringUtils.isNullOrEmpty((String)pattern)) {
            partitionPaths = partitionPaths.stream().filter(partition -> Pattern.matches(pattern, partition)).collect(Collectors.toList());
        }
        return partitionPaths;
    }

    protected int getNumberOfOutputFileGroups(long groupSize, long targetFileSize) {
        return (int)Math.ceil((double)groupSize / (double)targetFileSize);
    }
}

