/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.storage.HoodieStorageLayout;

@ConfigClassProperty(name="Layout Configs", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Configurations that control storage layout and data distribution, which defines how the files are organized within a table.")
@Immutable
public class HoodieLayoutConfig
extends HoodieConfig {
    public static final ConfigProperty<String> LAYOUT_TYPE = ConfigProperty.key((String)"hoodie.storage.layout.type").defaultValue((Object)HoodieStorageLayout.LayoutType.DEFAULT.name()).markAdvanced().withDocumentation(HoodieStorageLayout.LayoutType.class);
    public static final ConfigProperty<String> LAYOUT_PARTITIONER_CLASS_NAME = ConfigProperty.key((String)"hoodie.storage.layout.partitioner.class").noDefaultValue().markAdvanced().withDocumentation("Partitioner class, it is used to distribute data in a specific way.");
    public static final String SIMPLE_BUCKET_LAYOUT_PARTITIONER_CLASS_NAME = "org.apache.hudi.table.action.commit.SparkBucketIndexPartitioner";

    private HoodieLayoutConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        public HoodieLayoutConfig layoutConfig = new HoodieLayoutConfig();

        public Builder fromProperties(Properties props) {
            this.layoutConfig.getProps().putAll((Map)props);
            return this;
        }

        public Builder withLayoutType(String type) {
            this.layoutConfig.setValue(LAYOUT_TYPE, type);
            return this;
        }

        public Builder withLayoutPartitioner(String partitionerClass) {
            this.layoutConfig.setValue(LAYOUT_PARTITIONER_CLASS_NAME, partitionerClass);
            return this;
        }

        public HoodieLayoutConfig build() {
            this.setDefault();
            return this.layoutConfig;
        }

        private void setDefault() {
            if (this.layoutConfig.contains(HoodieIndexConfig.INDEX_TYPE.key()) && this.layoutConfig.getString(HoodieIndexConfig.INDEX_TYPE.key()).equals(HoodieIndex.IndexType.BUCKET.name())) {
                this.layoutConfig.setDefaultValue(LAYOUT_TYPE, HoodieStorageLayout.LayoutType.BUCKET.name());
                if ("SIMPLE".equals(this.layoutConfig.getString(HoodieIndexConfig.BUCKET_INDEX_ENGINE_TYPE))) {
                    this.layoutConfig.setDefaultValue(LAYOUT_PARTITIONER_CLASS_NAME, HoodieLayoutConfig.SIMPLE_BUCKET_LAYOUT_PARTITIONER_CLASS_NAME);
                }
            }
            this.layoutConfig.setDefaultValue(LAYOUT_TYPE, LAYOUT_TYPE.defaultValue());
        }
    }
}

