/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.client.bootstrap.BootstrapMode;
import org.apache.hudi.client.bootstrap.selector.MetadataOnlyBootstrapModeSelector;
import org.apache.hudi.client.bootstrap.translator.IdentityBootstrapPartitionPathTranslator;
import org.apache.hudi.common.bootstrap.index.hfile.HFileBootstrapIndex;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.model.BootstrapIndexType;

@ConfigClassProperty(name="Bootstrap Configs", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Configurations that control how you want to bootstrap your existing tables for the first time into hudi. The bootstrap operation can flexibly avoid copying data over before you can use Hudi and support running the existing  writers and new hudi writers in parallel, to validate the migration.")
public class HoodieBootstrapConfig
extends HoodieConfig {
    public static final ConfigProperty<String> BASE_PATH = ConfigProperty.key((String)"hoodie.bootstrap.base.path").noDefaultValue().sinceVersion("0.6.0").withDocumentation("Base path of the dataset that needs to be bootstrapped as a Hudi table");
    public static final ConfigProperty<String> PARTITION_SELECTOR_REGEX_MODE = ConfigProperty.key((String)"hoodie.bootstrap.mode.selector.regex.mode").defaultValue((Object)BootstrapMode.METADATA_ONLY.name()).markAdvanced().sinceVersion("0.6.0").withValidValues(new String[]{BootstrapMode.METADATA_ONLY.name(), BootstrapMode.FULL_RECORD.name()}).withDocumentation(BootstrapMode.class);
    public static final ConfigProperty<String> MODE_SELECTOR_CLASS_NAME = ConfigProperty.key((String)"hoodie.bootstrap.mode.selector").defaultValue((Object)MetadataOnlyBootstrapModeSelector.class.getCanonicalName()).markAdvanced().sinceVersion("0.6.0").withDocumentation("Selects the mode in which each file/partition in the bootstrapped dataset gets bootstrapped");
    public static final ConfigProperty<String> DATA_QUERIES_ONLY = ConfigProperty.key((String)"hoodie.bootstrap.data.queries.only").defaultValue((Object)"false").markAdvanced().sinceVersion("0.14.0").withDocumentation("Improves query performance, but queries cannot use hudi metadata fields");
    public static final ConfigProperty<String> FULL_BOOTSTRAP_INPUT_PROVIDER_CLASS_NAME = ConfigProperty.key((String)"hoodie.bootstrap.full.input.provider").defaultValue((Object)"org.apache.hudi.bootstrap.SparkParquetBootstrapDataProvider").markAdvanced().sinceVersion("0.6.0").withDocumentation("Class to use for reading the bootstrap dataset partitions/files, for Bootstrap mode FULL_RECORD");
    public static final ConfigProperty<String> PARTITION_PATH_TRANSLATOR_CLASS_NAME = ConfigProperty.key((String)"hoodie.bootstrap.partitionpath.translator.class").defaultValue((Object)IdentityBootstrapPartitionPathTranslator.class.getName()).markAdvanced().sinceVersion("0.6.0").withDocumentation("Translates the partition paths from the bootstrapped data into how is laid out as a Hudi table.");
    public static final ConfigProperty<String> PARALLELISM_VALUE = ConfigProperty.key((String)"hoodie.bootstrap.parallelism").defaultValue((Object)"1500").markAdvanced().sinceVersion("0.6.0").withDocumentation("For metadata-only bootstrap, Hudi parallelizes the operation so that each table partition is handled by one Spark task. This config limits the number of parallelism. We pick the configured parallelism if the number of table partitions is larger than this configured value. The parallelism is assigned to the number of table partitions if it is smaller than the configured value. For full-record bootstrap, i.e., BULK_INSERT operation of the records, this configured value is passed as the BULK_INSERT shuffle parallelism (`hoodie.bulkinsert.shuffle.parallelism`), determining the BULK_INSERT write behavior. If you see that the bootstrap is slow due to the limited parallelism, you can increase this.");
    public static final ConfigProperty<String> PARTITION_SELECTOR_REGEX_PATTERN = ConfigProperty.key((String)"hoodie.bootstrap.mode.selector.regex").defaultValue((Object)".*").markAdvanced().sinceVersion("0.6.0").withDocumentation("Matches each bootstrap dataset partition against this regex and applies the mode below to it.");
    public static final ConfigProperty<String> INDEX_CLASS_NAME = ConfigProperty.key((String)"hoodie.bootstrap.index.class").defaultValue((Object)HFileBootstrapIndex.class.getName()).markAdvanced().sinceVersion("0.6.0").withDocumentation("Implementation to use, for mapping a skeleton base file to a bootstrap base file.");
    @Deprecated
    public static final String BOOTSTRAP_BASE_PATH_PROP = BASE_PATH.key();
    @Deprecated
    public static final String BOOTSTRAP_INDEX_CLASS_PROP = INDEX_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_BOOTSTRAP_INDEX_CLASS = (String)INDEX_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String BOOTSTRAP_MODE_SELECTOR = MODE_SELECTOR_CLASS_NAME.key();
    @Deprecated
    public static final String FULL_BOOTSTRAP_INPUT_PROVIDER = FULL_BOOTSTRAP_INPUT_PROVIDER_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_FULL_BOOTSTRAP_INPUT_PROVIDER = (String)FULL_BOOTSTRAP_INPUT_PROVIDER_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String BOOTSTRAP_PARTITION_PATH_TRANSLATOR_CLASS = PARTITION_PATH_TRANSLATOR_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_BOOTSTRAP_PARTITION_PATH_TRANSLATOR_CLASS = (String)PARTITION_PATH_TRANSLATOR_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String BOOTSTRAP_PARALLELISM = PARALLELISM_VALUE.key();
    @Deprecated
    public static final String DEFAULT_BOOTSTRAP_PARALLELISM = (String)PARALLELISM_VALUE.defaultValue();
    @Deprecated
    public static final String BOOTSTRAP_MODE_SELECTOR_REGEX = PARTITION_SELECTOR_REGEX_PATTERN.key();
    @Deprecated
    public static final String BOOTSTRAP_MODE_SELECTOR_REGEX_MODE = PARTITION_SELECTOR_REGEX_MODE.key();
    @Deprecated
    public static final String DEFAULT_BOOTSTRAP_MODE_SELECTOR_REGEX = (String)PARTITION_SELECTOR_REGEX_PATTERN.defaultValue();
    @Deprecated
    public static final String DEFAULT_BOOTSTRAP_MODE_SELECTOR_REGEX_MODE = (String)PARTITION_SELECTOR_REGEX_MODE.defaultValue();

    private HoodieBootstrapConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodieBootstrapConfig bootstrapConfig = new HoodieBootstrapConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.bootstrapConfig.getProps().load((Reader)reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder withBootstrapBasePath(String basePath) {
            this.bootstrapConfig.setValue(BASE_PATH, basePath);
            return this;
        }

        public Builder withBootstrapModeSelector(String partitionSelectorClass) {
            this.bootstrapConfig.setValue(MODE_SELECTOR_CLASS_NAME, partitionSelectorClass);
            return this;
        }

        public Builder withFullBootstrapInputProvider(String partitionSelectorClass) {
            this.bootstrapConfig.setValue(FULL_BOOTSTRAP_INPUT_PROVIDER_CLASS_NAME, partitionSelectorClass);
            return this;
        }

        public Builder withBootstrapPartitionPathTranslatorClass(String partitionPathTranslatorClass) {
            this.bootstrapConfig.setValue(PARTITION_PATH_TRANSLATOR_CLASS_NAME, partitionPathTranslatorClass);
            return this;
        }

        public Builder withBootstrapParallelism(int parallelism) {
            this.bootstrapConfig.setValue(PARALLELISM_VALUE, String.valueOf(parallelism));
            return this;
        }

        public Builder withBootstrapModeSelectorRegex(String regex) {
            this.bootstrapConfig.setValue(PARTITION_SELECTOR_REGEX_PATTERN, regex);
            return this;
        }

        public Builder withBootstrapModeForRegexMatch(BootstrapMode modeForRegexMatch) {
            this.bootstrapConfig.setValue(PARTITION_SELECTOR_REGEX_MODE, modeForRegexMatch.name());
            return this;
        }

        public Builder fromProperties(Properties props) {
            this.bootstrapConfig.getProps().putAll((Map)props);
            return this;
        }

        public HoodieBootstrapConfig build() {
            this.bootstrapConfig.setDefaultValue(INDEX_CLASS_NAME, BootstrapIndexType.getDefaultBootstrapIndexClassName((HoodieConfig)this.bootstrapConfig));
            this.bootstrapConfig.setDefaults(HoodieBootstrapConfig.class.getName());
            return this.bootstrapConfig;
        }
    }
}

