/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.common.lock.LockState;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class BaseZookeeperBasedLockProvider
implements LockProvider<InterProcessMutex>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(BaseZookeeperBasedLockProvider.class);
    private final transient CuratorFramework curatorFrameworkClient;
    private volatile InterProcessMutex lock = null;
    protected final LockConfiguration lockConfiguration;
    protected final String zkBasePath;
    protected final String lockKey;

    public BaseZookeeperBasedLockProvider(LockConfiguration lockConfiguration, StorageConfiguration<?> conf) {
        this.checkRequiredProps(lockConfiguration);
        this.lockConfiguration = lockConfiguration;
        this.zkBasePath = this.getZkBasePath(lockConfiguration);
        this.lockKey = this.getLockKey(lockConfiguration);
        this.curatorFrameworkClient = CuratorFrameworkFactory.builder().connectString(ConfigUtils.getStringWithAltKeys((Properties)lockConfiguration.getConfig(), HoodieLockConfig.ZK_CONNECT_URL)).retryPolicy((RetryPolicy)new BoundedExponentialBackoffRetry(ConfigUtils.getIntWithAltKeys((Properties)lockConfiguration.getConfig(), HoodieLockConfig.LOCK_ACQUIRE_RETRY_WAIT_TIME_IN_MILLIS), ConfigUtils.getIntWithAltKeys((Properties)lockConfiguration.getConfig(), HoodieLockConfig.LOCK_ACQUIRE_RETRY_MAX_WAIT_TIME_IN_MILLIS), ConfigUtils.getIntWithAltKeys((Properties)lockConfiguration.getConfig(), HoodieLockConfig.LOCK_ACQUIRE_NUM_RETRIES))).sessionTimeoutMs(ConfigUtils.getIntWithAltKeys((Properties)lockConfiguration.getConfig(), HoodieLockConfig.ZK_SESSION_TIMEOUT_MS)).connectionTimeoutMs(ConfigUtils.getIntWithAltKeys((Properties)lockConfiguration.getConfig(), HoodieLockConfig.ZK_CONNECTION_TIMEOUT_MS)).build();
        this.curatorFrameworkClient.start();
        this.createPathIfNotExists();
    }

    protected abstract String getZkBasePath(LockConfiguration var1);

    protected abstract String getLockKey(LockConfiguration var1);

    protected String generateLogSuffixString() {
        return StringUtils.join((String[])new String[]{"ZkBasePath = ", this.zkBasePath, ", lock key = ", this.lockKey});
    }

    protected String getLockPath() {
        return this.zkBasePath + '/' + this.lockKey;
    }

    private void createPathIfNotExists() {
        try {
            String lockPath = this.getLockPath();
            LOG.info(String.format("Creating zookeeper path %s if not exists", lockPath));
            String[] parts = lockPath.split("/");
            StringBuilder currentPath = new StringBuilder();
            for (String part : parts) {
                if (part.isEmpty()) continue;
                currentPath.append("/").append(part);
                this.createNodeIfNotExists(currentPath.toString());
            }
        }
        catch (Exception e) {
            LOG.error("Failed to create ZooKeeper path: " + e.getMessage());
            throw new HoodieLockException("Failed to initialize ZooKeeper path", (Throwable)e);
        }
    }

    private void createNodeIfNotExists(String path) throws Exception {
        if (this.curatorFrameworkClient.checkExists().forPath(path) == null) {
            try {
                this.curatorFrameworkClient.create().forPath(path);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) {
                    LOG.debug(String.format("Node already exist for path = %s", path));
                }
                throw new HoodieLockException("Failed to create zookeeper node", (Throwable)e);
            }
        }
    }

    public boolean tryLock(long time, TimeUnit unit) {
        LOG.info(this.generateLogStatement(LockState.ACQUIRING, this.generateLogSuffixString()));
        try {
            this.acquireLock(time, unit);
            LOG.info(this.generateLogStatement(LockState.ACQUIRED, this.generateLogSuffixString()));
        }
        catch (HoodieLockException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_ACQUIRE, this.generateLogSuffixString()), (Throwable)e);
        }
        return this.lock != null && this.lock.isAcquiredInThisProcess();
    }

    public void unlock() {
        try {
            LOG.info(this.generateLogStatement(LockState.RELEASING, this.generateLogSuffixString()));
            if (this.lock == null || !this.lock.isAcquiredInThisProcess()) {
                return;
            }
            this.lock.release();
            this.lock = null;
            LOG.info(this.generateLogStatement(LockState.RELEASED, this.generateLogSuffixString()));
        }
        catch (Exception e) {
            throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_RELEASE, this.generateLogSuffixString()), (Throwable)e);
        }
    }

    public void close() {
        try {
            if (this.lock != null) {
                this.lock.release();
                this.lock = null;
            }
            this.curatorFrameworkClient.close();
        }
        catch (Exception e) {
            LOG.error(this.generateLogStatement(LockState.FAILED_TO_RELEASE, this.generateLogSuffixString()));
        }
    }

    public InterProcessMutex getLock() {
        return this.lock;
    }

    private void acquireLock(long time, TimeUnit unit) throws Exception {
        ValidationUtils.checkArgument((this.lock == null ? 1 : 0) != 0, (String)this.generateLogStatement(LockState.ALREADY_ACQUIRED, this.generateLogSuffixString()));
        InterProcessMutex newLock = new InterProcessMutex(this.curatorFrameworkClient, this.getLockPath());
        boolean acquired = newLock.acquire(time, unit);
        if (!acquired) {
            throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_ACQUIRE, this.generateLogSuffixString()));
        }
        if (!newLock.isAcquiredInThisProcess()) {
            throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_ACQUIRE, this.generateLogSuffixString()));
        }
        this.lock = newLock;
    }

    private void checkRequiredProps(LockConfiguration config) {
        ValidationUtils.checkArgument((config.getConfig().getString("hoodie.write.lock.zookeeper.url") != null ? 1 : 0) != 0);
    }

    protected String generateLogStatement(LockState state, String suffix) {
        return StringUtils.join((String[])new String[]{state.name(), " lock at", suffix});
    }
}

