/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.hudi.client.utils.LazyConcatenatingIterator;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLazyConcatenatingIterator {
    int initTimes;
    int closeTimes;

    @Test
    public void testConcatBasic() {
        Supplier<ClosableIterator> i1 = () -> new MockClosableIterator(Arrays.asList(5, 3, 2, 1).iterator());
        Supplier<ClosableIterator> i2 = () -> new MockClosableIterator(Collections.emptyIterator());
        Supplier<ClosableIterator> i3 = () -> new MockClosableIterator(Collections.singletonList(3).iterator());
        LazyConcatenatingIterator ci = new LazyConcatenatingIterator(Arrays.asList(i1, i2, i3));
        Assertions.assertEquals((int)0, (int)this.initTimes);
        ArrayList<Object> allElements = new ArrayList<Object>();
        int count = 0;
        while (ci.hasNext()) {
            if (++count == 1) {
                Assertions.assertEquals((int)1, (int)this.initTimes);
                Assertions.assertEquals((int)0, (int)this.closeTimes);
            }
            if (count == 5) {
                Assertions.assertEquals((int)3, (int)this.initTimes);
                Assertions.assertEquals((int)2, (int)this.closeTimes);
            }
            allElements.add(ci.next());
        }
        Assertions.assertEquals((int)3, (int)this.initTimes);
        Assertions.assertEquals((int)3, (int)this.closeTimes);
        Assertions.assertEquals((int)5, (int)allElements.size());
        Assertions.assertEquals(Arrays.asList(5, 3, 2, 1, 3), allElements);
    }

    @Test
    public void testConcatError() {
        Supplier<ClosableIterator> i1 = () -> new MockClosableIterator(Collections.emptyIterator());
        LazyConcatenatingIterator ci = new LazyConcatenatingIterator(Collections.singletonList(i1));
        Assertions.assertFalse((boolean)ci.hasNext());
        try {
            ci.next();
            Assertions.fail((String)"expected error for empty iterator");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private class MockClosableIterator
    implements ClosableIterator {
        Iterator<Integer> iterator;

        public MockClosableIterator(Iterator<Integer> iterator) {
            ++TestLazyConcatenatingIterator.this.initTimes;
            this.iterator = iterator;
        }

        public void close() {
            ++TestLazyConcatenatingIterator.this.closeTimes;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }
    }
}

