/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantComparatorV2;
import org.apache.hudi.table.upgrade.UpgradeDowngradeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUpgradeDowngradeUtils {
    @Test
    void testConvertCompletionTimeToEpoch() {
        String completionTime = "20241112153045678";
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "20231112153045678", completionTime, InstantComparatorV2.COMPLETION_TIME_BASED_COMPARATOR);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        LocalDateTime dateTime = LocalDateTime.parse(completionTime.substring(0, completionTime.length() - 3), formatter);
        long expectedEpoch = dateTime.atZone(ZoneId.systemDefault()).toEpochSecond() * 1000L + Long.parseLong(completionTime.substring(completionTime.length() - 3));
        Assertions.assertEquals((long)expectedEpoch, (long)UpgradeDowngradeUtils.convertCompletionTimeToEpoch((HoodieInstant)instant), (String)"Epoch time does not match the expected value.");
        String invalidCompletionTime = "12345";
        HoodieInstant inValidInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "dummy_action", "20231112153045678", invalidCompletionTime, InstantComparatorV2.COMPLETION_TIME_BASED_COMPARATOR);
        Assertions.assertEquals((long)-1L, (long)UpgradeDowngradeUtils.convertCompletionTimeToEpoch((HoodieInstant)inValidInstant), (String)"Epoch time for invalid input should be -1.");
    }
}

