/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.collection.Triple;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.table.action.rollback.HoodieRollbackTestBase;
import org.apache.hudi.table.action.rollback.RollbackHelper;
import org.apache.hudi.table.action.rollback.SerializableHoodieRollbackRequest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class TestRollbackHelper
extends HoodieRollbackTestBase {
    private static final int ROLLBACK_LOG_VERSION = 20;

    TestRollbackHelper() {
    }

    @Override
    @BeforeEach
    void setup() throws IOException {
        super.setup();
    }

    @AfterEach
    void tearDown() throws IOException {
        this.storage.deleteDirectory(this.basePath);
    }

    @ParameterizedTest
    @ValueSource(strings={"SIX", "EIGHT"})
    void testMaybeDeleteAndCollectStatsWithMultipleRequestsPerFileGroup(HoodieTableVersion tableVersion) throws IOException {
        Mockito.when((Object)this.tableConfig.getTableVersion()).thenReturn((Object)tableVersion);
        String rollbackInstantTime = "003";
        String instantToRollback = "002";
        RollbackHelper rollbackHelper = new RollbackHelper(this.table, this.config);
        ArrayList<SerializableHoodieRollbackRequest> rollbackRequests = new ArrayList<SerializableHoodieRollbackRequest>();
        String baseInstantTimeOfLogFiles = "001";
        String partition1 = "partition1";
        String partition2 = "partition2";
        String baseFileId1 = UUID.randomUUID().toString();
        String baseFileId2 = UUID.randomUUID().toString();
        String baseFileId3 = UUID.randomUUID().toString();
        String logFileId1 = UUID.randomUUID().toString();
        String logFileId2 = UUID.randomUUID().toString();
        StoragePath baseFilePath1 = this.addRollbackRequestForBaseFile(rollbackRequests, partition1, baseFileId1, instantToRollback);
        StoragePath baseFilePath2 = this.addRollbackRequestForBaseFile(rollbackRequests, partition2, baseFileId2, instantToRollback);
        StoragePath baseFilePath3 = this.addRollbackRequestForBaseFile(rollbackRequests, partition2, baseFileId3, instantToRollback);
        Map<String, Long> logFilesToRollback1 = this.addRollbackRequestForLogFiles(rollbackRequests, tableVersion, partition2, logFileId1, baseInstantTimeOfLogFiles, IntStream.of(1));
        Map<String, Long> logFilesToRollback2 = IntStream.range(1, 20).boxed().flatMap(version -> this.addRollbackRequestForLogFiles(rollbackRequests, tableVersion, partition2, logFileId2, baseInstantTimeOfLogFiles, IntStream.of((int)version)).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        rollbackRequests.add(new SerializableHoodieRollbackRequest(HoodieRollbackRequest.newBuilder().setPartitionPath(partition2).setFileId(baseFileId3).setLatestBaseInstant(instantToRollback).setFilesToBeDeleted(Collections.emptyList()).setLogBlocksToBeDeleted(Collections.emptyMap()).build()));
        this.setupMocksAndValidateInitialState(rollbackInstantTime, rollbackRequests);
        List rollbackStats = rollbackHelper.maybeDeleteAndCollectStats((HoodieEngineContext)new HoodieLocalEngineContext(this.storage.getConf()), HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", instantToRollback), rollbackRequests, true, 5);
        this.validateStateAfterRollback(rollbackRequests);
        StoragePath rollbackLogPath1 = new StoragePath(new StoragePath(this.basePath, partition2), tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT) ? FSUtils.makeLogFileName((String)logFileId1, (String)HoodieFileFormat.HOODIE_LOG.getFileExtension(), (String)instantToRollback, (int)1, (String)"0-0-0") : FileCreateUtils.logFileName((String)baseInstantTimeOfLogFiles, (String)logFileId1, (int)2));
        StoragePath rollbackLogPath2 = new StoragePath(new StoragePath(this.basePath, partition2), tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT) ? FSUtils.makeLogFileName((String)logFileId2, (String)HoodieFileFormat.HOODIE_LOG.getFileExtension(), (String)instantToRollback, (int)1, (String)"0-0-0") : FileCreateUtils.logFileName((String)baseInstantTimeOfLogFiles, (String)logFileId2, (int)20));
        ArrayList<Pair<String, HoodieRollbackStat>> expected = new ArrayList<Pair<String, HoodieRollbackStat>>();
        expected.add(Pair.of((Object)partition1, (Object)HoodieRollbackStat.newBuilder().withPartitionPath(partition1).withDeletedFileResult(baseFilePath1.toString(), true).build()));
        expected.add(Pair.of((Object)partition2, (Object)HoodieRollbackStat.newBuilder().withPartitionPath(partition2).withDeletedFileResult(baseFilePath2.toString(), true).build()));
        expected.add(Pair.of((Object)partition2, (Object)HoodieRollbackStat.newBuilder().withPartitionPath(partition2).withDeletedFileResult(baseFilePath3.toString(), true).build()));
        if (tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT)) {
            this.getFullLogPathList(logFilesToRollback1.keySet(), partition2).forEach(logFilePath -> expected.add(Pair.of((Object)partition2, (Object)HoodieRollbackStat.newBuilder().withPartitionPath(partition2).withDeletedFileResult(logFilePath, true).build())));
            this.getFullLogPathList(logFilesToRollback2.keySet(), partition2).forEach(logFilePath -> expected.add(Pair.of((Object)partition2, (Object)HoodieRollbackStat.newBuilder().withPartitionPath(partition2).withDeletedFileResult(logFilePath, true).build())));
        } else {
            expected.add(Pair.of((Object)partition2, (Object)HoodieRollbackStat.newBuilder().withPartitionPath(partition2).withRollbackBlockAppendResults(Collections.singletonMap(this.storage.getPathInfo(rollbackLogPath1), 1L)).build()));
            expected.add((Pair<String, HoodieRollbackStat>)Pair.of((Object)partition2, (Object)HoodieRollbackStat.newBuilder().withPartitionPath(partition2).withRollbackBlockAppendResults(Collections.singletonMap(this.storage.getPathInfo(rollbackLogPath2), 1L)).build()));
        }
        expected.add(Pair.of((Object)partition2, (Object)HoodieRollbackStat.newBuilder().withPartitionPath(partition2).build()));
        this.assertRollbackStatsEquals(expected, rollbackStats);
    }

    @ParameterizedTest
    @ValueSource(strings={"SIX", "EIGHT"})
    void testMaybeDeleteAndCollectStatsWithSingleRequestPerFileGroup(HoodieTableVersion tableVersion) throws IOException {
        Mockito.when((Object)this.tableConfig.getTableVersion()).thenReturn((Object)tableVersion);
        String rollbackInstantTime = "003";
        String instantToRollback = "002";
        RollbackHelper rollbackHelper = new RollbackHelper(this.table, this.config);
        ArrayList<SerializableHoodieRollbackRequest> rollbackRequests = new ArrayList<SerializableHoodieRollbackRequest>();
        String baseInstantTimeOfLogFiles = "001";
        String partition = "partition1";
        String baseFileId = UUID.randomUUID().toString();
        String logFileId = UUID.randomUUID().toString();
        StoragePath baseFilePath = this.addRollbackRequestForBaseFile(rollbackRequests, partition, baseFileId, instantToRollback);
        Map<String, Long> logFilesToRollback = this.addRollbackRequestForLogFiles(rollbackRequests, tableVersion, partition, logFileId, baseInstantTimeOfLogFiles, IntStream.range(1, 20));
        this.setupMocksAndValidateInitialState(rollbackInstantTime, rollbackRequests);
        List rollbackStats = rollbackHelper.maybeDeleteAndCollectStats((HoodieEngineContext)new HoodieLocalEngineContext(this.storage.getConf()), HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", instantToRollback), rollbackRequests, true, 5);
        this.validateStateAfterRollback(rollbackRequests);
        StoragePath rollbackLogPath = new StoragePath(new StoragePath(this.basePath, partition), tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT) ? FSUtils.makeLogFileName((String)logFileId, (String)HoodieFileFormat.HOODIE_LOG.getFileExtension(), (String)instantToRollback, (int)1, (String)"0-0-0") : FileCreateUtils.logFileName((String)baseInstantTimeOfLogFiles, (String)logFileId, (int)20));
        ArrayList<Pair<String, HoodieRollbackStat>> expected = new ArrayList<Pair<String, HoodieRollbackStat>>();
        expected.add(Pair.of((Object)partition, (Object)HoodieRollbackStat.newBuilder().withPartitionPath(partition).withDeletedFileResult(baseFilePath.toString(), true).build()));
        if (tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT)) {
            this.getFullLogPathList(logFilesToRollback.keySet(), partition).forEach(logFilePath -> expected.add(Pair.of((Object)partition, (Object)HoodieRollbackStat.newBuilder().withPartitionPath(partition).withDeletedFileResult(logFilePath, true).build())));
        } else {
            expected.add((Pair<String, HoodieRollbackStat>)Pair.of((Object)partition, (Object)HoodieRollbackStat.newBuilder().withPartitionPath(partition).withRollbackBlockAppendResults(Collections.singletonMap(this.storage.getPathInfo(rollbackLogPath), 1L)).build()));
        }
        this.assertRollbackStatsEquals(expected, rollbackStats);
    }

    private void assertRollbackStatsEquals(List<Pair<String, HoodieRollbackStat>> expected, List<Pair<String, HoodieRollbackStat>> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        List<Pair<String, HoodieRollbackStat>> sortedExpected = TestRollbackHelper.getSortedRollbackStats(expected);
        List<Pair<String, HoodieRollbackStat>> sortedActual = TestRollbackHelper.getSortedRollbackStats(actual);
        for (int i = 0; i < sortedExpected.size(); ++i) {
            Pair<String, HoodieRollbackStat> expectedStat = sortedExpected.get(i);
            Pair<String, HoodieRollbackStat> actualStat = sortedActual.get(i);
            Assertions.assertEquals((Object)expectedStat.getKey(), (Object)actualStat.getKey());
            Assertions.assertEquals((Object)((HoodieRollbackStat)expectedStat.getValue()).getPartitionPath(), (Object)((HoodieRollbackStat)actualStat.getValue()).getPartitionPath());
            Assertions.assertEquals(((HoodieRollbackStat)expectedStat.getValue()).getSuccessDeleteFiles().stream().sorted().collect(Collectors.toList()), ((HoodieRollbackStat)actualStat.getValue()).getSuccessDeleteFiles().stream().sorted().collect(Collectors.toList()));
            Assertions.assertEquals(((HoodieRollbackStat)expectedStat.getValue()).getFailedDeleteFiles().stream().sorted().collect(Collectors.toList()), ((HoodieRollbackStat)actualStat.getValue()).getFailedDeleteFiles().stream().sorted().collect(Collectors.toList()));
            Assertions.assertEquals((int)((HoodieRollbackStat)expectedStat.getValue()).getCommandBlocksCount().size(), (int)((HoodieRollbackStat)actualStat.getValue()).getCommandBlocksCount().size());
            if (!((HoodieRollbackStat)expectedStat.getValue()).getCommandBlocksCount().isEmpty()) {
                Assertions.assertEquals((Object)((StoragePathInfo)((HoodieRollbackStat)expectedStat.getValue()).getCommandBlocksCount().keySet().stream().findFirst().get()).getPath(), (Object)((StoragePathInfo)((HoodieRollbackStat)actualStat.getValue()).getCommandBlocksCount().keySet().stream().findFirst().get()).getPath());
            }
            Map expectedLogFileMap = ((HoodieRollbackStat)expectedStat.getValue()).getLogFilesFromFailedCommit();
            Map actualLogFileMap = ((HoodieRollbackStat)actualStat.getValue()).getLogFilesFromFailedCommit();
            Assertions.assertEquals((int)expectedLogFileMap.size(), (int)actualLogFileMap.size());
            for (Map.Entry entry : expectedLogFileMap.entrySet()) {
                Assertions.assertTrue((boolean)actualLogFileMap.containsKey(entry.getKey()));
                Assertions.assertEquals((Long)((Long)entry.getValue()), (Long)((Long)actualLogFileMap.get(entry.getKey())));
            }
        }
    }

    private static List<Pair<String, HoodieRollbackStat>> getSortedRollbackStats(List<Pair<String, HoodieRollbackStat>> rollbackStats) {
        return rollbackStats.stream().sorted(Comparator.comparing(e -> Triple.of((Object)((HoodieRollbackStat)e.getRight()).getSuccessDeleteFiles().size(), (Object)((HoodieRollbackStat)e.getRight()).getCommandBlocksCount().size(), (Object)(!((HoodieRollbackStat)e.getRight()).getSuccessDeleteFiles().isEmpty() ? (Serializable)((HoodieRollbackStat)e.getRight()).getSuccessDeleteFiles().get(0) : (!((HoodieRollbackStat)e.getRight()).getCommandBlocksCount().isEmpty() ? (Serializable)((HoodieRollbackStat)e.getRight()).getCommandBlocksCount().keySet().stream().findFirst().get() : ""))), Comparator.naturalOrder())).collect(Collectors.toList());
    }

    private StoragePath addRollbackRequestForBaseFile(List<SerializableHoodieRollbackRequest> rollbackRequests, String partition, String fileId, String instantTime) throws IOException {
        StoragePath baseFilePath = this.createBaseFileToRollback(partition, fileId, instantTime);
        rollbackRequests.add(new SerializableHoodieRollbackRequest(HoodieRollbackRequest.newBuilder().setPartitionPath(partition).setFileId(fileId).setLatestBaseInstant(instantTime).setFilesToBeDeleted(Collections.singletonList(baseFilePath.toString())).setLogBlocksToBeDeleted(Collections.emptyMap()).build()));
        return baseFilePath;
    }

    private Map<String, Long> addRollbackRequestForLogFiles(List<SerializableHoodieRollbackRequest> rollbackRequests, HoodieTableVersion tableVersion, String partition, String fileId, String instantTime, IntStream logVersions) {
        Map<String, Long> logBlocksToBeDeleted = this.createLogFilesToRollback(partition, fileId, instantTime, logVersions, 10L);
        HoodieRollbackRequest.Builder builder = HoodieRollbackRequest.newBuilder().setPartitionPath(partition).setFileId(fileId).setLatestBaseInstant(instantTime);
        if (tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT)) {
            builder.setFilesToBeDeleted(this.getFullLogPathList(logBlocksToBeDeleted.keySet(), partition)).setLogBlocksToBeDeleted(Collections.emptyMap());
        } else {
            builder.setFilesToBeDeleted(Collections.emptyList()).setLogBlocksToBeDeleted(logBlocksToBeDeleted);
        }
        rollbackRequests.add(new SerializableHoodieRollbackRequest(builder.build()));
        return logBlocksToBeDeleted;
    }

    private List<String> getFullLogPathList(Collection<String> logFileNames, String partition) {
        return logFileNames.stream().map(logFileName -> new StoragePath(new StoragePath(this.basePath, partition), logFileName).toString()).collect(Collectors.toList());
    }

    private void setupMocksAndValidateInitialState(String rollbackInstantTime, List<SerializableHoodieRollbackRequest> rollbackRequests) {
        Mockito.when((Object)this.timeline.lastInstant()).thenReturn((Object)Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "rollback", rollbackInstantTime)));
        rollbackRequests.forEach(request -> {
            if (!request.getFilesToBeDeleted().isEmpty()) {
                Assertions.assertTrue((boolean)request.getFilesToBeDeleted().stream().map(path -> {
                    try {
                        return this.storage.exists(new StoragePath(path));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }).reduce(Boolean::logicalAnd).get());
            } else if (!request.getLogBlocksToBeDeleted().isEmpty()) {
                StoragePath partitionPath = new StoragePath(this.basePath, request.getPartitionPath());
                Assertions.assertTrue((boolean)request.getLogBlocksToBeDeleted().keySet().stream().map(logFileName -> {
                    try {
                        return this.storage.exists(new StoragePath(partitionPath, logFileName));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }).reduce(Boolean::logicalAnd).get());
            }
        });
    }

    private void validateStateAfterRollback(List<SerializableHoodieRollbackRequest> rollbackRequests) {
        rollbackRequests.forEach(request -> {
            if (!request.getFilesToBeDeleted().isEmpty()) {
                Assertions.assertFalse((boolean)request.getFilesToBeDeleted().stream().map(path -> {
                    try {
                        return this.storage.exists(new StoragePath(path));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }).reduce(Boolean::logicalOr).get());
            } else if (!request.getLogBlocksToBeDeleted().isEmpty()) {
                StoragePath partitionPath = new StoragePath(this.basePath, request.getPartitionPath());
                Assertions.assertTrue((boolean)request.getLogBlocksToBeDeleted().keySet().stream().map(logFileName -> {
                    try {
                        return this.storage.exists(new StoragePath(partitionPath, logFileName));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }).reduce(Boolean::logicalAnd).get());
            }
        });
    }
}

