/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.io.IOException;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseTableServicePlanActionExecutor;
import org.apache.hudi.table.action.compact.ScheduleCompactionActionExecutor;
import org.apache.hudi.table.action.compact.plan.generators.HoodieCompactionPlanGenerator;
import org.apache.hudi.table.action.compact.strategy.LogFileNumBasedCompactionStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class TestScheduleCompactionActionExecutor
extends HoodieCommonTestHarness {
    private final HoodieEngineContext context = new HoodieLocalEngineContext(HadoopFSUtils.getStorageConf());
    @Mock
    private HoodieWriteConfig config;
    @Mock
    private HoodieTable table;

    TestScheduleCompactionActionExecutor() {
    }

    @Test
    void testInitPlanGenerator() throws IOException {
        this.initMetaClient();
        TypedProperties properties = new TypedProperties();
        properties.put((Object)HoodieCompactionConfig.COMPACTION_PLAN_GENERATOR.key(), (Object)TestCompactionPlanGenerator.class.getName());
        Mockito.when((Object)this.config.getProps()).thenReturn((Object)properties);
        Mockito.when((Object)this.config.getCompactionStrategy()).thenReturn((Object)new LogFileNumBasedCompactionStrategy());
        Assertions.assertDoesNotThrow(() -> new ScheduleCompactionActionExecutor(this.context, this.config, this.table, "001", Option.empty(), WriteOperationType.COMPACT));
        Assertions.assertEquals((int)1, (int)TestCompactionPlanGenerator.getCount());
    }

    public static class TestCompactionPlanGenerator<T extends HoodieRecordPayload, I, K, O>
    extends HoodieCompactionPlanGenerator<T, I, K, O> {
        private static int count = 0;

        public TestCompactionPlanGenerator(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig, BaseTableServicePlanActionExecutor executor) {
            super(table, engineContext, writeConfig, executor);
            ++count;
        }

        public static int getCount() {
            return count;
        }
    }
}

