/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.clean;

import java.io.IOException;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.timeline.versioning.v1.InstantComparatorV1;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.clean.CleanPlanActionExecutor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class TestCleanPlanActionExecutor {
    TestCleanPlanActionExecutor() {
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void emptyCompletedCleanReturnsPreviousCleanPlan(boolean isEmptyPlan) throws IOException, InstantiationException, IllegalAccessException {
        HoodieCleanerPlan cleanerPlan;
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HoodieActiveTimeline activeTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        TestCleanPlanActionExecutor.mockThatCleanIsRequired(table);
        HoodieInstant lastCompletedInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", "001", InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        HoodieInstant lastInflightInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "clean", "001", InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        TestCleanPlanActionExecutor.mockEmptyLastCompletedClean(table, lastCompletedInstant, activeTimeline);
        if (isEmptyPlan) {
            Mockito.when((Object)activeTimeline.readCleanerPlan(lastInflightInstant)).thenReturn(HoodieCleanerPlan.class.newInstance());
            cleanerPlan = new HoodieCleanerPlan();
        } else {
            cleanerPlan = HoodieCleanerPlan.newBuilder().setEarliestInstantToRetain(HoodieActionInstant.newBuilder().setAction("commit").setTimestamp("001").setState(HoodieInstant.State.COMPLETED.name()).build()).setLastCompletedCommitTimestamp("002").setPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name()).setVersion(TimelineLayoutVersion.CURR_VERSION).build();
            Mockito.when((Object)activeTimeline.readCleanerPlan(lastInflightInstant)).thenReturn((Object)cleanerPlan);
        }
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext((StorageConfiguration)new HadoopStorageConfiguration(Boolean.valueOf(false)));
        CleanPlanActionExecutor executor = new CleanPlanActionExecutor((HoodieEngineContext)engineContext, HoodieWriteConfig.newBuilder().withPath("file://tmp").build(), table, "002", Option.empty());
        Option actualPlan = executor.requestClean("002");
        Assertions.assertEquals((Object)Option.of((Object)cleanerPlan), (Object)actualPlan);
        ((HoodieActiveTimeline)Mockito.verify((Object)activeTimeline)).deleteEmptyInstantIfExists(lastCompletedInstant);
    }

    @Test
    void emptyCompletedClean_failsToReadPreviousPlan() throws IOException {
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HoodieActiveTimeline activeTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        TestCleanPlanActionExecutor.mockThatCleanIsRequired(table);
        HoodieInstant lastCompletedInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", "001", InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        HoodieInstant lastInflightInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "clean", "001", InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        TestCleanPlanActionExecutor.mockEmptyLastCompletedClean(table, lastCompletedInstant, activeTimeline);
        Mockito.when((Object)activeTimeline.readCleanerPlan(lastInflightInstant)).thenThrow(new Throwable[]{new HoodieIOException("failed to read")});
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext((StorageConfiguration)new HadoopStorageConfiguration(Boolean.valueOf(false)));
        CleanPlanActionExecutor executor = new CleanPlanActionExecutor((HoodieEngineContext)engineContext, HoodieWriteConfig.newBuilder().withPath("file://tmp").build(), table, "002", Option.empty());
        Assertions.assertThrows(HoodieIOException.class, () -> executor.requestClean("002"));
    }

    @Test
    void lastCleanIsNonEmpty() {
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HoodieActiveTimeline activeTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        TestCleanPlanActionExecutor.mockThatCleanIsRequired(table);
        HoodieInstant lastCompletedInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", "001", InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        Mockito.when((Object)table.getCleanTimeline().filterCompletedInstants().lastInstant()).thenReturn((Object)Option.of((Object)lastCompletedInstant));
        Mockito.when((Object)table.getActiveTimeline()).thenReturn((Object)activeTimeline);
        Mockito.when((Object)activeTimeline.isEmpty(lastCompletedInstant)).thenReturn((Object)false);
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext((StorageConfiguration)new HadoopStorageConfiguration(Boolean.valueOf(false)));
        CleanPlanActionExecutor executor = (CleanPlanActionExecutor)Mockito.spy((Object)new CleanPlanActionExecutor((HoodieEngineContext)engineContext, HoodieWriteConfig.newBuilder().withPath("file://tmp").build(), table, "002", Option.empty()));
        HoodieCleanerPlan emptyPlan = new HoodieCleanerPlan();
        ((CleanPlanActionExecutor)Mockito.doReturn((Object)emptyPlan).when((Object)executor)).requestClean((HoodieEngineContext)engineContext);
        Assertions.assertEquals((Object)Option.empty(), (Object)executor.requestClean("002"));
    }

    @Test
    void lastCleanIsNotPresent() {
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        TestCleanPlanActionExecutor.mockThatCleanIsRequired(table);
        Mockito.when((Object)table.getCleanTimeline().filterCompletedInstants().lastInstant()).thenReturn((Object)Option.empty());
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext((StorageConfiguration)new HadoopStorageConfiguration(Boolean.valueOf(false)));
        CleanPlanActionExecutor executor = (CleanPlanActionExecutor)Mockito.spy((Object)new CleanPlanActionExecutor((HoodieEngineContext)engineContext, HoodieWriteConfig.newBuilder().withPath("file://tmp").build(), table, "002", Option.empty()));
        HoodieCleanerPlan emptyPlan = new HoodieCleanerPlan();
        ((CleanPlanActionExecutor)Mockito.doReturn((Object)emptyPlan).when((Object)executor)).requestClean((HoodieEngineContext)engineContext);
        Assertions.assertEquals((Object)Option.empty(), (Object)executor.requestClean("002"));
    }

    private static void mockEmptyLastCompletedClean(HoodieTable table, HoodieInstant lastCompletedInstant, HoodieActiveTimeline activeTimeline) {
        Mockito.when((Object)table.getCleanTimeline().filterCompletedInstants().lastInstant()).thenReturn((Object)Option.of((Object)lastCompletedInstant));
        Mockito.when((Object)table.getActiveTimeline()).thenReturn((Object)activeTimeline);
        Mockito.when((Object)activeTimeline.isEmpty(lastCompletedInstant)).thenReturn((Object)true);
    }

    private static void mockThatCleanIsRequired(HoodieTable table) {
        Mockito.when((Object)table.getActiveTimeline().getCleanerTimeline().filterCompletedInstants().lastInstant()).thenReturn((Object)Option.empty());
        HoodieTimeline commitsTimeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        Mockito.when((Object)table.getActiveTimeline().getCommitsTimeline().filterCompletedInstants()).thenReturn((Object)commitsTimeline);
        Mockito.when((Object)commitsTimeline.countInstants()).thenReturn((Object)2);
    }
}

