/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.IOException;
import java.util.function.Function;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.common.HoodiePendingRollbackInfo;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.v1.InstantComparatorV1;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SerializationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.TestBaseHoodieTable;
import org.apache.hudi.table.storage.HoodieStorageLayout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestHoodieTable
extends HoodieCommonTestHarness {
    TestHoodieTable() {
    }

    @Test
    void getIndexReturnsCachedInstance() throws IOException {
        this.initMetaClient();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).build();
        HoodieEngineContext context = (HoodieEngineContext)Mockito.mock(HoodieEngineContext.class);
        TestBaseHoodieTable hoodieTable = new TestBaseHoodieTable(writeConfig, context, this.metaClient);
        HoodieIndex index = hoodieTable.getIndex();
        Assertions.assertSame((Object)index, (Object)hoodieTable.getIndex());
    }

    @Test
    void getStorageLayoutReturnsCachedInstance() throws IOException {
        this.initMetaClient();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).build();
        HoodieEngineContext context = (HoodieEngineContext)Mockito.mock(HoodieEngineContext.class);
        TestBaseHoodieTable hoodieTable = new TestBaseHoodieTable(writeConfig, context, this.metaClient);
        HoodieStorageLayout storageLayout = hoodieTable.getStorageLayout();
        Assertions.assertSame((Object)storageLayout, (Object)hoodieTable.getStorageLayout());
    }

    @Test
    void testGetEngineContext() throws IOException {
        this.initMetaClient();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).build();
        HoodieEngineContext context = (HoodieEngineContext)Mockito.mock(HoodieEngineContext.class);
        TestBaseHoodieTable hoodieTable = new TestBaseHoodieTable(writeConfig, context, this.metaClient);
        Assertions.assertSame((Object)context, (Object)hoodieTable.getContext());
        HoodieTable deserializedTable = (HoodieTable)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Object)((Object)hoodieTable)));
        Assertions.assertTrue((boolean)(deserializedTable.getContext() instanceof HoodieLocalEngineContext));
    }

    @Test
    void testRollbackInflightInstant() throws IOException {
        this.initMetaClient();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).build();
        HoodieEngineContext context = (HoodieEngineContext)Mockito.mock(HoodieEngineContext.class);
        TestBaseHoodieTable hoodieTable = new TestBaseHoodieTable(writeConfig, context, this.metaClient);
        HoodieInstant inflightInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", "123", InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        Function getPendingRollbackInstantFunc = (Function)Mockito.mock(Function.class);
        HoodiePendingRollbackInfo pendingRollbackInfo = new HoodiePendingRollbackInfo(inflightInstant, new HoodieRollbackPlan());
        Mockito.when(getPendingRollbackInstantFunc.apply("123")).thenReturn((Object)Option.of((Object)pendingRollbackInfo));
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        timeline.createNewInstant(inflightInstant);
        hoodieTable.rollbackInflightInstant(inflightInstant, getPendingRollbackInstantFunc);
        Assertions.assertEquals((int)0, (int)hoodieTable.getCountOfScheduleRollbackFunctionCalls());
        Mockito.when(getPendingRollbackInstantFunc.apply("123")).thenReturn((Object)Option.empty());
        timeline.createNewInstant(inflightInstant);
        hoodieTable.rollbackInflightInstant(inflightInstant, getPendingRollbackInstantFunc);
        Assertions.assertEquals((int)1, (int)hoodieTable.getCountOfScheduleRollbackFunctionCalls());
    }
}

