/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieTestCommitGenerator;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieClusteringStrategy;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieSliceInfo;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.FileCreateUtilsLegacy;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseTableServicePlanActionExecutor;
import org.apache.hudi.table.action.IncrementalPartitionAwareStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

public class TestBaseTableServicePlanActionExecutor {
    @TempDir
    File tempFile;
    private static final StorageConfiguration<?> CONF = HoodieTestUtils.getDefaultStorageConf();
    private final HoodieEngineContext context = new HoodieLocalEngineContext(CONF);

    @Test
    public void testExecutorWithMultiWriter() throws Exception {
        String tableName = "testTable";
        String tablePath = this.tempFile.getAbsolutePath() + "/" + tableName;
        HoodieTableMetaClient metaClient = HoodieTestUtils.init((StorageConfiguration)HoodieTestUtils.getDefaultStorageConf(), (String)tablePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (String)tableName);
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(tablePath).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).withMarkersType("DIRECT").build();
        HashMap<String, String> instants = new HashMap<String, String>();
        instants.put("0000", "0001");
        instants.put("0002", "0004");
        instants.put("0003", "0006");
        instants.put("0005", "0007");
        this.prepareTimeline(metaClient, instants, Collections.singletonList("0008"));
        DummyTableServicePlanActionExecutor executor = new DummyTableServicePlanActionExecutor(this.context, writeConfig, this.getMockHoodieTable(metaClient), "0009");
        Set incrementalPartitions = (Set)executor.getIncrementalPartitions(TableServiceType.CLUSTER).getRight();
        Assertions.assertEquals((int)2, (int)incrementalPartitions.size());
        Assertions.assertTrue((boolean)incrementalPartitions.contains("0003"));
        Assertions.assertTrue((boolean)incrementalPartitions.contains("0005"));
        Assertions.assertFalse((boolean)incrementalPartitions.contains("0008"));
    }

    @Test
    public void testGetPartitionsFallbackToFullScan() throws Exception {
        String tableName = "testTable";
        String tablePath = this.tempFile.getAbsolutePath() + "/" + tableName;
        HoodieTableMetaClient metaClient = HoodieTestUtils.init((StorageConfiguration)HoodieTestUtils.getDefaultStorageConf(), (String)tablePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (String)tableName);
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(tablePath).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).withMarkersType("DIRECT").build();
        HashMap<String, String> instants = new HashMap<String, String>();
        instants.put("0000", "0001");
        instants.put("0002", "0004");
        instants.put("0003", "0006");
        instants.put("0005", "0007");
        instants.put("0008", "0010");
        this.prepareTimeline(metaClient, instants, Collections.emptyList());
        instants.keySet().forEach(instant -> {
            try {
                FileCreateUtilsLegacy.createPartitionMetaFile((String)tablePath, (String)instant);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        DummyStrategy incrementalStrategy = new DummyStrategy();
        DummyTableServicePlanActionExecutor executor = new DummyTableServicePlanActionExecutor(this.context, writeConfig, this.getMockHoodieTable(metaClient), "0009");
        List partitions = executor.getPartitions(incrementalStrategy, TableServiceType.CLUSTER);
        Assertions.assertEquals((int)2, (int)partitions.size());
        Path path = new Path(tablePath);
        FileSystem fs = path.getFileSystem(new Configuration());
        StoragePath timelinePath = metaClient.getTimelinePath();
        Arrays.stream(fs.listStatus(new Path(timelinePath.toString()))).forEach(instant -> {
            if (instant.getPath().toString().contains("0000") || instant.getPath().toString().contains("0002")) {
                try {
                    fs.delete(instant.getPath(), true);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        List allPartitions = executor.getPartitions(incrementalStrategy, TableServiceType.CLUSTER);
        Assertions.assertEquals(allPartitions.stream().sorted().collect(Collectors.toList()), instants.keySet().stream().sorted().collect(Collectors.toList()));
    }

    @Test
    public void testContinuousEmptyCommits() throws Exception {
        String tableName = "testTable";
        String tablePath = this.tempFile.getAbsolutePath() + "/" + tableName;
        HoodieTableMetaClient metaClient = HoodieTestUtils.init((StorageConfiguration)HoodieTestUtils.getDefaultStorageConf(), (String)tablePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (String)tableName);
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(tablePath).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).withMarkersType("DIRECT").build();
        HoodieTestTable testTable = HoodieTestTable.of((HoodieTableMetaClient)metaClient);
        String clusteringRequestTime = "0001";
        String clusteringCompletionTIme = "0002";
        Pair<HoodieRequestedReplaceMetadata, HoodieReplaceCommitMetadata> replaceMetadata = this.generateReplaceCommitMetadata(clusteringRequestTime, clusteringRequestTime, UUID.randomUUID().toString(), UUID.randomUUID().toString());
        testTable.addCluster(clusteringRequestTime, (HoodieRequestedReplaceMetadata)replaceMetadata.getKey(), Option.empty(), (HoodieReplaceCommitMetadata)replaceMetadata.getValue(), clusteringCompletionTIme);
        HoodieInstant clusteringInstant = (HoodieInstant)metaClient.getActiveTimeline().filterCompletedInstants().getLastClusteringInstant().get();
        FileCreateUtilsLegacy.createPartitionMetaFile((String)tablePath, (String)clusteringInstant.requestedTime());
        String emptyCommitRequestTime = "0003";
        String emptyCommitCompletionTIme = "0004";
        HoodieCommitMetadata metadata = testTable.createCommitMetadata(emptyCommitRequestTime, WriteOperationType.INSERT, Collections.emptyList(), 0, false);
        testTable.addCommit(emptyCommitRequestTime, Option.of((Object)emptyCommitCompletionTIme), Option.of((Object)metadata));
        String emptyCommitRequestTime2 = "0005";
        String emptyCommitCompletionTIme2 = "0006";
        HoodieCommitMetadata metadata2 = testTable.createCommitMetadata(emptyCommitRequestTime2, WriteOperationType.INSERT, Collections.emptyList(), 0, false);
        testTable.addCommit(emptyCommitRequestTime2, Option.of((Object)emptyCommitCompletionTIme2), Option.of((Object)metadata2));
        DummyStrategy incrementalStrategy = new DummyStrategy();
        DummyTableServicePlanActionExecutor executor = new DummyTableServicePlanActionExecutor(this.context, writeConfig, this.getMockHoodieTable(metaClient), "0009");
        List partitions = executor.getPartitions(incrementalStrategy, TableServiceType.CLUSTER);
        Assertions.assertTrue((boolean)partitions.isEmpty());
    }

    private void prepareTimeline(HoodieTableMetaClient metaClient, HashMap<String, String> commitInstants, List<String> requestInstants) throws Exception {
        HoodieTestTable testTable = HoodieTestTable.of((HoodieTableMetaClient)metaClient);
        commitInstants.forEach((requestTime, completionTime) -> {
            try {
                if (requestTime.equalsIgnoreCase("0002")) {
                    Pair<HoodieRequestedReplaceMetadata, HoodieReplaceCommitMetadata> replaceMetadata = this.generateReplaceCommitMetadata((String)requestTime, (String)requestTime, UUID.randomUUID().toString(), UUID.randomUUID().toString());
                    testTable.addCluster(requestTime, (HoodieRequestedReplaceMetadata)replaceMetadata.getKey(), Option.empty(), (HoodieReplaceCommitMetadata)replaceMetadata.getValue(), completionTime);
                } else if (!requestTime.equalsIgnoreCase("0004")) {
                    HoodieCommitMetadata metadata = testTable.createCommitMetadata(requestTime, WriteOperationType.INSERT, Collections.singletonList(requestTime), 10, false);
                    testTable.addCommit(requestTime, Option.of((Object)completionTime), Option.of((Object)metadata));
                }
            }
            catch (Exception e) {
                throw new HoodieException((Throwable)e);
            }
        });
        requestInstants.forEach(instant -> {
            try {
                testTable.addRequestedCommit(instant);
                FileCreateUtilsLegacy.createPartitionMetaFile((String)metaClient.getBasePath().toString(), (String)instant);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private HoodieTable getMockHoodieTable(HoodieTableMetaClient metaClient) {
        HoodieTable hoodieTable = (HoodieTable)Mockito.mock(HoodieTable.class);
        TaskContextSupplier taskContextSupplier = (TaskContextSupplier)Mockito.mock(TaskContextSupplier.class);
        Mockito.when((Object)taskContextSupplier.getPartitionIdSupplier()).thenReturn(() -> 1);
        Mockito.when((Object)hoodieTable.getTaskContextSupplier()).thenReturn((Object)taskContextSupplier);
        Mockito.when((Object)hoodieTable.getMetaClient()).thenReturn((Object)metaClient);
        Mockito.when((Object)hoodieTable.getActiveTimeline()).thenReturn((Object)metaClient.getActiveTimeline());
        return hoodieTable;
    }

    private Pair<HoodieRequestedReplaceMetadata, HoodieReplaceCommitMetadata> generateReplaceCommitMetadata(String instantTime, String partition, String replacedFileId, String newFileId) {
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = new HoodieRequestedReplaceMetadata();
        requestedReplaceMetadata.setOperationType(WriteOperationType.CLUSTER.toString());
        requestedReplaceMetadata.setVersion(Integer.valueOf(1));
        HoodieSliceInfo sliceInfo = HoodieSliceInfo.newBuilder().setFileId(replacedFileId).build();
        ArrayList<HoodieClusteringGroup> clusteringGroups = new ArrayList<HoodieClusteringGroup>();
        clusteringGroups.add(HoodieClusteringGroup.newBuilder().setVersion(Integer.valueOf(1)).setNumOutputFileGroups(Integer.valueOf(1)).setMetrics(Collections.emptyMap()).setSlices(Collections.singletonList(sliceInfo)).build());
        requestedReplaceMetadata.setExtraMetadata(Collections.emptyMap());
        requestedReplaceMetadata.setClusteringPlan(HoodieClusteringPlan.newBuilder().setVersion(Integer.valueOf(1)).setExtraMetadata(Collections.emptyMap()).setStrategy(HoodieClusteringStrategy.newBuilder().setStrategyClassName("").setVersion(Integer.valueOf(1)).build()).setInputGroups(clusteringGroups).build());
        HoodieReplaceCommitMetadata replaceMetadata = new HoodieReplaceCommitMetadata();
        replaceMetadata.addReplaceFileId(partition, replacedFileId);
        replaceMetadata.setOperationType(WriteOperationType.CLUSTER);
        if (!StringUtils.isNullOrEmpty((String)newFileId)) {
            HoodieWriteStat writeStat = new HoodieWriteStat();
            writeStat.setPartitionPath(partition);
            writeStat.setPath(partition + "/" + HoodieTestCommitGenerator.getBaseFilename(instantTime, newFileId));
            writeStat.setFileId(newFileId);
            writeStat.setTotalWriteBytes(1L);
            writeStat.setFileSizeInBytes(1L);
            replaceMetadata.addWriteStat(partition, writeStat);
        }
        return Pair.of((Object)requestedReplaceMetadata, (Object)replaceMetadata);
    }

    class DummyStrategy
    implements IncrementalPartitionAwareStrategy {
        DummyStrategy() {
        }

        public Pair<List<String>, List<String>> filterPartitionPaths(HoodieWriteConfig writeConfig, List<String> partitions) {
            return null;
        }
    }

    class DummyTableServicePlanActionExecutor<T, I, K, O, R>
    extends BaseTableServicePlanActionExecutor<T, I, K, O, R> {
        public DummyTableServicePlanActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime) {
            super(context, config, table, instantTime);
        }

        public R execute() {
            return null;
        }
    }
}

