/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.datadog;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.metrics.datadog.DatadogHttpClient;
import org.apache.hudi.metrics.datadog.DatadogReporter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestDatadogReporter {
    @Mock
    Appender appender;
    @Captor
    ArgumentCaptor<LogEvent> logCaptor;
    @Mock
    MetricRegistry registry;
    @Mock
    DatadogHttpClient client;

    @AfterEach
    void resetMocks() {
        ((Logger)LogManager.getLogger(DatadogReporter.class)).removeAppender(this.appender);
        Mockito.reset((Object[])new Object[]{this.appender, this.registry, this.client});
    }

    @Test
    public void stopShouldCloseEnclosedClient() throws IOException {
        new DatadogReporter(this.registry, this.client, "foo", Option.empty(), Option.empty(), MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.SECONDS).stop();
        ((DatadogHttpClient)Mockito.verify((Object)this.client)).close();
    }

    @Test
    public void stopShouldLogWhenEnclosedClientFailToClose() throws IOException {
        Mockito.when((Object)this.appender.getName()).thenReturn((Object)("MockAppender-" + UUID.randomUUID()));
        Mockito.when((Object)this.appender.isStarted()).thenReturn((Object)true);
        Mockito.when((Object)this.appender.isStopped()).thenReturn((Object)false);
        ((Logger)LogManager.getLogger(DatadogReporter.class)).addAppender(this.appender);
        ((DatadogHttpClient)Mockito.doThrow(IOException.class).when((Object)this.client)).close();
        new DatadogReporter(this.registry, this.client, "foo", Option.empty(), Option.empty(), MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.SECONDS).stop();
        ((Appender)Mockito.verify((Object)this.appender)).append((LogEvent)this.logCaptor.capture());
        Assertions.assertEquals((Object)"Error disconnecting from Datadog.", (Object)((LogEvent)this.logCaptor.getValue()).getMessage().getFormattedMessage());
        Assertions.assertEquals((Object)Level.WARN, (Object)((LogEvent)this.logCaptor.getValue()).getLevel());
    }

    @Test
    public void prefixShouldPrepend() {
        DatadogReporter reporter = new DatadogReporter(this.registry, this.client, "foo", Option.empty(), Option.empty(), MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)"foo.bar", (Object)reporter.prefix(new String[]{"bar"}));
    }

    @Test
    public void payloadBuilderShouldBuildExpectedPayloadString() {
        String payload = new DatadogReporter.PayloadBuilder().withMetricType(DatadogReporter.MetricType.gauge).addGauge("foo", 0L, 0L).addGauge("bar", 1L, 999L).withHost("xhost").withTags(Arrays.asList("tag1", "tag2")).build();
        Assertions.assertEquals((Object)"{\"series\":[{\"metric\":\"foo\",\"points\":[[0,0]],\"host\":\"xhost\",\"tags\":[\"tag1\",\"tag2\"]},{\"metric\":\"bar\",\"points\":[[1,999]],\"host\":\"xhost\",\"tags\":[\"tag1\",\"tag2\"]}]}", (Object)payload);
    }
}

