/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.datadog;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.hudi.metrics.datadog.DatadogHttpClient;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestDatadogHttpClient {
    @Mock
    Appender appender;
    @Captor
    ArgumentCaptor<LogEvent> logCaptor;
    @Mock
    CloseableHttpClient httpClient;
    @Mock
    CloseableHttpResponse httpResponse;
    @Mock
    StatusLine statusLine;
    private Level initialLogLevel;

    @BeforeEach
    void prepareAppender() {
        Mockito.when((Object)this.appender.getName()).thenReturn((Object)("MockAppender-" + UUID.randomUUID()));
        Mockito.when((Object)this.appender.isStarted()).thenReturn((Object)true);
        Mockito.when((Object)this.appender.isStopped()).thenReturn((Object)false);
        Logger logger = (Logger)LogManager.getLogger(DatadogHttpClient.class);
        this.initialLogLevel = logger.getLevel();
        logger.setLevel(Level.DEBUG);
        logger.addAppender(this.appender);
    }

    @AfterEach
    void resetMocks() {
        Logger logger = (Logger)LogManager.getLogger(DatadogHttpClient.class);
        logger.setLevel(this.initialLogLevel);
        logger.removeAppender(this.appender);
        Mockito.reset((Object[])new Object[]{this.appender, this.httpClient, this.httpResponse, this.statusLine});
    }

    private void mockResponse(int statusCode) {
        Mockito.when((Object)this.statusLine.getStatusCode()).thenReturn((Object)statusCode);
        Mockito.when((Object)this.httpResponse.getStatusLine()).thenReturn((Object)this.statusLine);
        try {
            Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)this.httpResponse);
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test
    public void validateApiKeyShouldThrowExceptionWhenRequestFailed() throws IOException {
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenThrow(IOException.class);
        Throwable t = Assertions.assertThrows(IllegalStateException.class, () -> new DatadogHttpClient(DatadogHttpClient.ApiSite.EU, "foo", false, this.httpClient));
        Assertions.assertEquals((Object)"Failed to connect to Datadog to validate API key.", (Object)t.getMessage());
    }

    @Test
    public void validateApiKeyShouldThrowExceptionWhenResponseNotSuccessful() {
        this.mockResponse(500);
        Throwable t = Assertions.assertThrows(IllegalStateException.class, () -> new DatadogHttpClient(DatadogHttpClient.ApiSite.EU, "foo", false, this.httpClient));
        Assertions.assertEquals((Object)"API key is invalid.", (Object)t.getMessage());
    }

    @Test
    public void sendPayloadShouldLogWhenRequestFailed() throws IOException {
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenThrow(IOException.class);
        DatadogHttpClient ddClient = new DatadogHttpClient(DatadogHttpClient.ApiSite.US, "foo", true, this.httpClient);
        ddClient.send("{}");
        ((Appender)Mockito.verify((Object)this.appender)).append((LogEvent)this.logCaptor.capture());
        Assertions.assertEquals((Object)"Failed to send to Datadog.", (Object)((LogEvent)this.logCaptor.getValue()).getMessage().getFormattedMessage());
        Assertions.assertEquals((Object)Level.WARN, (Object)((LogEvent)this.logCaptor.getValue()).getLevel());
    }

    @Test
    public void sendPayloadShouldLogUnsuccessfulSending() {
        this.mockResponse(401);
        Mockito.when((Object)this.httpResponse.toString()).thenReturn((Object)"unauthorized");
        DatadogHttpClient ddClient = new DatadogHttpClient(DatadogHttpClient.ApiSite.US, "foo", true, this.httpClient);
        ddClient.send("{}");
        ((Appender)Mockito.verify((Object)this.appender)).append((LogEvent)this.logCaptor.capture());
        Assertions.assertEquals((Object)"Failed to send to Datadog. Response was unauthorized", (Object)((LogEvent)this.logCaptor.getValue()).getMessage().getFormattedMessage());
        Assertions.assertEquals((Object)Level.WARN, (Object)((LogEvent)this.logCaptor.getValue()).getLevel());
    }

    @Test
    public void sendPayloadShouldLogSuccessfulSending() {
        this.mockResponse(202);
        DatadogHttpClient ddClient = new DatadogHttpClient(DatadogHttpClient.ApiSite.US, "foo", true, this.httpClient);
        ddClient.send("{}");
        ((Appender)Mockito.verify((Object)this.appender)).append((LogEvent)this.logCaptor.capture());
        Assertions.assertTrue((boolean)((LogEvent)this.logCaptor.getValue()).getMessage().getFormattedMessage().startsWith("Sent metrics data"));
        Assertions.assertEquals((Object)Level.DEBUG, (Object)((LogEvent)this.logCaptor.getValue()).getLevel());
    }

    public static List<Arguments> getApiSiteAndDomain() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{"US", "com"}), Arguments.of((Object[])new Object[]{"EU", "eu"}));
    }

    @ParameterizedTest
    @MethodSource(value={"getApiSiteAndDomain"})
    public void testApiSiteReturnCorrectDomain(String apiSite, String domain) {
        Assertions.assertEquals((Object)domain, (Object)DatadogHttpClient.ApiSite.valueOf((String)apiSite).getDomain());
    }
}

