/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.simple;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.engine.LocalTaskContextSupplier;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.simple.HoodieGlobalSimpleIndex;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.HoodieWriteableTestTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class TestGlobalSimpleIndex
extends HoodieCommonTestHarness {
    private static final Schema SCHEMA = SchemaTestUtil.getSchemaFromResource(TestGlobalSimpleIndex.class, (String)"/exampleSchema.avsc", (boolean)true);

    TestGlobalSimpleIndex() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.initPath();
        this.initMetaClient();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void testTagLocation(boolean manuallySetPartitions) throws Exception {
        String partition1 = "2016/01/31";
        String partition2 = "2016/01/26";
        String rowKey1 = UUID.randomUUID().toString();
        String rowKey2 = UUID.randomUUID().toString();
        String rowKey3 = UUID.randomUUID().toString();
        String rowKey4 = UUID.randomUUID().toString();
        String recordStr1 = "{\"_row_key\":\"" + rowKey1 + "\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}";
        String recordStr2 = "{\"_row_key\":\"" + rowKey2 + "\",\"time\":\"2016-01-31T03:20:41.415Z\",\"number\":100}";
        String recordStr3 = "{\"_row_key\":\"" + rowKey3 + "\",\"time\":\"2016-01-26T03:16:41.415Z\",\"number\":15}";
        String recordStr4 = "{\"_row_key\":\"" + rowKey4 + "\",\"time\":\"2015-01-31T03:16:41.415Z\",\"number\":32}";
        RawTripTestPayload payload1 = new RawTripTestPayload(recordStr1);
        HoodieAvroRecord record1 = new HoodieAvroRecord(new HoodieKey(payload1.getRowKey(), payload1.getPartitionPath()), (HoodieRecordPayload)payload1);
        RawTripTestPayload payload2 = new RawTripTestPayload(recordStr2);
        HoodieAvroRecord record2 = new HoodieAvroRecord(new HoodieKey(payload2.getRowKey(), payload2.getPartitionPath()), (HoodieRecordPayload)payload2);
        RawTripTestPayload payload3 = new RawTripTestPayload(recordStr3);
        HoodieAvroRecord record3 = new HoodieAvroRecord(new HoodieKey(payload3.getRowKey(), payload3.getPartitionPath()), (HoodieRecordPayload)payload3);
        HoodieAvroRecord record3WithNewPartition = new HoodieAvroRecord(new HoodieKey(payload3.getRowKey(), partition1), (HoodieRecordPayload)payload3);
        RawTripTestPayload payload4 = new RawTripTestPayload(recordStr4);
        HoodieAvroRecord record4 = new HoodieAvroRecord(new HoodieKey(payload4.getRowKey(), payload4.getPartitionPath()), (HoodieRecordPayload)payload4);
        HoodieListData records = HoodieListData.eager(Arrays.asList(record1, record2, record3WithNewPartition, record4));
        HoodieWriteConfig config = this.makeConfig(manuallySetPartitions);
        Configuration conf = new Configuration(false);
        HoodieLocalEngineContext context = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)table.getConfig()).thenReturn((Object)config);
        Mockito.when((Object)table.getMetaClient()).thenReturn((Object)this.metaClient);
        Mockito.when((Object)table.getStorage()).thenReturn((Object)this.metaClient.getStorage());
        HoodieGlobalSimpleIndex globalSimpleIndex = new HoodieGlobalSimpleIndex(config, Option.empty());
        HoodieData taggedRecordRDD = globalSimpleIndex.tagLocation((HoodieData)records, (HoodieEngineContext)context, table);
        Assertions.assertFalse((boolean)taggedRecordRDD.collectAsList().stream().anyMatch(HoodieRecord::isCurrentLocationKnown));
        HoodieHadoopStorage hoodieStorage = new HoodieHadoopStorage(this.basePath, conf);
        HoodieWriteableTestTable testTable = new HoodieWriteableTestTable(this.basePath, (HoodieStorage)hoodieStorage, this.metaClient, SCHEMA, null, null, (Option<HoodieEngineContext>)Option.of((Object)context));
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String fileId3 = UUID.randomUUID().toString();
        LocalTaskContextSupplier localTaskContextSupplier = new LocalTaskContextSupplier();
        StoragePath filePath1 = testTable.addCommit("001").withInserts(partition1, fileId1, Collections.singletonList(record1), (TaskContextSupplier)localTaskContextSupplier);
        StoragePath filePath2 = testTable.addCommit("002").withInserts(partition1, fileId2, Collections.singletonList(record2), (TaskContextSupplier)localTaskContextSupplier);
        StoragePath filePath3 = testTable.addCommit("003").withInserts(partition2, fileId3, Collections.singletonList(record3), (TaskContextSupplier)localTaskContextSupplier);
        String timestamp = ((HoodieInstant)this.metaClient.reloadActiveTimeline().lastInstant().get()).requestedTime();
        Mockito.when((Object)table.getBaseFileOnlyView().getLatestBaseFilesBeforeOrOn(partition1, timestamp)).thenReturn(Stream.of(new HoodieBaseFile(hoodieStorage.getPathInfo(filePath1)), new HoodieBaseFile(hoodieStorage.getPathInfo(filePath2))));
        Mockito.when((Object)table.getBaseFileOnlyView().getLatestBaseFilesBeforeOrOn(partition2, timestamp)).thenReturn(Stream.of(new HoodieBaseFile(hoodieStorage.getPathInfo(filePath3))));
        taggedRecordRDD = globalSimpleIndex.tagLocation((HoodieData)records, (HoodieEngineContext)context, table);
        HashMap<String, Option> expectedRecordKeyToFileId = new HashMap<String, Option>();
        expectedRecordKeyToFileId.put(rowKey1, Option.of((Object)fileId1));
        expectedRecordKeyToFileId.put(rowKey2, Option.of((Object)fileId2));
        expectedRecordKeyToFileId.put(rowKey3, Option.of((Object)fileId3));
        expectedRecordKeyToFileId.put(rowKey4, Option.empty());
        Map<String, Option> actualRecordKeyToFileId = taggedRecordRDD.collectAsList().stream().collect(Collectors.toMap(HoodieRecord::getRecordKey, record -> record.isCurrentLocationKnown() ? Option.of((Object)record.getCurrentLocation().getFileId()) : Option.empty()));
        Assertions.assertEquals(expectedRecordKeyToFileId, actualRecordKeyToFileId);
    }

    private HoodieWriteConfig makeConfig(boolean manuallySetPartitions) {
        Properties props = new Properties();
        props.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "_row_key");
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withIndexConfig(HoodieIndexConfig.newBuilder().fromProperties(props).withIndexType(HoodieIndex.IndexType.GLOBAL_SIMPLE).withGlobalSimpleIndexParallelism(manuallySetPartitions ? 1 : 0).build()).build();
    }
}

