/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.model.HoodieConsistentHashingMetadata;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.index.bucket.ConsistentBucketIdentifier;
import org.apache.hudi.index.bucket.ConsistentBucketIndexUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestConsistentBucketIdIdentifier {
    private static Stream<Arguments> splitBucketParams() {
        Object[][] data = new Object[][]{{Integer.MAX_VALUE, 15, 0x40000007}, {1, Integer.MAX_VALUE, 0}, {0, Integer.MAX_VALUE, -1}, {1, 0x7FFFFFF5, 0x7FFFFFFB}, {9, 0x7FFFFFFD, 3}, {0, 0x7FFFFFFE, Integer.MAX_VALUE}};
        return Stream.of(data).map(Arguments::of);
    }

    @Test
    public void testGetBucket() {
        List<ConsistentHashingNode> nodes = Arrays.asList(new ConsistentHashingNode(100, "0"), new ConsistentHashingNode(0x2FFFFFFF, "1"), new ConsistentHashingNode(0x4FFFFFFF, "2"));
        HoodieConsistentHashingMetadata meta = new HoodieConsistentHashingMetadata(0, "", "", 3, 0, nodes);
        ConsistentBucketIdentifier identifier = new ConsistentBucketIdentifier(meta);
        Assertions.assertEquals((int)3, (int)identifier.getNumBuckets());
        Assertions.assertEquals((Object)nodes.get(2), (Object)identifier.getBucket(Arrays.asList("Hudi")));
        Assertions.assertEquals((Object)nodes.get(1), (Object)identifier.getBucket(Arrays.asList("bucket_index")));
        Assertions.assertEquals((Object)nodes.get(1), (Object)identifier.getBucket(Arrays.asList("consistent_hashing")));
        Assertions.assertEquals((Object)nodes.get(1), (Object)identifier.getBucket(Arrays.asList("bucket_index", "consistent_hashing")));
        int[] ref1 = new int[]{2, 2, 1, 1, 0, 1, 1, 1, 0, 1};
        int[] ref2 = new int[]{1, 0, 1, 0, 1, 1, 1, 0, 1, 2};
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((Object)nodes.get(ref1[i]), (Object)identifier.getBucket(Arrays.asList(Integer.toString(i))));
            Assertions.assertEquals((Object)nodes.get(ref2[i]), (Object)identifier.getBucket(Arrays.asList(Integer.toString(i), Integer.toString(i + 1))));
        }
        Assertions.assertEquals((Object)nodes.get(0), (Object)identifier.getBucket(0));
        Assertions.assertEquals((Object)nodes.get(0), (Object)identifier.getBucket(50));
        Assertions.assertEquals((Object)nodes.get(0), (Object)identifier.getBucket(100));
        Assertions.assertEquals((Object)nodes.get(1), (Object)identifier.getBucket(101));
        Assertions.assertEquals((Object)nodes.get(1), (Object)identifier.getBucket(0x1FFFFFFF));
        Assertions.assertEquals((Object)nodes.get(1), (Object)identifier.getBucket(0x2FFFFFFF));
        Assertions.assertEquals((Object)nodes.get(2), (Object)identifier.getBucket(0x40000000));
        Assertions.assertEquals((Object)nodes.get(2), (Object)identifier.getBucket(0x40000001));
        Assertions.assertEquals((Object)nodes.get(2), (Object)identifier.getBucket(0x4FFFFFFF));
        Assertions.assertEquals((Object)nodes.get(0), (Object)identifier.getBucket(0x50000000));
        Assertions.assertEquals((Object)nodes.get(0), (Object)identifier.getBucket(Integer.MAX_VALUE));
        Assertions.assertEquals((Object)nodes.get(0), (Object)identifier.getBucketByFileId(FSUtils.createNewFileId((String)"0", (int)0)));
        Assertions.assertEquals((Object)nodes.get(1), (Object)identifier.getBucketByFileId(FSUtils.createNewFileId((String)"1", (int)0)));
        Assertions.assertEquals((Object)nodes.get(2), (Object)identifier.getBucketByFileId(FSUtils.createNewFileId((String)"2", (int)0)));
    }

    @ParameterizedTest
    @MethodSource(value={"splitBucketParams"})
    public void testSplitBucket(int v0, int v1, int mid) {
        List<ConsistentHashingNode> nodes = Arrays.asList(new ConsistentHashingNode(v0, "0"), new ConsistentHashingNode(v1, "1"));
        HoodieConsistentHashingMetadata meta = new HoodieConsistentHashingMetadata(0, "", "", 4, 0, nodes);
        Option res = new ConsistentBucketIdentifier(meta).splitBucket(nodes.get(0));
        if (mid < 0) {
            Assertions.assertTrue((!res.isPresent() ? 1 : 0) != 0);
            return;
        }
        List childNodes = (List)res.get();
        Assertions.assertEquals((int)2, (int)childNodes.size());
        Assertions.assertTrue((boolean)childNodes.stream().allMatch(c -> c.getTag() == ConsistentHashingNode.NodeTag.REPLACE));
        Assertions.assertEquals((int)mid, (int)((ConsistentHashingNode)childNodes.get(0)).getValue());
        Assertions.assertEquals((int)nodes.get(0).getValue(), (int)((ConsistentHashingNode)childNodes.get(1)).getValue());
    }

    @Test
    public void testMerge() {
        HoodieConsistentHashingMetadata meta = new HoodieConsistentHashingMetadata("partition", 8);
        List nodes = meta.getNodes();
        List fileIds = IntStream.range(0, 3).mapToObj(i -> FSUtils.createNewFileId((String)((ConsistentHashingNode)nodes.get(i)).getFileIdPrefix(), (int)0)).collect(Collectors.toList());
        List childNodes = new ConsistentBucketIdentifier(meta).mergeBucket(fileIds);
        Assertions.assertEquals((Object)ConsistentHashingNode.NodeTag.DELETE, (Object)((ConsistentHashingNode)childNodes.get(0)).getTag());
        Assertions.assertEquals((Object)ConsistentHashingNode.NodeTag.DELETE, (Object)((ConsistentHashingNode)childNodes.get(1)).getTag());
        Assertions.assertEquals((Object)ConsistentHashingNode.NodeTag.REPLACE, (Object)((ConsistentHashingNode)childNodes.get(2)).getTag());
        Assertions.assertEquals((int)((ConsistentHashingNode)nodes.get(2)).getValue(), (int)((ConsistentHashingNode)childNodes.get(2)).getValue());
        Assertions.assertNotEquals((Object)((ConsistentHashingNode)nodes.get(2)).getFileIdPrefix(), (Object)((ConsistentHashingNode)childNodes.get(2)).getFileIdPrefix());
        fileIds = Arrays.asList((ConsistentHashingNode)nodes.get(7), (ConsistentHashingNode)nodes.get(0), (ConsistentHashingNode)nodes.get(1)).stream().map(ConsistentHashingNode::getFileIdPrefix).map(f -> FSUtils.createNewFileId((String)f, (int)0)).collect(Collectors.toList());
        childNodes = new ConsistentBucketIdentifier(meta).mergeBucket(fileIds);
        Assertions.assertEquals((Object)ConsistentHashingNode.NodeTag.DELETE, (Object)((ConsistentHashingNode)childNodes.get(0)).getTag());
        Assertions.assertEquals((Object)ConsistentHashingNode.NodeTag.DELETE, (Object)((ConsistentHashingNode)childNodes.get(1)).getTag());
        Assertions.assertEquals((Object)ConsistentHashingNode.NodeTag.REPLACE, (Object)((ConsistentHashingNode)childNodes.get(2)).getTag());
        Assertions.assertEquals((int)((ConsistentHashingNode)nodes.get(1)).getValue(), (int)((ConsistentHashingNode)childNodes.get(2)).getValue());
        Assertions.assertNotEquals((Object)((ConsistentHashingNode)nodes.get(1)).getFileIdPrefix(), (Object)((ConsistentHashingNode)childNodes.get(2)).getFileIdPrefix());
    }

    @Test
    public void testNonContinuousBucketMerge() {
        HoodieConsistentHashingMetadata meta = new HoodieConsistentHashingMetadata("partition", 8);
        List nodes = meta.getNodes();
        boolean exception = false;
        try {
            List fileIds = IntStream.range(0, 2).mapToObj(i -> FSUtils.createNewFileId((String)((ConsistentHashingNode)nodes.get(i * 2)).getFileIdPrefix(), (int)0)).collect(Collectors.toList());
            new ConsistentBucketIdentifier(meta).mergeBucket(fileIds);
        }
        catch (Exception e) {
            exception = true;
        }
        Assertions.assertTrue((boolean)exception);
    }

    @Test
    public void testChildrenNodesInitialization() {
        HoodieConsistentHashingMetadata metadata = new HoodieConsistentHashingMetadata("partition", 8);
        ArrayList<ConsistentHashingNode> childrenNodes = new ArrayList<ConsistentHashingNode>();
        childrenNodes.add(new ConsistentHashingNode(((ConsistentHashingNode)metadata.getNodes().get(0)).getValue(), "d1", ConsistentHashingNode.NodeTag.DELETE));
        childrenNodes.add(new ConsistentHashingNode(1024, "a1", ConsistentHashingNode.NodeTag.REPLACE));
        childrenNodes.add(new ConsistentHashingNode(((ConsistentHashingNode)metadata.getNodes().get(1)).getValue(), "a2", ConsistentHashingNode.NodeTag.REPLACE));
        metadata.setChildrenNodes(childrenNodes);
        ConsistentBucketIdentifier identifier = new ConsistentBucketIdentifier(metadata);
        ArrayList nodes = new ArrayList(identifier.getNodes());
        Assertions.assertEquals((int)1024, (int)((ConsistentHashingNode)nodes.get(0)).getValue());
        Assertions.assertEquals((Object)"a1", (Object)((ConsistentHashingNode)nodes.get(0)).getFileIdPrefix());
        Assertions.assertEquals((int)((ConsistentHashingNode)metadata.getNodes().get(1)).getValue(), (int)((ConsistentHashingNode)nodes.get(1)).getValue());
        Assertions.assertEquals((Object)"a2", (Object)((ConsistentHashingNode)nodes.get(1)).getFileIdPrefix());
    }

    @Test
    public void testInvalidChildrenNodesInitialization() {
        HoodieConsistentHashingMetadata metadata = new HoodieConsistentHashingMetadata("partition", 8);
        ArrayList<ConsistentHashingNode> childrenNodes = new ArrayList<ConsistentHashingNode>();
        ConsistentBucketIdentifier identifier = new ConsistentBucketIdentifier(metadata);
        childrenNodes = new ArrayList();
        childrenNodes.add(new ConsistentHashingNode(((ConsistentHashingNode)metadata.getNodes().get(0)).getValue(), "d1", ConsistentHashingNode.NodeTag.NORMAL));
        metadata.setChildrenNodes(childrenNodes);
        boolean isException = false;
        try {
            identifier = new ConsistentBucketIdentifier(metadata);
        }
        catch (Exception e) {
            isException = true;
        }
        Assertions.assertEquals((Object)true, (Object)isException);
    }

    @Test
    public void testGeneratePartitionToFileIdPfxIdxMap() {
        HashMap<String, ConsistentBucketIdentifier> partitionToIdentifier = new HashMap<String, ConsistentBucketIdentifier>();
        for (int i = 0; i < 8; ++i) {
            String partitionPath = "partition" + i;
            HoodieConsistentHashingMetadata metadata = new HoodieConsistentHashingMetadata(partitionPath, 8);
            ConsistentBucketIdentifier identifier = new ConsistentBucketIdentifier(metadata);
            partitionToIdentifier.put(partitionPath, identifier);
        }
        Map partitionToFileIdPfxIdxMap = ConsistentBucketIndexUtils.generatePartitionToFileIdPfxIdxMap(partitionToIdentifier);
        for (int i = 0; i < 8; ++i) {
            String partitionPath = "partition" + i;
            HoodieConsistentHashingMetadata metadata = new HoodieConsistentHashingMetadata(partitionPath, 8);
            ConsistentBucketIdentifier identifier = (ConsistentBucketIdentifier)partitionToIdentifier.get(partitionPath);
            Map fileIdPfxToIdx2 = (Map)partitionToFileIdPfxIdxMap.get(partitionPath);
            Assertions.assertEquals((int)8, (int)fileIdPfxToIdx2.size());
            int startIdx = 0;
            int endIdx = 64;
            Assertions.assertTrue((boolean)fileIdPfxToIdx2.values().stream().allMatch(id -> id >= startIdx && id < endIdx));
            Assertions.assertTrue((boolean)fileIdPfxToIdx2.keySet().stream().map(fileIdPrefix -> FSUtils.createNewFileId((String)fileIdPrefix, (int)0)).allMatch(fileId -> identifier.getBucketByFileId(fileId) != null));
        }
        Assertions.assertEquals((long)64L, (long)partitionToFileIdPfxIdxMap.values().stream().flatMap(fileIdPfxToIdx -> fileIdPfxToIdx.values().stream()).distinct().count());
    }
}

