/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.estimator;

import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.estimator.AverageRecordSizeEstimator;
import org.apache.hudi.estimator.RecordSizeEstimator;
import org.apache.hudi.estimator.RecordSizeEstimatorFactory;
import org.apache.parquet.Strings;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestRecordSizeEstimatorFactory {
    @ParameterizedTest
    @MethodSource(value={"differentEstimatorImplementations"})
    public void testRecordSizeEstimatorFactoryWithCustomConfig(String className, Class<?> clazz) {
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withPath("/tmp");
        if (!Strings.isNullOrEmpty((String)className)) {
            builder.withRecordSizeEstimator(className);
        }
        RecordSizeEstimator estimator = RecordSizeEstimatorFactory.createRecordSizeEstimator((HoodieWriteConfig)builder.build());
        Assertions.assertTrue((boolean)clazz.isInstance(estimator));
    }

    static Stream<Arguments> differentEstimatorImplementations() {
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        arguments.add(Arguments.of((Object[])new Object[]{TestRecordSizeEstimator.class.getName(), TestRecordSizeEstimator.class}));
        arguments.add(Arguments.of((Object[])new Object[]{null, AverageRecordSizeEstimator.class}));
        arguments.add(Arguments.of((Object[])new Object[]{"org.apache.hudi.estimator.IncorrectRecordEstimator", AverageRecordSizeEstimator.class}));
        return arguments.stream();
    }

    public static class TestRecordSizeEstimator
    extends RecordSizeEstimator {
        public TestRecordSizeEstimator(HoodieWriteConfig config) {
            super(config);
        }

        public long averageBytesPerRecord(HoodieTimeline commitTimeline, CommitMetadataSerDe commitMetadataSerDe) {
            return 0L;
        }
    }
}

