/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.hudi.client.utils.DeletePartitionUtils;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieDeletePartitionException;
import org.apache.hudi.table.HoodieTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class TestDeletePartitionUtils {
    private static final String PARTITION_IN_PENDING_SERVICE_ACTION = "partition_with_pending_table_service_action";
    private static final String HARDCODED_INSTANT_TIME = "0";
    private final HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class);
    private final SyncableFileSystemView fileSystemView = (SyncableFileSystemView)Mockito.mock(SyncableFileSystemView.class);

    public static Stream<Arguments> generateTruthValues() {
        int noOfVariables = 3;
        int noOfRows = 1 << noOfVariables;
        Object[][] truthValues = new Object[noOfRows][noOfVariables];
        for (int i = 0; i < noOfRows; ++i) {
            for (int j = noOfVariables - 1; j >= 0; --j) {
                boolean out = i / (1 << j) % 2 != 0;
                truthValues[i][j] = out;
            }
        }
        return Stream.of(truthValues).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"generateTruthValues"})
    public void testDeletePartitionUtils(boolean hasPendingCompactionOperations, boolean hasPendingLogCompactionOperations, boolean hasFileGroupsInPendingClustering) {
        boolean shouldThrowException;
        System.out.printf("hasPendingCompactionOperations: %s, hasPendingLogCompactionOperations: %s, hasFileGroupsInPendingClustering: %s%n", hasPendingCompactionOperations, hasPendingLogCompactionOperations, hasFileGroupsInPendingClustering);
        Mockito.when((Object)this.table.getSliceView()).thenReturn((Object)this.fileSystemView);
        Mockito.when((Object)this.fileSystemView.getPendingCompactionOperations()).thenReturn(TestDeletePartitionUtils.createPendingCompactionOperations(hasPendingCompactionOperations));
        Mockito.when((Object)this.fileSystemView.getPendingLogCompactionOperations()).thenReturn(TestDeletePartitionUtils.createPendingCompactionOperations(hasPendingLogCompactionOperations));
        Mockito.when((Object)this.fileSystemView.getFileGroupsInPendingClustering()).thenReturn(TestDeletePartitionUtils.createFileGroupsInPendingClustering(hasFileGroupsInPendingClustering));
        boolean bl = shouldThrowException = hasPendingCompactionOperations || hasPendingLogCompactionOperations || hasFileGroupsInPendingClustering;
        if (shouldThrowException) {
            Assertions.assertThrows(HoodieDeletePartitionException.class, () -> DeletePartitionUtils.checkForPendingTableServiceActions((HoodieTable)this.table, Collections.singletonList(PARTITION_IN_PENDING_SERVICE_ACTION)));
        } else {
            Assertions.assertDoesNotThrow(() -> DeletePartitionUtils.checkForPendingTableServiceActions((HoodieTable)this.table, Collections.singletonList(PARTITION_IN_PENDING_SERVICE_ACTION)));
        }
    }

    private static Stream<Pair<String, CompactionOperation>> createPendingCompactionOperations(boolean hasPendingCompactionOperations) {
        return Stream.of(Pair.of((Object)HARDCODED_INSTANT_TIME, (Object)TestDeletePartitionUtils.getCompactionOperation(hasPendingCompactionOperations)));
    }

    private static CompactionOperation getCompactionOperation(boolean hasPendingJobInPartition) {
        return new CompactionOperation("fileId", TestDeletePartitionUtils.getPartitionName(hasPendingJobInPartition), HARDCODED_INSTANT_TIME, Option.empty(), new ArrayList(), Option.empty(), Option.empty(), new HashMap());
    }

    private static Stream<Pair<HoodieFileGroupId, HoodieInstant>> createFileGroupsInPendingClustering(boolean hasFileGroupsInPendingClustering) {
        HoodieFileGroupId hoodieFileGroupId = new HoodieFileGroupId(TestDeletePartitionUtils.getPartitionName(hasFileGroupsInPendingClustering), "fileId");
        HoodieInstant hoodieInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "replacecommit", HARDCODED_INSTANT_TIME);
        return Stream.of(Pair.of((Object)hoodieFileGroupId, (Object)hoodieInstant));
    }

    private static String getPartitionName(boolean hasPendingTableServiceAction) {
        return hasPendingTableServiceAction ? PARTITION_IN_PENDING_SERVICE_ACTION : "unaffected_partition";
    }
}

