/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hudi.client.transaction.lock.StorageBasedLockProvider;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.config.StorageBasedLockConfig;
import org.apache.hudi.exception.HoodieLockException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class StorageBasedLockProviderTestBase {
    protected StorageBasedLockProvider lockProvider;
    protected static TypedProperties providerProperties;

    protected abstract StorageBasedLockProvider createLockProvider();

    @BeforeEach
    void setUp() {
        providerProperties = new TypedProperties();
    }

    @AfterEach
    void tearDown() {
        if (this.lockProvider != null) {
            this.lockProvider.unlock();
            this.lockProvider.close();
        }
    }

    @Test
    void testTryLockSuccess() {
        boolean lockAcquired = this.lockProvider.tryLock(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)lockAcquired, (String)"Lock should be successfully acquired within the time limit.");
    }

    @Test
    void testTryLockReleasesLock() {
        Assertions.assertTrue((boolean)this.lockProvider.tryLock(3L, TimeUnit.SECONDS), (String)"Lock should be successfully acquired.");
        this.lockProvider.unlock();
        Assertions.assertTrue((boolean)this.lockProvider.tryLock(1L, TimeUnit.SECONDS), (String)"Lock should be reacquired after being released.");
    }

    @Test
    void testTryLockEdgeCaseZeroTimeout() {
        boolean lockAcquired = this.lockProvider.tryLock(0L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)lockAcquired, (String)"Lock should not be acquired with a zero timeout.");
    }

    @Test
    void testLockThreadKilledShouldNotCauseOrphanedHeartbeat() throws InterruptedException {
        providerProperties.put((Object)StorageBasedLockConfig.VALIDITY_TIMEOUT_SECONDS.key(), (Object)10);
        providerProperties.put((Object)StorageBasedLockConfig.HEARTBEAT_POLL_SECONDS.key(), (Object)1);
        AtomicReference lp = new AtomicReference();
        Thread lockingThread = new Thread(() -> {
            lp.set(this.createLockProvider());
            ((StorageBasedLockProvider)lp.get()).tryLock();
        });
        lockingThread.start();
        lockingThread.join(2000L);
        Assertions.assertFalse((boolean)lockingThread.isAlive());
        boolean lockAcquired = this.lockProvider.tryLock(15L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)lockAcquired, (String)"Lock should be reacquired after expiration");
        Assertions.assertNotNull((Object)this.lockProvider.getLock(), (String)"Lock should be reacquired and getLock() should return non-null");
        this.lockProvider.unlock();
        this.lockProvider.close();
        ((StorageBasedLockProvider)lp.get()).close();
    }

    @Test
    void testTwoLockProvidersCloseAndUnlock() throws InterruptedException {
        StorageBasedLockProvider provider1 = this.createLockProvider();
        Assertions.assertTrue((boolean)provider1.tryLock(), (String)"Provider1 should acquire the lock immediately");
        StorageBasedLockProvider provider2 = this.createLockProvider();
        CountDownLatch finishLatch = new CountDownLatch(1);
        Thread provider2Thread = new Thread(() -> {
            Assertions.assertThrows(HoodieLockException.class, () -> provider2.tryLock(10L, TimeUnit.SECONDS));
            finishLatch.countDown();
        });
        provider2Thread.start();
        provider2.close();
        provider1.unlock();
        Assertions.assertTrue((boolean)finishLatch.await(5000L, TimeUnit.MILLISECONDS));
    }

    @Test
    void testLockAfterClosing() {
        StorageBasedLockProvider provider1 = this.createLockProvider();
        Assertions.assertTrue((boolean)provider1.tryLock(), (String)"Provider1 should acquire the lock immediately");
        provider1.unlock();
        provider1.close();
        Assertions.assertThrows(HoodieLockException.class, () -> ((StorageBasedLockProvider)provider1).tryLock());
    }

    @Test
    void testCloseBeforeUnlocking() {
        StorageBasedLockProvider provider1 = this.createLockProvider();
        Assertions.assertTrue((boolean)provider1.tryLock(), (String)"Provider1 should acquire the lock immediately");
        provider1.close();
        provider1.unlock();
        Assertions.assertThrows(HoodieLockException.class, () -> ((StorageBasedLockProvider)provider1).tryLock());
    }

    @Test
    void testUnlockWhenNoLockPresent() {
        this.lockProvider.unlock();
        Assertions.assertNull((Object)this.lockProvider.getLock());
    }

    @Test
    void testTryLockHappyPath() {
        Assertions.assertTrue((boolean)this.lockProvider.tryLock(), (String)"tryLock should succeed if lock not held");
        Assertions.assertNotNull((Object)this.lockProvider.getLock(), (String)"Lock should be held after tryLock");
    }

    @Test
    void testTryLockReentrancy() {
        Assertions.assertTrue((boolean)this.lockProvider.tryLock(), (String)"tryLock should succeed if lock not held");
        Assertions.assertTrue((boolean)this.lockProvider.tryLock(), (String)"tryLock should succeed again");
    }

    @Test
    void testUnlockAndLock() {
        Assertions.assertTrue((boolean)this.lockProvider.tryLock(), (String)"tryLock should succeed if lock not held");
        Assertions.assertNotNull((Object)this.lockProvider.getLock());
        this.lockProvider.unlock();
        Assertions.assertNull((Object)this.lockProvider.getLock(), (String)"Lock should be null after unlock");
        Assertions.assertTrue((boolean)this.lockProvider.tryLock(), (String)"tryLock should succeed if lock not held");
        Assertions.assertNotNull((Object)this.lockProvider.getLock());
    }

    @Test
    void testIdempotentUnlock() {
        Assertions.assertTrue((boolean)this.lockProvider.tryLock(), (String)"tryLock should succeed if lock not held");
        this.lockProvider.unlock();
        this.lockProvider.unlock();
    }

    @Test
    void testLockReacquisitionInLoop() {
        for (int i = 0; i < 100; ++i) {
            Assertions.assertTrue((boolean)this.lockProvider.tryLock(), (String)"tryLock should succeed if lock not held");
            Assertions.assertNotNull((Object)this.lockProvider.getLock(), (String)("Lock should be held after acquisition in iteration " + i));
            this.lockProvider.unlock();
            Assertions.assertNull((Object)this.lockProvider.getLock(), (String)("Lock should be null after unlock in iteration " + i));
        }
    }

    @Test
    void testMultipleLockProvidersContention() throws InterruptedException {
        int i;
        int NUM_THREADS = 10;
        ArrayList<StorageBasedLockProvider> providers = new ArrayList<StorageBasedLockProvider>();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        AtomicBoolean stopFlag = new AtomicBoolean(false);
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch threadsCompleteLatch = new CountDownLatch(10);
        ArrayList<Integer> sharedList = new ArrayList<Integer>();
        for (i = 0; i < 1000; ++i) {
            sharedList.add(i);
        }
        for (i = 0; i < 10; ++i) {
            providers.add(this.createLockProvider());
        }
        for (i = 0; i < 10; ++i) {
            StorageBasedLockProvider provider = (StorageBasedLockProvider)providers.get(i);
            int threadId = i;
            Thread t = new Thread(() -> {
                try {
                    startLatch.await();
                    while (!stopFlag.get()) {
                        if (provider.tryLock()) {
                            try {
                                sharedList.removeIf(val -> val % (threadId + 1) == 0);
                                for (int j = 0; j < 1000; ++j) {
                                    if (j % (threadId + 1) != 0) continue;
                                    sharedList.add(j);
                                }
                                sharedList.sort(Integer::compareTo);
                            }
                            finally {
                                provider.unlock();
                            }
                        }
                        Thread.yield();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                threadsCompleteLatch.countDown();
            }, "LockProviderThread-" + i);
            threads.add(t);
        }
        threads.forEach(Thread::start);
        startLatch.countDown();
        Thread.sleep(3000L);
        stopFlag.set(true);
        for (Thread t : threads) {
            t.join();
        }
        providers.forEach(StorageBasedLockProvider::close);
        Assertions.assertTrue((boolean)threadsCompleteLatch.await(6L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)1000, (int)sharedList.size(), (String)"List should contain 1000 elements");
        for (int i2 = 0; i2 < 1000; ++i2) {
            Assertions.assertEquals((int)i2, (Integer)((Integer)sharedList.get(i2)), (String)"List should contain all numbers 0 to 999 in order");
        }
    }
}

