/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import org.apache.hudi.client.transaction.lock.metrics.HoodieLockMetrics;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.storage.HoodieStorage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestHoodieLockMetrics {
    @Test
    public void testMetricsHappyPath() {
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().withPath("/gdsafsd").withReporterType(MetricsReporterType.INMEMORY.name()).withLockingMetrics(true).build();
        HoodieLockMetrics lockMetrics = new HoodieLockMetrics(HoodieWriteConfig.newBuilder().forTable("idk").withPath("/dsfasdf/asdf").withMetricsConfig(metricsConfig).build(), storage);
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).startLockApiTimerContext());
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockAcquiredMetric());
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockHeldTimerMetrics());
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).startLockApiTimerContext());
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockNotAcquiredMetric());
    }

    @Test
    public void testMetricsMisses() {
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().withPath("/gdsafsd").withReporterType(MetricsReporterType.INMEMORY.name()).withLockingMetrics(true).build();
        HoodieLockMetrics lockMetrics = new HoodieLockMetrics(HoodieWriteConfig.newBuilder().forTable("idk").withPath("/dsfasdf/asdf").withMetricsConfig(metricsConfig).build(), storage);
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockHeldTimerMetrics());
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockNotAcquiredMetric());
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockAcquiredMetric());
    }
}

