/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.apache.hudi.client.timeline.versioning.v2.LSMTimelineWriter;
import org.apache.hudi.client.utils.LegacyArchivedMetaEntryReader;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.BootstrapIndexType;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.ActiveAction;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.timeline.versioning.v1.ActiveTimelineV1;
import org.apache.hudi.common.table.timeline.versioning.v1.CommitMetadataSerDeV1;
import org.apache.hudi.common.table.timeline.versioning.v2.ActiveTimelineV2;
import org.apache.hudi.common.table.timeline.versioning.v2.CommitMetadataSerDeV2;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngradeUtils;
import org.apache.hudi.table.upgrade.UpgradeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SevenToEightUpgradeHandler
implements UpgradeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SevenToEightUpgradeHandler.class);

    @Override
    public Map<ConfigProperty, String> upgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        List instants;
        HashMap<ConfigProperty, String> tablePropsToAdd = new HashMap<ConfigProperty, String>();
        HoodieTable table = upgradeDowngradeHelper.getTable(config, context);
        HoodieTableMetaClient metaClient = table.getMetaClient();
        HoodieTableConfig tableConfig = metaClient.getTableConfig();
        if (!config.autoUpgrade()) {
            ValidationUtils.checkState((table.isMetadataTable() || !config.isMetadataTableEnabled() ? 1 : 0) != 0, (String)("Metadata table should be disabled to write in table version SIX using 1.0.0+" + metaClient.getBasePath()));
            config.setValue(HoodieWriteConfig.WRITE_TABLE_VERSION, String.valueOf(HoodieTableVersion.SIX.versionCode()));
            return tablePropsToAdd;
        }
        if (!table.isMetadataTable() && config.isMetadataTableEnabled() && SevenToEightUpgradeHandler.isMetadataTableBehindDataTable(config, metaClient)) {
            HoodieTableMetadataUtil.deleteMetadataTable((String)config.getBasePath(), (HoodieEngineContext)context);
        }
        UpgradeDowngradeUtils.rollbackFailedWritesAndCompact(table, context, config, upgradeDowngradeHelper, HoodieTableType.MERGE_ON_READ.equals((Object)table.getMetaClient().getTableType()), HoodieTableVersion.SIX);
        try {
            HoodieTableMetaClient.createTableLayoutOnStorage((StorageConfiguration)context.getStorageConf(), (StoragePath)new StoragePath(config.getBasePath()), (Properties)config.getProps(), (Integer)TimelineLayoutVersion.VERSION_2, (boolean)false);
        }
        catch (IOException e) {
            LOG.error("Failed to create table layout on storage for timeline layout version {}", (Object)TimelineLayoutVersion.VERSION_2, (Object)e);
            throw new HoodieIOException("Failed to create table layout on storage", e);
        }
        tablePropsToAdd.put(HoodieTableConfig.TIMELINE_PATH, (String)HoodieTableConfig.TIMELINE_PATH.defaultValue());
        SevenToEightUpgradeHandler.upgradePartitionFields(config, tableConfig, tablePropsToAdd);
        SevenToEightUpgradeHandler.upgradeMergeMode(tableConfig, tablePropsToAdd);
        SevenToEightUpgradeHandler.setInitialVersion(tableConfig, tablePropsToAdd);
        SevenToEightUpgradeHandler.upgradeKeyGeneratorType(tableConfig, tablePropsToAdd);
        SevenToEightUpgradeHandler.upgradeBootstrapIndexType(tableConfig, tablePropsToAdd);
        try {
            instants = metaClient.scanHoodieInstantsFromFileSystem(metaClient.getTimelinePath(), ActiveTimelineV1.VALID_EXTENSIONS_IN_ACTIVE_TIMELINE, false);
        }
        catch (IOException ioe) {
            LOG.error("Failed to get instants from filesystem", (Throwable)ioe);
            throw new HoodieIOException("Failed to get instants from filesystem", ioe);
        }
        if (!instants.isEmpty()) {
            InstantFileNameGenerator instantFileNameGenerator = metaClient.getInstantFileNameGenerator();
            CommitMetadataSerDeV2 commitMetadataSerDeV2 = new CommitMetadataSerDeV2();
            CommitMetadataSerDeV1 commitMetadataSerDeV1 = new CommitMetadataSerDeV1();
            ActiveTimelineV2 activeTimelineV2 = new ActiveTimelineV2(metaClient);
            context.map(instants, (SerializableFunction & Serializable)instant -> {
                String originalFileName = instantFileNameGenerator.getFileName(instant);
                return SevenToEightUpgradeHandler.upgradeActiveTimelineInstant(instant, originalFileName, metaClient, commitMetadataSerDeV1, commitMetadataSerDeV2, activeTimelineV2);
            }, instants.size());
        }
        SevenToEightUpgradeHandler.upgradeToLSMTimeline(table, context, config);
        return tablePropsToAdd;
    }

    private static boolean isMetadataTableBehindDataTable(HoodieWriteConfig config, HoodieTableMetaClient metaClient) {
        if (!metaClient.getTableConfig().isMetadataTableAvailable()) {
            return false;
        }
        HoodieInstant lastCommitInstantInDataTable = (HoodieInstant)metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant().orElse(null);
        HoodieTableMetaClient metadataTableMetaClient = HoodieTableMetaClient.builder().setConf(metaClient.getStorageConf().newInstance()).setBasePath(HoodieTableMetadata.getMetadataTableBasePath((String)config.getBasePath())).build();
        HoodieInstant lastCommitInstantInMetadataTable = (HoodieInstant)metadataTableMetaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant().orElse(null);
        return lastCommitInstantInDataTable != null && lastCommitInstantInMetadataTable != null && InstantComparison.compareTimestamps((String)lastCommitInstantInMetadataTable.requestedTime(), (BiPredicate)InstantComparison.LESSER_THAN, (String)lastCommitInstantInDataTable.requestedTime());
    }

    static void upgradePartitionFields(HoodieWriteConfig config, HoodieTableConfig tableConfig, Map<ConfigProperty, String> tablePropsToAdd) {
        String keyGenerator = tableConfig.getKeyGeneratorClassName();
        String partitionPathField = config.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key());
        if (keyGenerator != null && partitionPathField != null && (keyGenerator.equals(KeyGeneratorType.CUSTOM.getClassName()) || keyGenerator.equals(KeyGeneratorType.CUSTOM_AVRO.getClassName()))) {
            tablePropsToAdd.put(HoodieTableConfig.PARTITION_FIELDS, partitionPathField);
        }
    }

    static void upgradeMergeMode(HoodieTableConfig tableConfig, Map<ConfigProperty, String> tablePropsToAdd) {
        if (tableConfig.getPayloadClass() != null && tableConfig.getPayloadClass().equals(OverwriteWithLatestAvroPayload.class.getName())) {
            if (HoodieTableType.COPY_ON_WRITE == tableConfig.getTableType()) {
                tablePropsToAdd.put(HoodieTableConfig.RECORD_MERGE_MODE, RecordMergeMode.COMMIT_TIME_ORDERING.name());
            } else {
                tablePropsToAdd.put(HoodieTableConfig.PAYLOAD_CLASS_NAME, DefaultHoodieRecordPayload.class.getName());
                tablePropsToAdd.put(HoodieTableConfig.RECORD_MERGE_MODE, RecordMergeMode.EVENT_TIME_ORDERING.name());
            }
        }
    }

    static void setInitialVersion(HoodieTableConfig tableConfig, Map<ConfigProperty, String> tablePropsToAdd) {
        if (tableConfig.contains(HoodieTableConfig.VERSION)) {
            tablePropsToAdd.put(HoodieTableConfig.INITIAL_VERSION, String.valueOf(tableConfig.getTableVersion().versionCode()));
        } else {
            tablePropsToAdd.put(HoodieTableConfig.INITIAL_VERSION, String.valueOf(HoodieTableVersion.SIX.versionCode()));
        }
    }

    static void upgradeBootstrapIndexType(HoodieTableConfig tableConfig, Map<ConfigProperty, String> tablePropsToAdd) {
        String bootstrapIndexClass;
        if ((tableConfig.contains(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME) || tableConfig.contains(HoodieTableConfig.BOOTSTRAP_INDEX_TYPE)) && StringUtils.nonEmpty((String)(bootstrapIndexClass = BootstrapIndexType.getBootstrapIndexClassName((HoodieConfig)tableConfig)))) {
            tablePropsToAdd.put(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME, bootstrapIndexClass);
            tablePropsToAdd.put(HoodieTableConfig.BOOTSTRAP_INDEX_TYPE, BootstrapIndexType.fromClassName((String)bootstrapIndexClass).name());
        }
    }

    static void upgradeKeyGeneratorType(HoodieTableConfig tableConfig, Map<ConfigProperty, String> tablePropsToAdd) {
        String keyGenerator = tableConfig.getKeyGeneratorClassName();
        if (StringUtils.nonEmpty((String)keyGenerator)) {
            tablePropsToAdd.put(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME, keyGenerator);
            tablePropsToAdd.put(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.fromClassName((String)keyGenerator).name());
        }
    }

    static void upgradeToLSMTimeline(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig config) {
        table.getMetaClient().getTableConfig().getTimelineLayoutVersion().ifPresent(timelineLayoutVersion -> ValidationUtils.checkState((boolean)TimelineLayoutVersion.LAYOUT_VERSION_1.equals(timelineLayoutVersion), (String)("Upgrade to LSM timeline is only supported for layout version 1. Given version: " + timelineLayoutVersion)));
        try {
            LegacyArchivedMetaEntryReader reader = new LegacyArchivedMetaEntryReader(table.getMetaClient());
            StoragePath archivePath = new StoragePath(table.getMetaClient().getMetaPath(), "timeline/history");
            LSMTimelineWriter lsmTimelineWriter = LSMTimelineWriter.getInstance(config, table, (Option<StoragePath>)Option.of((Object)archivePath));
            int batchSize = config.getCommitArchivalBatchSize();
            ArrayList<Object> activeActionsBatch = new ArrayList<Object>(batchSize);
            try (ClosableIterator<ActiveAction> iterator = reader.getActiveActionsIterator();){
                while (iterator.hasNext()) {
                    activeActionsBatch.add(iterator.next());
                    if (activeActionsBatch.size() != batchSize) continue;
                    lsmTimelineWriter.write(new ArrayList<ActiveAction>(activeActionsBatch), (Option<Consumer<ActiveAction>>)Option.empty(), (Option<Consumer<Exception>>)Option.empty());
                    lsmTimelineWriter.compactAndClean(engineContext);
                    activeActionsBatch.clear();
                }
                if (!activeActionsBatch.isEmpty()) {
                    lsmTimelineWriter.write(new ArrayList<ActiveAction>(activeActionsBatch), (Option<Consumer<ActiveAction>>)Option.empty(), (Option<Consumer<Exception>>)Option.empty());
                    lsmTimelineWriter.compactAndClean(engineContext);
                }
            }
        }
        catch (Exception e) {
            if (config.isFailOnTimelineArchivingEnabled()) {
                throw new HoodieException("Failed to upgrade to LSM timeline", (Throwable)e);
            }
            LOG.warn("Failed to upgrade to LSM timeline");
        }
    }

    static boolean upgradeActiveTimelineInstant(HoodieInstant instant, String originalFileName, HoodieTableMetaClient metaClient, CommitMetadataSerDeV1 commitMetadataSerDeV1, CommitMetadataSerDeV2 commitMetadataSerDeV2, ActiveTimelineV2 activeTimelineV2) {
        String replacedFileName = originalFileName;
        boolean isCompleted = instant.isCompleted();
        if (isCompleted) {
            String completionTime = instant.getCompletionTime();
            String startTime = instant.requestedTime();
            replacedFileName = replacedFileName.replace(startTime, startTime + "_" + completionTime);
        }
        if (UpgradeDowngradeUtils.SIX_TO_EIGHT_TIMELINE_ACTION_MAP.containsKey(instant.getAction()) && !isCompleted) {
            replacedFileName = replacedFileName.replace(instant.getAction(), UpgradeDowngradeUtils.SIX_TO_EIGHT_TIMELINE_ACTION_MAP.get(instant.getAction()));
        }
        try {
            return SevenToEightUpgradeHandler.rewriteTimelineV1InstantFileToV2Format(instant, metaClient, originalFileName, replacedFileName, commitMetadataSerDeV1, commitMetadataSerDeV2, activeTimelineV2);
        }
        catch (IOException e) {
            LOG.warn("Can not to complete the upgrade from version seven to version eight. The reason for failure is {}", (Object)e.getMessage());
            return false;
        }
    }

    static boolean rewriteTimelineV1InstantFileToV2Format(HoodieInstant instant, HoodieTableMetaClient metaClient, String originalFileName, String replacedFileName, CommitMetadataSerDeV1 commitMetadataSerDeV1, CommitMetadataSerDeV2 commitMetadataSerDeV2, ActiveTimelineV2 activeTimelineV2) throws IOException {
        StoragePath fromPath = new StoragePath(TimelineLayout.TIMELINE_LAYOUT_V1.getTimelinePathProvider().getTimelinePath(metaClient.getTableConfig(), metaClient.getBasePath()), originalFileName);
        StoragePath toPath = new StoragePath(TimelineLayout.TIMELINE_LAYOUT_V2.getTimelinePathProvider().getTimelinePath(metaClient.getTableConfig(), metaClient.getBasePath()), replacedFileName);
        boolean success = true;
        if (instant.getAction().equals("commit") || instant.getAction().equals("deltacommit") || instant.getAction().equals("replacecommit") && instant.isCompleted()) {
            Class clazz = instant.getAction().equals("replacecommit") ? HoodieReplaceCommitMetadata.class : HoodieCommitMetadata.class;
            HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)commitMetadataSerDeV1.deserialize(instant, (byte[])metaClient.getActiveTimeline().getInstantDetails(instant).get(), clazz);
            Option data = commitMetadataSerDeV2.serialize(commitMetadata);
            String toPathStr = toPath.toUri().toString();
            activeTimelineV2.createFileInMetaPath(toPathStr, data, true);
            metaClient.getStorage().deleteFile(fromPath);
        } else {
            success = metaClient.getStorage().rename(fromPath, toPath);
        }
        if (!success) {
            throw new HoodieIOException("an error that occurred while renaming " + fromPath + " to: " + toPath);
        }
        return true;
    }
}

