/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.ttl.strategy;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.ttl.strategy.KeepByTimeStrategy;

public class KeepByCreationTimeStrategy
extends KeepByTimeStrategy {
    public KeepByCreationTimeStrategy(HoodieTable hoodieTable, String instantTime) {
        super(hoodieTable, instantTime);
    }

    @Override
    protected List<String> getExpiredPartitionsForTimeStrategy(List<String> partitionPathsForTTL) {
        HoodieTableMetaClient metaClient = this.hoodieTable.getMetaClient();
        return ((Stream)partitionPathsForTTL.stream().parallel()).filter(part -> {
            HoodiePartitionMetadata hoodiePartitionMetadata = new HoodiePartitionMetadata(metaClient.getStorage(), FSUtils.constructAbsolutePath((StoragePath)metaClient.getBasePath(), (String)part));
            Option instantOption = hoodiePartitionMetadata.readPartitionCreatedCommitTime();
            if (instantOption.isPresent()) {
                String instantTime = (String)instantOption.get();
                return this.isPartitionExpired(instantTime);
            }
            return false;
        }).collect(Collectors.toList());
    }
}

